/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.patch.transformer.dynfix;

import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodNode;
import org.sinytra.adapter.patch.analysis.locals.LocalVarAnalyzer;
import org.sinytra.adapter.patch.api.MethodContext;
import org.sinytra.adapter.patch.api.Patch;
import org.sinytra.adapter.patch.api.PatchAuditTrail;
import org.sinytra.adapter.patch.transformer.dynfix.DynamicFixer;
import org.sinytra.adapter.patch.util.AdapterUtil;

public class DynFixLocalCaptureUpgrade
implements DynamicFixer<Data> {
    @Override
    @Nullable
    public Data prepare(MethodContext methodContext) {
        if (methodContext.findDirtyInjectionTarget() == null) {
            return null;
        }
        MethodNode methodNode = methodContext.getMixinMethod();
        if (!methodContext.capturesLocals()) {
            return null;
        }
        Type[] paramTypes = Type.getArgumentTypes((String)methodNode.desc);
        List<Pair> localAnnotations = AdapterUtil.getAnnotatedParameters(methodNode, paramTypes, "Lcom/llamalad7/mixinextras/sugar/Local;", Pair::of);
        if (!localAnnotations.isEmpty()) {
            return null;
        }
        LocalVarAnalyzer.CapturedLocalsInfo info = LocalVarAnalyzer.getCapturedLocals(methodContext);
        if (info == null || info.diff().isEmpty()) {
            return null;
        }
        LocalVarAnalyzer.CapturedLocalsTransform transform = LocalVarAnalyzer.analyzeCapturedLocals(info.capturedLocals(), methodNode);
        ArrayList<Type> availableTypes = new ArrayList<Type>(info.availableTypes());
        for (LocalVariableNode node : transform.usedLocalNodes()) {
            Type expected = Type.getType((String)node.desc);
            List<Type> available = availableTypes.stream().filter(arg_0 -> ((Type)expected).equals(arg_0)).toList();
            if (available.size() != 1) {
                return null;
            }
            availableTypes.remove(available.getFirst());
        }
        return new Data(info.capturedLocals(), transform);
    }

    @Override
    @Nullable
    public DynamicFixer.FixResult apply(ClassNode classNode, MethodNode methodNode, MethodContext methodContext, PatchAuditTrail auditTrail, Data data) {
        Patch.Result result = data.transform().remover().apply(methodContext);
        if (result == Patch.Result.PASS) {
            return null;
        }
        int start = data.capturedLocals().paramLocalStart();
        Type[] args = Type.getArgumentTypes((String)methodNode.desc);
        for (int i = start; i < args.length; ++i) {
            methodNode.visitParameterAnnotation(i, "Lcom/llamalad7/mixinextras/sugar/Local;", false);
        }
        auditTrail.recordAudit((Object)this, methodContext, "Upgrade captured locals", new Object[0]);
        return DynamicFixer.FixResult.of(result, PatchAuditTrail.Match.FULL);
    }

    public record Data(AdapterUtil.CapturedLocals capturedLocals, LocalVarAnalyzer.CapturedLocalsTransform transform) {
    }
}

