/*
 * Decompiled with CFR 0.152.
 */
package org.sinytra.adapter.next.type;

import java.util.List;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.Type;
import org.sinytra.adapter.next.env.MixinContext;
import org.sinytra.adapter.next.env.ann.AtData;
import org.sinytra.adapter.next.env.ann.ClassTarget;
import org.sinytra.adapter.next.env.ann.ModifyArgMixinData;
import org.sinytra.adapter.next.env.param.MethodParameters;
import org.sinytra.adapter.next.pipeline.Recipe;
import org.sinytra.adapter.next.pipeline.config.Configuration;
import org.sinytra.adapter.next.pipeline.config.MutableConfiguration;
import org.sinytra.adapter.next.type.MixinType;
import org.sinytra.adapter.patch.analysis.selector.AnnotationHandle;
import org.sinytra.adapter.patch.analysis.selector.AnnotationValueHandle;
import org.sinytra.adapter.patch.fixes.TypeAdapter;
import org.sinytra.adapter.patch.util.MethodQualifier;

public class ModifyArgMixin
implements MixinType<ModifyArgMixinData> {
    @Override
    public ModifyArgMixinData parse(MixinContext context, ClassTarget targetClass, MethodQualifier targetMethod, AtData atData, AnnotationHandle handle) {
        Integer index = handle.getValue("index").map(AnnotationValueHandle::get).orElse(null);
        return new ModifyArgMixinData(targetClass, targetMethod, atData, index);
    }

    @Override
    public void preProcess(ModifyArgMixinData mixin, MixinContext context, MutableConfiguration clean, Recipe recipe) {
        clean.setParameters(MethodParameters.create(context.methodNode(), List.of(MethodParameters.ParamGroup.SINGLE_ANY)));
        mixin.index().ifPresent(i -> clean.setProperty("index", i));
    }

    @Override
    public void postProcess(ModifyArgMixinData mixin, MixinContext context, Configuration clean, MutableConfiguration dirty, Recipe recipe) {
        Type type;
        if (clean.getAtData().equals(dirty.getAtData())) {
            dirty.inheritParameters();
            dirty.inheritReturnType();
            return;
        }
        if (clean.hasProperty("index") && !dirty.hasProperty("index")) {
            dirty.setProperty("index", clean.getProperty("index").orElseThrow());
        }
        if ((type = ModifyArgMixin.findArgType(context, recipe.clean().getAtData(), dirty.getAtData(), dirty)) != null) {
            MethodParameters parameters = MethodParameters.create(context.methodNode(), List.of(MethodParameters.ParamGroup.SINGLE_ANY));
            parameters.set(MethodParameters.ParamGroup.SINGLE_ANY, List.of(type));
            dirty.setParameters(parameters);
            dirty.setReturnType(type);
        }
    }

    @Nullable
    private static Type findArgType(MixinContext context, AtData cleanAtData, AtData atData, Configuration dirty) {
        MethodQualifier cleanQualifier = cleanAtData.getTarget().flatMap(MethodQualifier::create).orElse(null);
        MethodQualifier dirtyQualifier = atData.getTarget().flatMap(MethodQualifier::create).orElse(null);
        if (cleanQualifier != null && dirtyQualifier != null) {
            List<Type> cleanArgs = MethodParameters.getParameterTypes(cleanQualifier.desc());
            List<Type> dirtyArgs = MethodParameters.getParameterTypes(dirtyQualifier.desc());
            if (dirty.hasProperty("index")) {
                int dirtyIndex = (Integer)dirty.getProperty("index").orElseThrow();
                return dirtyIndex < dirtyArgs.size() ? dirtyArgs.get(dirtyIndex) : null;
            }
            if (cleanArgs.size() == 1 && dirtyArgs.size() == 1) {
                if (cleanArgs.getFirst().equals((Object)dirtyArgs.getFirst())) {
                    return dirtyArgs.getFirst();
                }
                Type dirtyType = dirtyArgs.getFirst();
                TypeAdapter adapter = context.getTypeAdapter(cleanArgs.getFirst(), dirtyType);
                if (adapter != null) {
                    return dirtyType;
                }
            }
        }
        return null;
    }
}

