/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.network;

import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.block.entity.CreativeBarteringBlockEntity;
import com.epherical.shoppy.menu.bartering.BarteringMenu;
import com.epherical.shoppy.menu.bartering.BarteringMenuOwner;
import com.epherical.shoppy.network.payloads.AddItemRequestPayload;
import com.epherical.shoppy.network.payloads.PriceSubmissionPayload;
import com.epherical.shoppy.network.payloads.PurchaseAttemptPayload;
import com.epherical.shoppy.network.payloads.SetSaleItemPayload;
import com.epherical.shoppy.network.payloads.StockTransferPayload;
import com.epherical.shoppy.network.payloads.ToggleAutomationPayload;
import com.mojang.logging.LogUtils;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.slf4j.Logger;

public class ServerPayloadHandler {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void handle(AddItemRequestPayload payload, IPayloadContext ctx) {
        Player player = ctx.player();
        BlockEntity be = player.level().getBlockEntity(payload.pos());
        if (be instanceof BarteringBlockEntity) {
            BarteringBlockEntity bbe = (BarteringBlockEntity)be;
            AbstractContainerMenu abstractContainerMenu = player.containerMenu;
            if (abstractContainerMenu instanceof BarteringMenuOwner) {
                BarteringMenuOwner bartering = (BarteringMenuOwner)abstractContainerMenu;
                if (bbe.getOwner().equals(player.getUUID())) {
                    player.openMenu((MenuProvider)new SimpleMenuProvider((id, inv, p) -> BarteringMenuOwner.barteringOwner(id, bartering.getBlockPos(), true, bartering.getContainerData()), bbe.getName()), buf -> {
                        buf.writeBlockPos(bartering.getBlockPos());
                        buf.writeBoolean(true);
                    });
                } else {
                    LOGGER.warn("Player {} tried to open a bartering block as an owner and they aren't the owner... ", (Object)player.getScoreboardName());
                }
            }
        }
    }

    public static void handle(SetSaleItemPayload payload, IPayloadContext ctx) {
        Player player = ctx.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof BarteringMenuOwner) {
            BarteringMenuOwner bartering = (BarteringMenuOwner)abstractContainerMenu;
            BlockEntity be = player.level().getBlockEntity(bartering.getBlockPos());
            if (!(be instanceof BarteringBlockEntity)) {
                return;
            }
            BarteringBlockEntity bbe = (BarteringBlockEntity)be;
            if (!bbe.getOwner().equals(player.getUUID())) {
                LOGGER.warn("Player {} tried to change sale item but is not owner", (Object)player.getScoreboardName());
                return;
            }
            ItemStack copy = payload.stack().copyWithCount(1);
            if (!(bbe.getSaleItemCount() <= 0 && bbe.getCurrencyItemCount() <= 0 || bbe instanceof CreativeBarteringBlockEntity)) {
                player.sendSystemMessage((Component)Component.translatable((String)"message.shoppy.cannot_change_items_with_stock"));
                return;
            }
            if (payload.currency()) {
                bbe.setCurrency(copy);
                player.sendSystemMessage((Component)Component.literal((String)"Set the currency item successfully"));
            } else {
                bbe.setSaleItem(copy);
                player.sendSystemMessage((Component)Component.literal((String)"Set the sale item successfully"));
            }
            bbe.setChanged();
            ServerPlayer player1 = (ServerPlayer)player;
            player.closeContainer();
            ServerPayloadHandler.broadcastUpdate(bbe, player1);
        }
    }

    private static void broadcastUpdate(BarteringBlockEntity bbe, ServerPlayer player1) {
        ServerLevel level = (ServerLevel)player1.level();
        ChunkPos pos = new ChunkPos(bbe.getBlockPos());
        List players = level.getChunkSource().chunkMap.getPlayers(pos, false);
        for (ServerPlayer serverPlayer : players) {
            Packet<ClientGamePacketListener> updatePacket = bbe.getUpdatePacket();
            serverPlayer.connection.send(updatePacket);
        }
    }

    public static void handle(PriceSubmissionPayload payload, IPayloadContext ctx) {
        Player player = ctx.player();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof BarteringMenuOwner)) {
            return;
        }
        BarteringMenuOwner menu = (BarteringMenuOwner)abstractContainerMenu;
        BlockEntity be = player.level().getBlockEntity(menu.getBlockPos());
        if (!(be instanceof BarteringBlockEntity)) {
            return;
        }
        BarteringBlockEntity bbe = (BarteringBlockEntity)be;
        if (!bbe.getOwner().equals(player.getUUID())) {
            return;
        }
        if (payload.price() == 0) {
            return;
        }
        if (payload.received() == 0) {
            return;
        }
        bbe.setOffer(payload.offerIndex(), payload.price(), payload.received());
        bbe.setChanged();
        ServerPlayer player1 = (ServerPlayer)player;
        menu.setEditing(false);
        ServerPayloadHandler.broadcastUpdate(bbe, player1);
        MenuProvider menuProvider = bbe.getBlockState().getMenuProvider(player1.level(), bbe.getBlockPos());
        if (menuProvider != null) {
            player1.openMenu(menuProvider, buf -> {
                buf.writeBlockPos(bbe.getBlockPos());
                buf.writeBoolean(false);
            });
        }
    }

    public static void handle(PurchaseAttemptPayload payload, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        int idx = payload.offerIndex();
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (!(abstractContainerMenu instanceof BarteringMenu)) {
            return;
        }
        BarteringMenu bartering = (BarteringMenu)abstractContainerMenu;
        BarteringBlockEntity be = (BarteringBlockEntity)player.level().getBlockEntity(bartering.getBlockPos());
        if (be == null) {
            return;
        }
        be.tryPurchase((Player)player, idx);
        ServerPayloadHandler.broadcastUpdate(be, player);
    }

    public static void handle(StockTransferPayload payload, IPayloadContext ctx) {
        ItemStack template;
        ServerPlayer player = (ServerPlayer)ctx.player();
        BlockEntity blockEntity = player.level().getBlockEntity(payload.pos());
        if (!(blockEntity instanceof BarteringBlockEntity)) {
            return;
        }
        BarteringBlockEntity shop = (BarteringBlockEntity)blockEntity;
        if (!shop.getOwner().equals(player.getUUID())) {
            return;
        }
        boolean saleSide = payload.saleSide();
        boolean inserting = payload.insert();
        if (!saleSide && inserting) {
            return;
        }
        ItemStack itemStack = template = saleSide ? shop.getSaleItem() : shop.getCurrencyItem();
        if (template.isEmpty()) {
            return;
        }
        int moved = 0;
        if (inserting) {
            int free = shop.getFreeSlots();
            if (free <= 0) {
                return;
            }
            for (ItemStack inv : player.getInventory().items) {
                if (!ItemStack.isSameItem((ItemStack)inv, (ItemStack)template) || inv.getCount() <= 0) continue;
                int take = Math.min(inv.getCount(), free - moved);
                inv.shrink(take);
                if ((moved += take) < free) continue;
                break;
            }
            if (moved == 0) {
                return;
            }
            if (saleSide) {
                shop.addSaleItems(moved);
            } else {
                shop.addCurrencyItems(moved);
            }
        } else {
            int available;
            int n = available = saleSide ? shop.getSaleItemCount() : shop.getCurrencyItemCount();
            if (available <= 0) {
                return;
            }
            moved = Math.min(available, template.getMaxStackSize());
            ItemStack give = template.copy();
            give.setCount(moved);
            if (!player.getInventory().add(give)) {
                player.drop(give, false);
            }
            if (saleSide) {
                shop.addSaleItems(-moved);
            } else {
                shop.addCurrencyItems(-moved);
            }
        }
        shop.setChanged();
        player.containerMenu.broadcastChanges();
        ServerPayloadHandler.broadcastUpdate(shop, player);
    }

    public static void handle(ToggleAutomationPayload payload, IPayloadContext ctx) {
        ServerPlayer player = (ServerPlayer)ctx.player();
        BlockEntity blockEntity = player.level().getBlockEntity(payload.pos());
        if (!(blockEntity instanceof BarteringBlockEntity)) {
            return;
        }
        BarteringBlockEntity shop = (BarteringBlockEntity)blockEntity;
        if (!shop.getOwner().equals(player.getUUID())) {
            return;
        }
        switch (payload.target()) {
            case INSERT: {
                shop.setAllowInsert(!shop.isInsertAllowed());
                break;
            }
            case EXTRACT: {
                shop.setAllowExtract(!shop.isExtractAllowed());
            }
        }
        shop.setChanged();
        ServerPayloadHandler.broadcastUpdate(shop, player);
    }
}

