/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.commands;

import com.epherical.shoppy.block.entity.Ownable;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.Util;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.block.entity.BlockEntity;

public final class ShopOwnerCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"shopowner").requires(src -> src.hasPermission(4))).then(Commands.literal((String)"clear").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ShopOwnerCommand.setOwner((CommandContext<CommandSourceStack>)ctx, false))))).then(Commands.literal((String)"set").then(Commands.argument((String)"pos", (ArgumentType)BlockPosArgument.blockPos()).executes(ctx -> ShopOwnerCommand.setOwner((CommandContext<CommandSourceStack>)ctx, true)))));
    }

    private static int setOwner(CommandContext<CommandSourceStack> ctx, boolean toPlayer) throws CommandSyntaxException {
        BlockPos pos;
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        BlockEntity be = level.getBlockEntity(pos = BlockPosArgument.getLoadedBlockPos(ctx, (String)"pos"));
        if (!(be instanceof Ownable)) {
            ((CommandSourceStack)ctx.getSource()).sendFailure((Component)Component.literal((String)("No ownable shop at " + String.valueOf(pos))));
            return 0;
        }
        Ownable ownable = (Ownable)be;
        if (toPlayer) {
            ownable.setOwner(((CommandSourceStack)ctx.getSource()).getPlayerOrException().getUUID());
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Owner set to you"), true);
        } else {
            ownable.setOwner(Util.NIL_UUID);
            ((CommandSourceStack)ctx.getSource()).sendSuccess(() -> Component.literal((String)"Owner cleared"), true);
        }
        be.setChanged();
        return 1;
    }

    private ShopOwnerCommand() {
    }
}

