/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.widget;

import java.util.List;
import java.util.Optional;
import java.util.function.IntConsumer;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ShopItemWidget
extends AbstractWidget {
    private static final int ITEM_SIZE = 16;
    private static final int TEXT_Y_OFF = 6;
    private static final int COUNT_PAD_X = 16;
    private final Supplier<ItemStack> stackSupplier;
    private final IntSupplier countSupplier;
    private final IntConsumer onClick;
    private final MutableComponent contents;

    public ShopItemWidget(int x, int y, Supplier<ItemStack> stackSupplier, IntSupplier countSupplier, IntConsumer onClick, MutableComponent contents) {
        super(x, y, 16, 16, (Component)Component.empty());
        this.stackSupplier = stackSupplier;
        this.countSupplier = countSupplier;
        this.onClick = onClick;
        this.contents = contents;
    }

    protected void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        ItemStack stack = this.stackSupplier.get();
        if (stack.isEmpty()) {
            return;
        }
        g.renderItem(stack, this.getX(), this.getY());
        String txt = String.valueOf(this.countSupplier.getAsInt());
        g.drawString(Minecraft.getInstance().font, "x" + txt, this.getX() + 16, this.getY() + 6, 0xFFFFFF, false);
        if (this.isHoveredOrFocused()) {
            List lines = stack.getTooltipLines(Item.TooltipContext.of((Level)Minecraft.getInstance().player.level()), (Player)Minecraft.getInstance().player, (TooltipFlag)(Minecraft.getInstance().options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
            lines.add(this.contents);
            g.renderTooltip(Minecraft.getInstance().font, lines, Optional.empty(), mouseX, mouseY);
        }
    }

    public void setFocused(boolean focused) {
    }

    protected boolean isValidClickButton(int button) {
        return button == 1 || button == 0;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (super.mouseClicked(mouseX, mouseY, button)) {
            this.onClick.accept(button);
            return true;
        }
        return false;
    }

    protected void updateWidgetNarration(NarrationElementOutput narration) {
    }
}

