/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.widget;

import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.network.payloads.ToggleAutomationPayload;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.neoforge.network.PacketDistributor;

public class InsertToggleButton
extends Button {
    private static final ResourceLocation SPRITE_ENABLED = ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/insert_enabled");
    private static final ResourceLocation SPRITE_DISABLED = ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/insert_disabled");
    private static final ResourceLocation SPRITE_ENABLED_HOVERED = ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/insert_enabled_hovered");
    private static final ResourceLocation SPRITE_DISABLED_HOVERED = ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"widget/insert_disabled_hovered");
    private final BarteringBlockEntity bartering;

    public InsertToggleButton(int x, int y, BarteringBlockEntity be) {
        super(x, y, 16, 16, (Component)Component.empty(), btn -> {
            PacketDistributor.sendToServer((CustomPacketPayload)new ToggleAutomationPayload(be.getBlockPos(), ToggleAutomationPayload.Target.INSERT), (CustomPacketPayload[])new CustomPacketPayload[0]);
            be.setAllowInsert(!be.isInsertAllowed());
        }, DEFAULT_NARRATION);
        this.bartering = be;
        this.refreshTooltip();
    }

    public void renderWidget(GuiGraphics g, int mouseX, int mouseY, float partialTick) {
        ResourceLocation sprite = this.bartering.isInsertAllowed() ? SPRITE_ENABLED : SPRITE_DISABLED;
        g.blitSprite(sprite, this.getX(), this.getY(), 16, 16);
        if (this.isHovered()) {
            sprite = this.bartering.isInsertAllowed() ? SPRITE_ENABLED_HOVERED : SPRITE_DISABLED_HOVERED;
            g.blitSprite(sprite, this.getX(), this.getY(), 16, 16);
        }
    }

    private void refreshTooltip() {
        this.setTooltip(Tooltip.create((Component)Component.translatable((String)(this.bartering.isInsertAllowed() ? "tooltip.shoppy.insert_enabled" : "tooltip.shoppy.insert_disabled"))));
    }

    public void onPress() {
        super.onPress();
        this.refreshTooltip();
    }
}

