/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.screens;

import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.client.screens.ShopPickingCreativeInventoryScreen;
import com.epherical.shoppy.client.widget.AddItemButton;
import com.epherical.shoppy.client.widget.ExtractToggleButton;
import com.epherical.shoppy.client.widget.InsertToggleButton;
import com.epherical.shoppy.client.widget.ShopItemWidget;
import com.epherical.shoppy.menu.bartering.BarteringMenuOwner;
import com.epherical.shoppy.network.payloads.AddItemRequestPayload;
import com.epherical.shoppy.network.payloads.PriceSubmissionPayload;
import com.epherical.shoppy.network.payloads.StockTransferPayload;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BarteringScreenOwner
extends AbstractContainerScreen<BarteringMenuOwner> {
    private static final int ITEM_SIZE = 16;
    private static final int SALE_ITEM_X = 26;
    private static final int SALE_ITEM_Y = 48;
    private static final int CURRENCY_ITEM_X = 111;
    private static final int CURRENCY_ITEM_Y = 133;
    private static final int ROW_START_Y = 30;
    private static final int ROW_HEIGHT = 20;
    private static final int ROW_PAD_X = 8;
    private static final int TEXT_Y_OFF = 6;
    private EditBox priceField;
    private EditBox receivedField;
    private BarteringBlockEntity bartering;
    public static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"textures/gui/sprites/container/bartering_page_owner.png");
    private static final Component ADD_ITEM_BTN = Component.translatable((String)"screen.shoppy.add_price");

    public BarteringScreenOwner(BarteringMenuOwner pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.inventoryLabelY = -3000;
    }

    protected void init() {
        super.init();
        this.bartering = (BarteringBlockEntity)this.minecraft.level.getBlockEntity(((BarteringMenuOwner)this.menu).getBlockPos());
        int toggleX = this.leftPos + this.imageWidth - 66;
        int toggleY = this.topPos + 5;
        this.addRenderableWidget((GuiEventListener)new ExtractToggleButton(toggleX, toggleY, this.bartering));
        int insertX = this.leftPos + this.imageWidth - 49;
        int insertY = this.topPos + 5;
        this.addRenderableWidget((GuiEventListener)new InsertToggleButton(insertX, insertY, this.bartering));
        int rows = this.populatedRows();
        int btnX = this.leftPos + (this.imageWidth - 150) / 2;
        int btnY = this.topPos + 30 + rows * 20;
        if (rows < 3 && !((BarteringMenuOwner)this.getMenu()).isEditing()) {
            this.addRenderableWidget((GuiEventListener)AddItemButton.addItem(ADD_ITEM_BTN, b -> PacketDistributor.sendToServer((CustomPacketPayload)new AddItemRequestPayload(((BarteringMenuOwner)this.menu).getBlockPos()), (CustomPacketPayload[])new CustomPacketPayload[0])).size(68, 14).pos(btnX, btnY).build());
        }
        if (((BarteringMenuOwner)this.getMenu()).isEditing()) {
            this.priceField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, btnX + 24, btnY + 2, 30, 14, (Component)Component.literal((String)"Price")));
            this.priceField.setTooltip(Tooltip.create((Component)Component.literal((String)"Price -- The price that the player must pay to 'receive' any items.")));
            this.receivedField = (EditBox)this.addRenderableWidget((GuiEventListener)new EditBox(this.minecraft.font, btnX - 8, btnY + 2, 30, 14, (Component)Component.literal((String)"Received")));
            this.receivedField.setTooltip(Tooltip.create((Component)Component.literal((String)"Received -- What the player will get in return for giving you the price of the item.")));
            Checkbox checkbox1 = (Checkbox)this.addRenderableWidget((GuiEventListener)Checkbox.builder((Component)Component.literal((String)""), (Font)this.minecraft.font).selected(true).pos(btnX + 30 + 25, btnY + 1).onValueChange((checkbox, value) -> this.submitOffer()).build());
            checkbox1.setTooltip(Tooltip.create((Component)Component.literal((String)"Submit the pricing.")));
        }
        btnX = this.leftPos + (this.imageWidth - 150) / 2;
        btnY = this.topPos + 25;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.shoppy.set_item"), button -> this.minecraft.setScreen((Screen)new ShopPickingCreativeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), false, true))).size(60, 14).pos(btnX + 98, btnY + 147 - 80).build());
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"screen.shoppy.set_sold"), button -> this.minecraft.setScreen((Screen)new ShopPickingCreativeInventoryScreen(this.minecraft.player, this.minecraft.player.connection.enabledFeatures(), false, false))).size(60, 14).pos(btnX + 98, btnY + 147 - 14 - 80).build());
        ShopItemWidget saleIcon = new ShopItemWidget(this.leftPos + 111, this.topPos + 133 - 16 - 72, this.bartering::getSaleItem, () -> ((BarteringMenuOwner)this.menu).getContainerData().get(0), btn -> {
            boolean insert = btn == 0;
            PacketDistributor.sendToServer((CustomPacketPayload)new StockTransferPayload(this.bartering.getBlockPos(), true, insert), (CustomPacketPayload[])new CustomPacketPayload[0]);
        }, Component.translatable((String)"tooltip.shoppy.sale_item").withStyle(ChatFormatting.GRAY));
        this.addRenderableWidget((GuiEventListener)saleIcon);
        ShopItemWidget currencyIcon = new ShopItemWidget(this.leftPos + 111, this.topPos + 133 - 72, this.bartering::getCurrencyItem, () -> ((BarteringMenuOwner)this.menu).getContainerData().get(1), button -> PacketDistributor.sendToServer((CustomPacketPayload)new StockTransferPayload(this.bartering.getBlockPos(), false, false), (CustomPacketPayload[])new CustomPacketPayload[0]), Component.translatable((String)"tooltip.shoppy.currency_item").withStyle(ChatFormatting.GRAY));
        this.addRenderableWidget((GuiEventListener)currencyIcon);
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        int left = this.leftPos;
        int top = this.topPos;
        this.renderTooltip(graphics, pMouseX, pMouseY);
        if (this.bartering != null) {
            for (int i = 0; i < 3; ++i) {
                ItemStack curItem;
                int saleCnt = this.bartering.getSaleCount(i);
                int costCnt = this.bartering.getCostCount(i);
                if (saleCnt == 0 && costCnt == 0) continue;
                int rowY = this.topPos + 30 + i * 20;
                left = this.leftPos + 8 - 2;
                int right = this.leftPos + 110 - 8;
                graphics.fill(left, rowY, right, rowY + 20 - 2, -2013265920);
                ItemStack saleItem = this.bartering.getSaleItem();
                if (!saleItem.isEmpty()) {
                    graphics.renderItem(saleItem, left + 4, rowY + 1);
                    graphics.drawString(this.minecraft.font, String.valueOf(saleCnt), left + 4 + 16 + 4, rowY + 6, 0xFFFFFF, false);
                    if (BarteringScreenOwner.isHovering(pMouseX, pMouseY, left + 4, rowY + 1)) {
                        List lines = this.bartering.getSaleItem().getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.player.level()), (Player)this.minecraft.player, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                        lines.add(Component.translatable((String)"tooltip.shoppy.sale_item").withStyle(ChatFormatting.GRAY));
                        graphics.renderTooltip(this.font, lines, Optional.empty(), pMouseX, pMouseY);
                    }
                }
                if ((curItem = this.bartering.getCurrencyItem()).isEmpty()) continue;
                int curX = right - 16 - 40;
                graphics.renderItem(curItem, curX, rowY + 1);
                graphics.drawString(this.minecraft.font, String.valueOf(costCnt), curX + 16 + 4, rowY + 6, 0xFFFFFF, false);
                if (!BarteringScreenOwner.isHovering(pMouseX, pMouseY, curX, rowY + 1)) continue;
                List lines = this.bartering.getCurrencyItem().getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.player.level()), (Player)this.minecraft.player, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                lines.add(Component.translatable((String)"tooltip.shoppy.currency_item").withStyle(ChatFormatting.GRAY));
                graphics.renderTooltip(this.font, lines, Optional.empty(), pMouseX, pMouseY);
            }
        }
    }

    public static boolean isHovering(int mouseX, int mouseY, int x, int y) {
        return mouseX >= x && mouseX < x + 16 && mouseY >= y && mouseY < y + 16;
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        graphics.setColor(1.0f, 1.0f, 1.0f, 1.0f);
        int left = this.leftPos;
        int top = this.topPos;
        graphics.blit(CONTAINER_BACKGROUND, left, top, 0, 0, 176, 191);
    }

    private void submitOffer() {
        int price = BarteringScreenOwner.safeParse(this.priceField.getValue());
        int received = BarteringScreenOwner.safeParse(this.receivedField.getValue());
        PriceSubmissionPayload payload = new PriceSubmissionPayload(this.populatedRows(), price, received);
        PacketDistributor.sendToServer((CustomPacketPayload)payload, (CustomPacketPayload[])new CustomPacketPayload[0]);
    }

    private static int safeParse(String txt) {
        try {
            return Integer.parseInt(txt.trim());
        }
        catch (NumberFormatException ignored) {
            return 0;
        }
    }

    private int populatedRows() {
        if (this.bartering == null) {
            return 0;
        }
        int rows = 0;
        for (int i = 0; i < 3; ++i) {
            if (this.bartering.getSaleCount(i) <= 0 && this.bartering.getCostCount(i) <= 0) continue;
            ++rows;
        }
        return rows;
    }
}

