/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.screens;

import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.client.screens.BarteringScreenOwner;
import com.epherical.shoppy.client.widget.RowButton;
import com.epherical.shoppy.menu.bartering.BarteringMenu;
import com.epherical.shoppy.network.payloads.PurchaseAttemptPayload;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.network.PacketDistributor;

public class BarteringScreen
extends AbstractContainerScreen<BarteringMenu> {
    private static final ResourceLocation CONTAINER_BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"shoppy", (String)"textures/gui/sprites/container/bartering_page_owner.png");
    private static final int ROW_START_Y = 30;
    private static final int ROW_HEIGHT = 20;
    private static final int ROW_PAD_X = 8;
    private static final int TEXT_Y_OFF = 6;
    private static final int ITEM_SIZE = 16;
    private static final int CURRENCY_ITEM_X = 111;
    private static final int CURRENCY_ITEM_Y = 133;
    private BarteringBlockEntity bartering;

    public BarteringScreen(BarteringMenu pMenu, Inventory pPlayerInventory, Component pTitle) {
        super((AbstractContainerMenu)pMenu, pPlayerInventory, pTitle);
        this.inventoryLabelY = -3000;
    }

    protected void init() {
        super.init();
        this.bartering = (BarteringBlockEntity)this.minecraft.level.getBlockEntity(((BarteringMenu)this.menu).getBlockPos());
        for (int i = 0; i < 3; ++i) {
            if (this.bartering.getSaleCount(i) == 0 && this.bartering.getCostCount(i) == 0) continue;
            int y = this.topPos + 30 + i * 20;
            int x = this.leftPos + 8 - 2;
            int width = 96;
            RowButton btn = new RowButton(x, y, width, 18, i, this.bartering, ii -> PacketDistributor.sendToServer((CustomPacketPayload)new PurchaseAttemptPayload(ii), (CustomPacketPayload[])new CustomPacketPayload[0]));
            this.addRenderableWidget((GuiEventListener)btn);
        }
    }

    public void render(GuiGraphics graphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.render(graphics, pMouseX, pMouseY, pPartialTick);
        this.renderTooltip(graphics, pMouseX, pMouseY);
        int left = this.leftPos;
        int top = this.topPos;
        if (this.bartering != null) {
            ItemStack currencyStack;
            ItemStack saleStack = this.bartering.getSaleItem();
            if (!saleStack.isEmpty()) {
                int x = left + 111;
                int y = top + 133 - 16 - 112;
                if (BarteringScreenOwner.isHovering(pMouseX, pMouseY, x, y)) {
                    List lines = saleStack.getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.player.level()), (Player)this.minecraft.player, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                    lines.add(Component.translatable((String)"tooltip.shoppy.sale_stock").withStyle(ChatFormatting.GRAY));
                    graphics.renderTooltip(this.font, lines, Optional.empty(), pMouseX, pMouseY);
                }
                graphics.renderItem(saleStack, x, y);
                graphics.drawString(this.font, "x" + ((BarteringMenu)this.menu).getContainerData().get(0), x + 16, y + 4, 0xFFFFFF);
                graphics.renderItemDecorations(this.font, saleStack, x, y);
            }
            if (!(currencyStack = this.bartering.getCurrencyItem()).isEmpty()) {
                int x = left + 111;
                int y = top + 133 - 112;
                if (BarteringScreenOwner.isHovering(pMouseX, pMouseY, x, y)) {
                    List lines = this.bartering.getCurrencyItem().getTooltipLines(Item.TooltipContext.of((Level)this.minecraft.player.level()), (Player)this.minecraft.player, (TooltipFlag)(this.minecraft.options.advancedItemTooltips ? TooltipFlag.Default.ADVANCED : TooltipFlag.Default.NORMAL));
                    lines.add(Component.translatable((String)"tooltip.shoppy.currency_item").withStyle(ChatFormatting.GRAY));
                    graphics.renderTooltip(this.font, lines, Optional.empty(), pMouseX, pMouseY);
                }
                graphics.renderItem(currencyStack, x, y);
                graphics.drawString(this.font, "x" + ((BarteringMenu)this.menu).getContainerData().get(1), x + 16, y + 4, 0xFFFFFF);
                graphics.renderItemDecorations(this.font, currencyStack, x, y);
            }
        }
    }

    protected void renderBg(GuiGraphics graphics, float pPartialTick, int pMouseX, int pMouseY) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int left = this.leftPos;
        int top = this.topPos;
        graphics.blit(CONTAINER_BACKGROUND, left, top, 0, 0, 176, 191);
    }
}

