/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.client.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public class ShoppyItemRenderer
extends EntityRenderer<ItemEntity> {
    private final ItemRenderer itemRenderer;
    private final RandomSource random = RandomSource.create();

    public ShoppyItemRenderer(EntityRendererProvider.Context context) {
        super(context);
        this.itemRenderer = context.getItemRenderer();
    }

    public ResourceLocation getTextureLocation(ItemEntity entity) {
        return TextureAtlas.LOCATION_BLOCKS;
    }

    public void render(ItemEntity entity, float ff, float tick, PoseStack pose, MultiBufferSource buffer, int i) {
        pose.pushPose();
        ItemStack itemStack = entity.getItem();
        int rand = itemStack.isEmpty() ? 187 : Item.getId((Item)itemStack.getItem()) + itemStack.getDamageValue();
        this.random.setSeed((long)rand);
        BakedModel model = this.itemRenderer.getModel(itemStack, entity.level(), null, entity.getId());
        boolean is3D = model.isGui3d();
        float offset = Mth.sin((float)(((float)entity.getAge() + tick) / 10.0f + entity.bobOffs)) * 0.1f + 0.1f;
        float transform = model.getTransforms().getTransform((ItemDisplayContext)ItemDisplayContext.GROUND).scale.y();
        pose.translate(0.0f, offset + 0.25f * transform, 0.0f);
        float currentSpin = entity.getSpin(tick);
        pose.mulPose(Axis.YP.rotation(currentSpin));
        float xScale = model.getTransforms().ground.scale.x();
        float yScale = model.getTransforms().ground.scale.y();
        float zScale = model.getTransforms().ground.scale.z();
        if (!is3D) {
            float x = -0.0f * xScale;
            float y = -0.0f * yScale;
            float z = -0.046875f * zScale;
            pose.translate(x, y, z);
        }
        pose.pushPose();
        this.itemRenderer.render(itemStack, ItemDisplayContext.GROUND, false, pose, buffer, i, OverlayTexture.NO_OVERLAY, model);
        pose.popPose();
        if (!is3D) {
            pose.translate(0.0f * xScale, 0.0f * yScale, 0.09375f * zScale);
        }
        pose.popPose();
        super.render((Entity)entity, ff, tick, pose, buffer, i);
    }
}

