/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy.block.entity;

import com.epherical.shoppy.Shoppy;
import com.epherical.shoppy.block.entity.Ownable;
import com.epherical.shoppy.menu.bartering.BarteringMenu;
import com.epherical.shoppy.menu.bartering.BarteringMenuOwner;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Containers;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.Nameable;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.MenuConstructor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.ItemHandlerHelper;
import org.jetbrains.annotations.Nullable;

public class BarteringBlockEntity
extends BlockEntity
implements Nameable,
MenuProvider,
MenuConstructor,
Ownable {
    private final NonNullList<ItemStack> inventory = NonNullList.withSize((int)2, (Object)ItemStack.EMPTY);
    private ItemStack saleItem = ItemStack.EMPTY;
    private ItemStack currency = ItemStack.EMPTY;
    private final int[] saleCounts = new int[3];
    private final int[] costCounts = new int[3];
    private int saleItemCount = 0;
    private int currencyItemCount = 0;
    protected UUID owner = Util.NIL_UUID;
    private boolean allowInsert = true;
    private boolean allowExtract = true;
    private static final int SLOTS = 1024;
    protected final ContainerData data = new ContainerData(){

        public int get(int index) {
            return switch (index) {
                case 0 -> BarteringBlockEntity.this.getSaleItemCount();
                case 1 -> BarteringBlockEntity.this.getCurrencyItemCount();
                default -> 0;
            };
        }

        public void set(int index, int value) {
            switch (index) {
                case 0: {
                    BarteringBlockEntity.this.setSaleItemCount(value);
                    break;
                }
                case 1: {
                    BarteringBlockEntity.this.setCurrencyItemCount(value);
                }
            }
        }

        public int getCount() {
            return 2;
        }
    };

    public void setOffer(int idx, int cost, int sale) {
        if (idx < 0 || idx >= this.saleCounts.length) {
            return;
        }
        this.costCounts[idx] = cost;
        this.saleCounts[idx] = sale;
    }

    public BarteringBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)Shoppy.BARTERING_STATION_ENTITY.get(), pos, state);
    }

    public BarteringBlockEntity(BlockEntityType<?> blockEntity, BlockPos blockPos, BlockState blockState) {
        super(blockEntity, blockPos, blockState);
    }

    public void tryPurchase(Player player, int offerIdx) {
        ItemStack stack;
        if (offerIdx < 0 || offerIdx > 2) {
            return;
        }
        int saleQty = this.saleCounts[offerIdx];
        int costQty = this.costCounts[offerIdx];
        if (saleQty <= 0 || costQty <= 0) {
            return;
        }
        if (this.getSaleItemCount() < saleQty) {
            return;
        }
        ItemStack currencyTemplate = new ItemStack((ItemLike)this.currency.getItem());
        int playerCurrency = 0;
        Iterator iterator = player.getInventory().items.iterator();
        while (iterator.hasNext() && (!ItemStack.isSameItem((ItemStack)(stack = (ItemStack)iterator.next()), (ItemStack)currencyTemplate) || (playerCurrency += stack.getCount()) < costQty)) {
        }
        if (playerCurrency < costQty) {
            return;
        }
        int remaining = costQty;
        for (int i = 0; i < player.getInventory().items.size() && remaining > 0; ++i) {
            ItemStack stack2 = (ItemStack)player.getInventory().items.get(i);
            if (!ItemStack.isSameItem((ItemStack)stack2, (ItemStack)currencyTemplate)) continue;
            int toTake = Math.min(stack2.getCount(), remaining);
            stack2.shrink(toTake);
            if (stack2.isEmpty()) {
                player.getInventory().items.set(i, (Object)ItemStack.EMPTY);
            }
            remaining -= toTake;
        }
        if (remaining > 0) {
            return;
        }
        ItemStack product = this.saleItem.copy();
        product.setCount(saleQty);
        ItemHandlerHelper.giveItemToPlayer((Player)player, (ItemStack)product);
        this.saleItemCount = Math.max(0, this.saleItemCount - saleQty);
        this.addCurrencyItems(costQty);
        this.setChanged();
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        this.writeNBT(tag, registries);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.readNBT(tag, registries);
    }

    public void handleUpdateTag(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.handleUpdateTag(tag, lookupProvider);
        this.readNBT(tag, lookupProvider);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        CompoundTag updateTag = super.getUpdateTag(registries);
        this.writeNBT(updateTag, registries);
        return updateTag;
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"block.shoppy.bartering_station").setStyle(Style.EMPTY.withColor(ChatFormatting.WHITE));
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        if (this.getOwner().equals(player.getUUID())) {
            return BarteringMenuOwner.barteringOwner(i, this.getBlockPos(), false, this.data);
        }
        return BarteringMenu.barteringMenu(i, this.getBlockPos(), this.data);
    }

    private void writeNBT(CompoundTag tag, HolderLookup.Provider registries) {
        if (!this.saleItem.isEmpty()) {
            tag.put("SaleItem", this.saleItem.save(registries));
        }
        if (!this.currency.isEmpty()) {
            tag.put("Currency", this.currency.save(registries));
        }
        tag.put("SaleCounts", (Tag)new IntArrayTag(this.saleCounts));
        tag.put("CostCounts", (Tag)new IntArrayTag(this.costCounts));
        tag.putInt("SaleItemCount", this.saleItemCount);
        tag.putInt("CurrencyItemCount", this.currencyItemCount);
        tag.putBoolean("AllowInsert", this.allowInsert);
        tag.putBoolean("AllowExtract", this.allowExtract);
        if (!this.owner.equals(Util.NIL_UUID)) {
            tag.putUUID("Owner", this.owner);
        }
    }

    private void readNBT(CompoundTag tag, HolderLookup.Provider registries) {
        if (tag.contains("SaleItem")) {
            this.saleItem = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("SaleItem")).orElse(ItemStack.EMPTY);
        }
        if (tag.contains("Currency")) {
            this.currency = ItemStack.parse((HolderLookup.Provider)registries, (Tag)tag.getCompound("Currency")).orElse(ItemStack.EMPTY);
        }
        if (tag.contains("SaleCounts", 11)) {
            System.arraycopy(tag.getIntArray("SaleCounts"), 0, this.saleCounts, 0, Math.min(3, tag.getIntArray("SaleCounts").length));
        }
        if (tag.contains("CostCounts", 11)) {
            System.arraycopy(tag.getIntArray("CostCounts"), 0, this.costCounts, 0, Math.min(3, tag.getIntArray("CostCounts").length));
        }
        this.saleItemCount = tag.getInt("SaleItemCount");
        this.currencyItemCount = tag.getInt("CurrencyItemCount");
        this.allowInsert = tag.getBoolean("AllowInsert");
        this.allowExtract = tag.getBoolean("AllowExtract");
        if (tag.hasUUID("Owner")) {
            this.owner = tag.getUUID("Owner");
        }
    }

    @Override
    public void setOwner(UUID owner) {
        this.owner = owner;
    }

    @Override
    public UUID getOwner() {
        return this.owner;
    }

    public Component getName() {
        return this.getDefaultName();
    }

    public boolean hasCustomName() {
        return super.hasCustomName();
    }

    public Component getDisplayName() {
        return super.getDisplayName();
    }

    @Nullable
    public Component getCustomName() {
        return super.getCustomName();
    }

    public int getFreeSlots() {
        return 1024 - this.getSaleItemCount();
    }

    public int getSaleItemCount() {
        return this.saleItemCount;
    }

    public int getCurrencyItemCount() {
        return this.currencyItemCount;
    }

    public void setCurrencyItemCount(int currencyItemCount) {
        this.currencyItemCount = currencyItemCount;
    }

    public void setSaleItemCount(int saleItemCount) {
        this.saleItemCount = saleItemCount;
    }

    public void addSaleItems(int n) {
        this.saleItemCount += n;
        this.setChanged();
    }

    public void removeSaleItems(int n) {
        this.saleItemCount = Math.max(0, this.saleItemCount - n);
        this.setChanged();
    }

    public void addCurrencyItems(int n) {
        this.currencyItemCount += n;
        this.setChanged();
    }

    public void removeCurrencyItems(int n) {
        this.currencyItemCount = Math.max(0, this.currencyItemCount - n);
        this.setChanged();
    }

    public void setSaleItem(ItemStack saleItem) {
        this.saleItem = saleItem;
    }

    public void setCurrency(ItemStack currency) {
        this.currency = currency;
    }

    public ItemStack getSaleItem() {
        return this.saleItem;
    }

    public ItemStack getCurrencyItem() {
        return this.currency;
    }

    public int getSaleCount(int idx) {
        return this.saleCounts[idx];
    }

    public int getCostCount(int idx) {
        return this.costCounts[idx];
    }

    public int getStock() {
        return this.saleItemCount;
    }

    public NonNullList<ItemStack> getInventory() {
        return this.inventory;
    }

    public ContainerData getContainerData() {
        return this.data;
    }

    public boolean isInsertAllowed() {
        return this.allowInsert;
    }

    public boolean isExtractAllowed() {
        return this.allowExtract;
    }

    public void setAllowInsert(boolean value) {
        this.allowInsert = value;
    }

    public void setAllowExtract(boolean value) {
        this.allowExtract = value;
    }

    public void dropStock(Level level, BlockPos pos) {
        if (level.isClientSide) {
            return;
        }
        BarteringBlockEntity.dropStack(level, pos, this.saleItem, this.saleItemCount);
        BarteringBlockEntity.dropStack(level, pos, this.currency, this.currencyItemCount);
        this.saleItemCount = 0;
        this.currencyItemCount = 0;
        this.setChanged();
    }

    private static void dropStack(Level level, BlockPos pos, ItemStack prototype, int count) {
        int n;
        if (count <= 0 || prototype.isEmpty()) {
            return;
        }
        int max = prototype.getMaxStackSize();
        for (int left = count; left > 0; left -= n) {
            n = Math.min(max, left);
            ItemStack stack = prototype.copy();
            stack.setCount(n);
            Containers.dropItemStack((Level)level, (double)((double)pos.getX() + 0.5), (double)((double)pos.getY() + 0.5), (double)((double)pos.getZ() + 0.5), (ItemStack)stack);
        }
    }
}

