/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.shoppy;

import com.epherical.shoppy.block.BarteringBlock;
import com.epherical.shoppy.block.CreativeBarteringBlock;
import com.epherical.shoppy.block.entity.BarteringBlockEntity;
import com.epherical.shoppy.block.entity.CreativeBarteringBlockEntity;
import com.epherical.shoppy.commands.ShopOwnerCommand;
import com.epherical.shoppy.menu.bartering.BarteringMenu;
import com.epherical.shoppy.menu.bartering.BarteringMenuOwner;
import com.epherical.shoppy.network.ServerPayloadHandler;
import com.epherical.shoppy.network.payloads.AddItemRequestPayload;
import com.epherical.shoppy.network.payloads.PriceSubmissionPayload;
import com.epherical.shoppy.network.payloads.PurchaseAttemptPayload;
import com.epherical.shoppy.network.payloads.SetSaleItemPayload;
import com.epherical.shoppy.network.payloads.StockTransferPayload;
import com.epherical.shoppy.network.payloads.ToggleAutomationPayload;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.logging.LogUtils;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.RegisterCapabilitiesEvent;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.RegisterCommandsEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;
import net.neoforged.neoforge.event.server.ServerStartingEvent;
import net.neoforged.neoforge.items.ItemStackHandler;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.HandlerThread;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.DeferredBlock;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.server.permission.PermissionAPI;
import net.neoforged.neoforge.server.permission.events.PermissionGatherEvent;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContext;
import net.neoforged.neoforge.server.permission.nodes.PermissionDynamicContextKey;
import net.neoforged.neoforge.server.permission.nodes.PermissionNode;
import net.neoforged.neoforge.server.permission.nodes.PermissionTypes;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

@Mod(value="shoppy")
public class Shoppy {
    public static final String MODID = "shoppy";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final DeferredRegister.Blocks BLOCKS = DeferredRegister.createBlocks((String)"shoppy");
    public static final DeferredRegister.Items ITEMS = DeferredRegister.createItems((String)"shoppy");
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"shoppy");
    public static final DeferredRegister<BlockEntityType<?>> BLOCK_ENTITIES = DeferredRegister.create((ResourceKey)Registries.BLOCK_ENTITY_TYPE, (String)"shoppy");
    public static final DeferredRegister<MenuType<?>> MENU_TYPES = DeferredRegister.create((ResourceKey)Registries.MENU, (String)"shoppy");
    public static final DeferredBlock<BarteringBlock> BARTERING_STATION = BLOCKS.register("bartering_station", () -> new BarteringBlock(BlockBehaviour.Properties.of().strength(2.5f, 1200.0f).sound(SoundType.WOOD).noOcclusion()));
    public static final DeferredItem<BlockItem> BARTERING_STATION_ITEM = ITEMS.registerSimpleBlockItem(BARTERING_STATION);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<BarteringBlockEntity>> BARTERING_STATION_ENTITY = BLOCK_ENTITIES.register("bartering_station", () -> BlockEntityType.Builder.of(BarteringBlockEntity::new, (Block[])new Block[]{(Block)BARTERING_STATION.get()}).build(null));
    public static final DeferredBlock<CreativeBarteringBlock> CREATIVE_BARTERING_STATION = BLOCKS.register("creative_bartering_station", () -> new CreativeBarteringBlock(BlockBehaviour.Properties.of().strength(2.5f, 1200.0f).sound(SoundType.WOOD).noOcclusion()));
    public static final DeferredItem<BlockItem> CREATIVE_BARTERING_STATION_ITEM = ITEMS.registerSimpleBlockItem(CREATIVE_BARTERING_STATION);
    public static final DeferredHolder<BlockEntityType<?>, BlockEntityType<CreativeBarteringBlockEntity>> CREATIVE_BARTERING_STATION_ENTITY = BLOCK_ENTITIES.register("creative_bartering_station", () -> BlockEntityType.Builder.of(CreativeBarteringBlockEntity::new, (Block[])new Block[]{(Block)CREATIVE_BARTERING_STATION.get()}).build(null));
    public static final DeferredHolder<MenuType<?>, MenuType<BarteringMenu>> BARTERING_MENU = MENU_TYPES.register("bartering_menu", () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)BarteringMenu::new), FeatureFlags.VANILLA_SET));
    public static DeferredHolder<MenuType<?>, MenuType<BarteringMenuOwner>> BARTERING_MENU_OWNER = MENU_TYPES.register("bartering_menu_owner", () -> new MenuType((MenuType.MenuSupplier)((IContainerFactory)BarteringMenuOwner::new), FeatureFlags.VANILLA_SET));
    public static final PermissionNode<Boolean> ADMIN_BREAK = new PermissionNode("shoppy", "admin.break_shop", PermissionTypes.BOOLEAN, (player, playerUUID, context) -> player != null && player.hasPermissions(4), new PermissionDynamicContextKey[0]);
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> EXAMPLE_TAB = CREATIVE_MODE_TABS.register("example_tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"itemGroup.shoppy")).withTabsBefore(new ResourceKey[]{CreativeModeTabs.COMBAT}).icon(() -> ((BlockItem)BARTERING_STATION_ITEM.get()).getDefaultInstance()).displayItems((parameters, output) -> {
        output.accept((ItemLike)BARTERING_STATION.get());
        output.accept((ItemLike)CREATIVE_BARTERING_STATION_ITEM.get());
    }).build());

    public Shoppy(IEventBus modEventBus, ModContainer modContainer) {
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::onCapability);
        modEventBus.addListener(this::registerNetworkPayloads);
        BLOCKS.register(modEventBus);
        ITEMS.register(modEventBus);
        CREATIVE_MODE_TABS.register(modEventBus);
        BLOCK_ENTITIES.register(modEventBus);
        MENU_TYPES.register(modEventBus);
        NeoForge.EVENT_BUS.register((Object)this);
    }

    private void commonSetup(FMLCommonSetupEvent event) {
    }

    public void onCapability(RegisterCapabilitiesEvent event) {
        event.registerBlock(Capabilities.ItemHandler.BLOCK, (level, pos, state, blockEntity, context) -> {
            final BarteringBlockEntity barteringBlockEntity = (BarteringBlockEntity)blockEntity;
            NonNullList<ItemStack> inventory = barteringBlockEntity.getInventory();
            return new ItemStackHandler(this, inventory){

                public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                    return switch (slot) {
                        case 0 -> ItemStack.isSameItem((ItemStack)stack, (ItemStack)barteringBlockEntity.getSaleItem());
                        case 1 -> false;
                        default -> false;
                    };
                }

                public ItemStack extractItem(int slot, int amount, boolean simulate) {
                    if (!barteringBlockEntity.isExtractAllowed()) {
                        return ItemStack.EMPTY;
                    }
                    if (slot == 1 && barteringBlockEntity.getCurrencyItemCount() > 0 && amount > 0) {
                        int taken = Math.min(amount, barteringBlockEntity.getCurrencyItemCount());
                        if (!simulate) {
                            barteringBlockEntity.addCurrencyItems(-taken);
                        }
                        ItemStack out = barteringBlockEntity.getCurrencyItem().copy();
                        out.setCount(taken);
                        return out;
                    }
                    return ItemStack.EMPTY;
                }

                public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
                    if (!barteringBlockEntity.isInsertAllowed()) {
                        return stack;
                    }
                    if (slot == 0) {
                        if (stack.isEmpty()) {
                            return ItemStack.EMPTY;
                        }
                        if (barteringBlockEntity.getSaleItem().isEmpty() || !ItemStack.isSameItem((ItemStack)stack, (ItemStack)barteringBlockEntity.getSaleItem())) {
                            return stack;
                        }
                        int free = barteringBlockEntity.getFreeSlots();
                        if (free <= 0) {
                            return stack;
                        }
                        int toInsert = Math.min(free, stack.getCount());
                        if (!simulate) {
                            barteringBlockEntity.addSaleItems(toInsert);
                        }
                        return stack.copyWithCount(stack.getCount() - toInsert);
                    }
                    return stack;
                }
            };
        }, new Block[]{(Block)BARTERING_STATION.get()});
    }

    public void registerNetworkPayloads(RegisterPayloadHandlersEvent event) {
        PayloadRegistrar registrar = event.registrar("2").executesOn(HandlerThread.MAIN);
        registrar.playToServer(AddItemRequestPayload.TYPE, AddItemRequestPayload.STREAM_CODEC, ServerPayloadHandler::handle);
        registrar.playToServer(SetSaleItemPayload.TYPE, SetSaleItemPayload.STREAM_CODEC, ServerPayloadHandler::handle);
        registrar.playToServer(PriceSubmissionPayload.TYPE, PriceSubmissionPayload.STREAM_CODEC, ServerPayloadHandler::handle);
        registrar.playToServer(PurchaseAttemptPayload.TYPE, PurchaseAttemptPayload.STREAM_CODEC, ServerPayloadHandler::handle);
        registrar.playToServer(StockTransferPayload.TYPE, StockTransferPayload.STREAM_CODEC, ServerPayloadHandler::handle);
        registrar.playToServer(ToggleAutomationPayload.TYPE, ToggleAutomationPayload.STREAM_CODEC, ServerPayloadHandler::handle);
    }

    @SubscribeEvent
    public void onServerStarting(ServerStartingEvent event) {
    }

    @SubscribeEvent
    public void onCommandRegister(RegisterCommandsEvent event) {
        ShopOwnerCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public void registerPermissions(PermissionGatherEvent.Nodes event) {
        event.addNodes(new PermissionNode[]{ADMIN_BREAK});
    }

    @SubscribeEvent
    public void onPlayerInteract(PlayerInteractEvent.LeftClickBlock event) {
        if (event.getEntity() instanceof ServerPlayer) {
            BarteringBlockEntity trading;
            Player player = event.getEntity();
            BlockPos pos = event.getPos();
            ServerLevel level = (ServerLevel)event.getEntity().level();
            BlockEntity entity = level.getBlockEntity(pos);
            if (entity instanceof BarteringBlockEntity && !(trading = (BarteringBlockEntity)entity).getOwner().equals(player.getUUID()) && (!player.hasPermissions(4) || ((Boolean)PermissionAPI.getPermission((ServerPlayer)((ServerPlayer)player), ADMIN_BREAK, (PermissionDynamicContext[])new PermissionDynamicContext[0])).booleanValue())) {
                event.setCanceled(true);
            }
        }
    }
}

