/*
 * Decompiled with CFR 0.152.
 */
package journeymap.common.util;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ReflectionHelper {
    public static boolean isInstanceOf(Object object, String ... classPaths) {
        for (String classPath : classPaths) {
            try {
                Class<?> matchedClass = Class.forName(classPath);
                if (!matchedClass.isInstance(object)) continue;
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static boolean hasField(Object obj, String fieldName) {
        for (Field field : obj.getClass().getFields()) {
            if (!fieldName.equalsIgnoreCase(field.getName())) continue;
            return true;
        }
        for (Field field : obj.getClass().getDeclaredFields()) {
            if (!fieldName.equalsIgnoreCase(field.getName())) continue;
            return true;
        }
        return false;
    }

    public static <T> Optional<T> getPrivateField(Object obj, String fieldName) {
        try {
            Field field;
            try {
                field = obj.getClass().getField(fieldName);
            }
            catch (NoSuchFieldException nsfe) {
                field = obj.getClass().getDeclaredField(fieldName);
            }
            field.setAccessible(true);
            return Optional.of(field.get(obj));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public static <T> List<T> getPrivateFieldsOfClass(Object obj, Class<T> theClass) {
        ArrayList<Object> fields = new ArrayList<Object>();
        try {
            for (Field field : obj.getClass().getFields()) {
                if (!theClass.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                fields.add(field.get(obj));
            }
            for (Field field : obj.getClass().getDeclaredFields()) {
                if (!theClass.isAssignableFrom(field.getType())) continue;
                field.setAccessible(true);
                fields.add(field.get(obj));
            }
            return fields;
        }
        catch (Exception e) {
            return fields;
        }
    }

    public static <T> Optional<T> invokeMethod(Object obj, String fieldName, Object ... params) {
        try {
            Method method;
            ArrayList parameterTypes = new ArrayList();
            for (Object object : params) {
                parameterTypes.add(object.getClass());
            }
            try {
                method = obj.getClass().getMethod(fieldName, (Class[])parameterTypes.toArray(Class[]::new));
            }
            catch (NoSuchMethodException nsme) {
                method = obj.getClass().getDeclaredMethod(fieldName, (Class[])parameterTypes.toArray(Class[]::new));
            }
            method.setAccessible(true);
            Object returnValue = method.invoke(obj, params);
            return Optional.of(returnValue);
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

