/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.ui.waypointmanager;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import journeymap.client.Constants;
import journeymap.client.data.WorldData;
import journeymap.client.ui.component.dropdown.DropDownButton;
import journeymap.client.ui.component.dropdown.DropDownItem;
import journeymap.client.ui.component.dropdown.SelectableParent;
import journeymap.common.waypoint.WaypointStore;
import net.minecraft.client.gui.components.Button;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;

public class DimensionsDropDownButton
extends DropDownButton {
    private WorldData.DimensionProvider currentWorldProvider;
    private final List<WorldData.DimensionProvider> dimensionProviders;
    private final Map<String, DropDownItem> itemMap = Maps.newHashMap();
    private final DropDownItem all = new DropDownItem((SelectableParent)this, null, Constants.getString("jm.waypoint.dimension", Constants.getString("jm.waypoint.dimension_all")), Constants.getString("jm.waypoint.dimension_all"));

    public DimensionsDropDownButton(Button.OnPress onPress) {
        super("", onPress);
        this.dimensionProviders = WorldData.getDimensionProviders(WaypointStore.getInstance().getLoadedDimensions());
        this.setItems(this.createListItems());
    }

    private List<DropDownItem> createListItems() {
        ArrayList list = Lists.newArrayList();
        list.add(this.all);
        this.addVanillaDim("minecraft:overworld", list);
        this.addVanillaDim("minecraft:the_nether", list);
        this.addVanillaDim("minecraft:the_end", list);
        for (WorldData.DimensionProvider item : this.dimensionProviders) {
            if ("minecraft:the_nether".equals(item.getDimensionId()) || "minecraft:the_end".equals(item.getDimensionId()) || "minecraft:overworld".equals(item.getDimensionId())) continue;
            list.add(this.dropDown(item));
        }
        return list;
    }

    private void addVanillaDim(String name, List<DropDownItem> list) {
        this.dimensionProviders.forEach(provider -> {
            if (name.equals(provider.getDimensionId())) {
                list.add(this.dropDown((WorldData.DimensionProvider)provider));
            }
        });
    }

    private DropDownItem dropDown(WorldData.DimensionProvider dim) {
        DropDownItem dropDownItem = new DropDownItem((SelectableParent)this, (Object)dim, dim.getName(), dim.getDimensionId());
        this.itemMap.put(dim.getDimensionId(), dropDownItem);
        return dropDownItem;
    }

    public void setDim(ResourceKey<Level> dimension) {
        if (dimension != null) {
            this.currentWorldProvider = this.dimensionProviders.stream().filter(dimensionProvider -> dimension.equals(dimensionProvider.getDimension())).findFirst().orElse(null);
            this.setSelected(this.itemMap.get(this.currentWorldProvider.getDimensionId()));
        } else {
            this.currentWorldProvider = null;
            this.setSelected(this.all);
        }
    }

    public void setDim(String dimension) {
        if (dimension != null) {
            this.currentWorldProvider = this.dimensionProviders.stream().filter(dimensionProvider -> dimension.equals(dimensionProvider.getDimensionId())).findFirst().orElse(null);
            this.setSelected(this.itemMap.get(this.currentWorldProvider.getDimensionId()));
        } else {
            this.currentWorldProvider = null;
            this.setSelected(this.all);
        }
    }

    private void setSelected(WorldData.DimensionProvider provider) {
        DropDownItem selected = provider == null ? this.all : this.itemMap.get(provider.getDimensionId());
        this.currentWorldProvider = selected != null ? (WorldData.DimensionProvider)selected.getId() : null;
        this.setSelected(selected);
    }

    @Override
    public void setSelected(DropDownItem selectedButton) {
        this.selected = selectedButton;
        if (this.selected == null && this.currentWorldProvider == null) {
            super.setSelected(this.all);
            return;
        }
        this.currentWorldProvider = this.selected != null ? (WorldData.DimensionProvider)this.selected.getId() : null;
        super.setSelected(this.selected);
    }

    @Override
    public void setX(int x) {
        super.setX(x);
    }

    @Override
    public void setY(int y) {
        super.setY(y);
    }

    private class DimSorter
    implements Comparator<DropDownItem> {
        private DimSorter() {
        }

        @Override
        public int compare(DropDownItem o1, DropDownItem o2) {
            boolean b2;
            String s1 = o1.getLabel();
            String s2 = o2.getLabel();
            boolean b1 = ((Object)((Object)o1)).equals((Object)DimensionsDropDownButton.this.all) || o1.getLabel().equals("Overworld") || o1.getLabel().equals("The Nether") || o1.getLabel().equals("The End");
            boolean bl = b2 = ((Object)((Object)o2)).equals((Object)DimensionsDropDownButton.this.all) || o2.getLabel().equals("Overworld") || o2.getLabel().equals("The Nether") || o2.getLabel().equals("The End");
            return b1 ? (b2 ? 0 : 1) : (b2 ? -1 : s1.compareTo(s2));
        }
    }
}

