/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.render.draw;

import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexSorting;
import com.mojang.math.Axis;
import java.awt.geom.Point2D;
import java.util.List;
import java.util.Objects;
import journeymap.api.services.Services;
import journeymap.api.v2.client.model.ShapeProperties;
import journeymap.client.cartography.color.RGB;
import journeymap.client.render.JMRenderTypes;
import journeymap.client.render.RenderWrapper;
import journeymap.client.render.draw.DrawStep;
import journeymap.client.texture.TextureAccess;
import journeymap.client.ui.theme.Theme;
import journeymap.common.Journeymap;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.DynamicTexture;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec2;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;

public class DrawUtil {
    public static double zLevel = 0.0;

    public static void drawCenteredLabel(GuiGraphics graphics, String text, double x, double y, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, HAlign.Center, VAlign.Middle, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabel(GuiGraphics graphics, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, color, alpha, fontScale, fontShadow, 0.0);
    }

    public static void drawLabels(GuiGraphics graphics, String[] lines, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        if (lines.length == 0) {
            return;
        }
        if (lines.length == 1) {
            MultiBufferSource.BufferSource buffers = graphics.bufferSource();
            if (bgColor != null && bgAlpha > 0.0f) {
                DrawUtil.drawBatchLabel(graphics, (Component)Component.literal((String)lines[0]), DrawStep.Pass.TextBG, (MultiBufferSource)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, (int)color, alpha, fontScale, fontShadow, rotation);
            }
            DrawUtil.drawBatchLabel(graphics, (Component)Component.literal((String)lines[0]), DrawStep.Pass.Text, (MultiBufferSource)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, (int)color, alpha, fontScale, fontShadow, rotation);
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        double vpad = fontRenderer.isBidirectional() ? 0.0 : (fontShadow ? 6.0 : 4.0);
        double hpad = 4.0;
        Objects.requireNonNull(fontRenderer);
        double lineHeight = 9.0 * fontScale;
        double bgHeight = lineHeight * (double)lines.length + vpad;
        double bgWidth = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            for (String line : lines) {
                bgWidth = Math.max(bgWidth, (double)fontRenderer.width(line) * fontScale);
            }
            if (bgWidth % 2.0 == 0.0) {
                bgWidth += 1.0;
            }
        }
        bgWidth += 4.0;
        double rectX = x;
        double rectY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                rectX = x - bgWidth + 2.0;
                break;
            }
            case 1: {
                rectX = (float)(x - (Math.max(1.0, bgWidth) / 2.0 + fontScale) + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case 2: {
                rectX = x - 2.0 - 0.5;
            }
        }
        switch (vAlign.ordinal()) {
            case 0: {
                rectY = (y -= lineHeight * (double)lines.length) - bgHeight / 2.0 - vpad / 2.0;
                break;
            }
            case 1: {
                rectY = (y -= bgHeight / 2.0) - vpad / 2.0 - 5.0 * fontScale;
                break;
            }
            case 2: {
                rectY = y;
            }
        }
        if (bgColor != null && bgAlpha > 0.0f) {
            DrawUtil.drawRectangle(graphics, rectX, rectY, bgWidth, bgHeight, bgColor, bgAlpha);
        }
        for (String line : lines) {
            MultiBufferSource.BufferSource buffers = graphics.bufferSource();
            DrawUtil.drawBatchLabel(graphics, (Component)Component.literal((String)line), DrawStep.Pass.Text, (MultiBufferSource)buffers, x, y, hAlign, vAlign, bgColor, bgAlpha, (int)color, alpha, fontScale, fontShadow, rotation);
            y += lineHeight;
        }
    }

    public static void drawLabel(GuiGraphics graphics, String text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawLabel(GuiGraphics graphics, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.getInstance().font;
            bgWidth = fontRenderer.width(text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawLabel(GuiGraphics graphics, String text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, Integer color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        int height;
        if (text == null || text.length() == 0) {
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.width(text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.isBidirectional()) {
            --height;
        }
        graphics.pose().pushPose();
        try {
            double d;
            if (fontScale != 1.0) {
                x /= fontScale;
                y /= fontScale;
                graphics.pose().scale((float)fontScale, (float)fontScale, 1.0f);
            }
            float textX = (float)x;
            float textY = (float)y;
            double rectX = x;
            double rectY = y;
            switch (hAlign.ordinal()) {
                case 0: {
                    textX = (float)(x - width);
                    rectX = textX;
                    break;
                }
                case 1: {
                    textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                    break;
                }
                case 2: {
                    textX = (float)x;
                    rectX = (float)x;
                }
            }
            if (drawRect) {
                Objects.requireNonNull(fontRenderer);
                d = (double)(height - 9) / 2.0;
            } else {
                d = 0.0;
            }
            double vpad = d;
            switch (vAlign.ordinal()) {
                case 0: {
                    rectY = y - (double)height;
                    textY = (float)(rectY + vpad + (double)(!fontRenderer.isBidirectional() ? 1 : 0));
                    break;
                }
                case 1: {
                    rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                    textY = (float)(rectY + vpad);
                    break;
                }
                case 2: {
                    rectY = y;
                    textY = (float)(rectY + vpad);
                }
            }
            if (rotation != 0.0) {
                graphics.pose().translate(x, y, 0.0);
                graphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-rotation)));
                graphics.pose().translate(-x, -y, 0.0);
            }
            if (drawRect) {
                int hpad = 2;
                DrawUtil.drawRectangle(graphics, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
            }
            if (alpha < 1.0f) {
                color = RGB.toArbg(color, alpha);
            }
            graphics.pose().translate((double)textX - Math.floor(textX), (double)textY - Math.floor(textY), 0.0);
            graphics.drawString(fontRenderer, text, (int)Math.floor(textX), (int)Math.floor(textY), color.intValue(), fontShadow);
        }
        finally {
            graphics.pose().popPose();
        }
    }

    public static void drawBatchLabel(GuiGraphics graphics, Component text, Theme.LabelSpec labelSpec, double x, double y, HAlign hAlign, VAlign vAlign, double fontScale, double rotation) {
        DrawUtil.drawBatchLabel(graphics, text, x, y, hAlign, vAlign, labelSpec.background.getColor(), labelSpec.background.alpha, labelSpec.foreground.getColor(), labelSpec.foreground.alpha, fontScale, labelSpec.shadow, rotation);
    }

    public static void drawBatchLabel(GuiGraphics graphics, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double bgWidth = 0.0;
        double bgHeight = 0.0;
        if (bgColor != null && bgAlpha > 0.0f) {
            Font fontRenderer = Minecraft.getInstance().font;
            bgWidth = fontRenderer.width((FormattedText)text);
            bgHeight = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        }
        DrawUtil.drawBatchLabel(graphics, text, x, y, hAlign, vAlign, bgColor, bgAlpha, bgWidth, bgHeight, color, alpha, fontScale, fontShadow, rotation);
    }

    private static void drawBatchLabel(GuiGraphics graphics, Component text, double x, double y, HAlign hAlign, VAlign vAlign, Integer bgColor, float bgAlpha, double bgWidth, double bgHeight, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        double d;
        int height;
        if (text == null || text.getString().length() == 0) {
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        boolean drawRect = bgColor != null && bgAlpha > 0.0f;
        double width = fontRenderer.width((FormattedText)text);
        if (drawRect) {
            v0 = DrawUtil.getLabelHeight(fontRenderer, fontShadow);
        } else {
            Objects.requireNonNull(fontRenderer);
            v0 = height = 9;
        }
        if (!drawRect && fontRenderer.isBidirectional()) {
            --height;
        }
        graphics.pose().pushPose();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            graphics.pose().scale((float)fontScale, (float)fontScale, 0.0f);
        }
        float textX = (float)x;
        float textY = (float)y;
        double rectX = x;
        double rectY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                textX = (float)(x - width);
                rectX = textX;
                break;
            }
            case 1: {
                textX = (float)(x - width / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                rectX = (float)(x - Math.max(1.0, bgWidth) / 2.0 + (fontScale > 1.0 ? 0.5 : 0.0));
                break;
            }
            case 2: {
                textX = (float)x;
                rectX = (float)x;
            }
        }
        if (drawRect) {
            Objects.requireNonNull(fontRenderer);
            d = (double)(height - 9) / 2.0;
        } else {
            d = 0.0;
        }
        double vpad = d;
        switch (vAlign.ordinal()) {
            case 0: {
                rectY = y - (double)height;
                textY = (float)(rectY + vpad + (double)(!fontRenderer.isBidirectional() ? 1 : 0));
                break;
            }
            case 1: {
                rectY = y - (double)(height / 2) + (fontScale > 1.0 ? 0.5 : 0.0);
                textY = (float)(rectY + vpad);
                break;
            }
            case 2: {
                rectY = y;
                textY = (float)(rectY + vpad);
            }
        }
        if (rotation != 0.0) {
            graphics.pose().translate(x, y, 0.0);
            graphics.pose().mulPose(Axis.ZP.rotationDegrees((float)(-rotation)));
            graphics.pose().translate(-x, -y, 0.0);
        }
        if (drawRect) {
            RenderWrapper.disableDepthTest();
            int hpad = 2;
            DrawUtil.drawRectangle(graphics, rectX - 2.0 - 0.5, rectY, bgWidth + 4.0, bgHeight, bgColor, bgAlpha);
        }
        if (alpha < 0.0f) {
            color = RGB.toArbg(color, alpha);
        }
        graphics.drawString(fontRenderer, text, (int)textX, (int)textY, color, fontShadow);
        graphics.pose().popPose();
    }

    public static void drawBatchLabel(GuiGraphics graphics, Component text, DrawStep.Pass pass, MultiBufferSource buffers, double x, double y, HAlign hAlign, VAlign vAlign, int bgColor, float bgAlpha, int color, float alpha, double fontScale, boolean fontShadow, double rotation) {
        PoseStack poseStack = graphics.pose();
        if (pass != DrawStep.Pass.TextBG && pass != DrawStep.Pass.Text) {
            return;
        }
        if (text == null || text.getString().length() == 0) {
            return;
        }
        if (pass == DrawStep.Pass.TextBG && bgAlpha == 0.0f || pass == DrawStep.Pass.Text && alpha == 0.0f) {
            return;
        }
        Font fontRenderer = Minecraft.getInstance().font;
        int width = fontRenderer.width((FormattedText)text);
        Objects.requireNonNull(fontRenderer);
        int height = 9;
        poseStack.pushPose();
        if (fontScale != 1.0) {
            x /= fontScale;
            y /= fontScale;
            poseStack.scale((float)fontScale, (float)fontScale, 0.0f);
        }
        double textX = x;
        double textY = y;
        switch (hAlign.ordinal()) {
            case 0: {
                textX = x - (double)width;
                break;
            }
            case 1: {
                textX = x - (double)(width / 2);
                break;
            }
            case 2: {
                textX = x;
            }
        }
        double padding = 2.0 / fontScale * (double)Mth.floor((double)fontScale);
        switch (vAlign.ordinal()) {
            case 0: {
                textY = y - ((double)height + padding * 2.0) + (double)(!fontRenderer.isBidirectional() ? 1 : 0);
                break;
            }
            case 1: {
                textY = y - (double)((int)((double)height + padding * 2.0) / 2);
                break;
            }
            case 2: {
                textY = y;
            }
        }
        textY += padding - 1.0;
        if (rotation != 0.0) {
            poseStack.translate(x, y, 0.0);
            poseStack.mulPose(Axis.ZP.rotationDegrees((float)(-rotation)));
            poseStack.translate(-x, -y, 0.0);
        }
        if (pass == DrawStep.Pass.TextBG) {
            float rectX = (float)(textX - padding);
            float rectY = (float)(textY - padding);
            float rectW = (float)((double)width + padding * 2.0);
            float rectH = (float)((double)height + padding * 2.0);
            VertexConsumer vertexBuilder = buffers.getBuffer(JMRenderTypes.RECTANGLE_RENDER_TYPE);
            DrawUtil.drawRectangle(graphics, vertexBuilder, rectX, rectY, rectW, rectH, bgColor, bgAlpha);
        } else {
            Matrix4f matrixPos = poseStack.last().pose();
            color = RGB.toArgb(color, alpha);
            fontRenderer.drawInBatch(text, (float)textX, (float)textY + 1.0f, color, fontShadow, matrixPos, buffers, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        poseStack.popPose();
    }

    public static int getLabelHeight(Font fr, boolean fontShadow) {
        int vpad = fr.isBidirectional() ? 0 : (fontShadow ? 6 : 4);
        Objects.requireNonNull(fr);
        return 9 + vpad;
    }

    public static void drawImage(GuiGraphics graphics, DynamicTexture texture, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(graphics, texture, x, y, (float)((TextureAccess)texture).journeymap$getWidth() * scale, (float)((TextureAccess)texture).journeymap$getHeight() * scale, flip, rotation);
    }

    public static void drawImage(GuiGraphics graphics, DynamicTexture texture, double x, double y, boolean flip, float scale, double rotation, boolean blur) {
        DrawUtil.drawQuad(graphics, texture, 0xFFFFFF, 1.0f, x, y, (float)((TextureAccess)texture).journeymap$getWidth() * scale, (float)((TextureAccess)texture).journeymap$getHeight() * scale, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false, blur);
    }

    public static void drawImage(GuiGraphics graphics, DynamicTexture texture, float alpha, double x, double y, boolean flip, float scale, double rotation) {
        DrawUtil.drawQuad(graphics, texture, 0xFFFFFF, alpha, x, y, (double)((float)((TextureAccess)texture).journeymap$getWidth() * scale), (double)((float)((TextureAccess)texture).journeymap$getHeight() * scale), false, rotation);
    }

    public static void drawClampedImage(GuiGraphics graphics, DynamicTexture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(graphics, texture, color, alpha, x, y, (double)((float)((TextureAccess)texture).journeymap$getWidth() * scale), (double)((float)((TextureAccess)texture).journeymap$getHeight() * scale), false, rotation);
    }

    public static void drawColoredImage(GuiGraphics graphics, DynamicTexture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        DrawUtil.drawQuad(graphics, texture, color, alpha, x, y, (double)((float)((TextureAccess)texture).journeymap$getWidth() * scale), (double)((float)((TextureAccess)texture).journeymap$getHeight() * scale), false, rotation);
    }

    public static void drawColoredImage(GuiGraphics graphics, DynamicTexture texture, int color, float alpha, double x, double y, double rotation) {
        DrawUtil.drawQuad(graphics, texture, color, alpha, x, y, (double)((TextureAccess)texture).journeymap$getWidth(), (double)((TextureAccess)texture).journeymap$getHeight(), false, rotation);
    }

    public static void drawQuad(GuiGraphics graphics, DynamicTexture texture, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(graphics, texture, 0xFFFFFF, 1.0f, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false, true);
    }

    public static void drawQuad(GuiGraphics graphics, DynamicTexture texture, int color, float alpha, double x, double y, double width, double height, boolean flip, double rotation) {
        DrawUtil.drawQuad(graphics, texture, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip, true, 770, 771, false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(GuiGraphics graphics, DynamicTexture texture, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip, boolean blend, int glBlendSfactor, int glBlendDFactor, boolean clampTexture, boolean blur) {
        if (texture == null || texture.getPixels() == null) {
            return;
        }
        PoseStack poseStack = graphics.pose();
        poseStack.pushPose();
        try {
            RenderWrapper.setShader(GameRenderer::getPositionTexShader);
            RenderWrapper.activeTexture(33984);
            RenderWrapper.bindTexture(texture.getId());
            RenderWrapper.setShaderTexture(0, texture.getId());
            if (blend) {
                RenderWrapper.enableBlend();
                RenderWrapper.blendFuncSeparate(glBlendSfactor, glBlendDFactor, 1, 0);
            }
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (blend) {
                float[] c = RGB.floats(color);
                RenderWrapper.setColor4f(c[0], c[1], c[2], alpha);
            } else {
                RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, alpha);
            }
            RenderWrapper.texParameter(3553, 10241, blur ? 9729 : 9728);
            RenderWrapper.texParameter(3553, 10240, blur ? 9729 : 9728);
            int texEdgeBehavior = clampTexture ? 33071 : 10497;
            RenderWrapper.texParameter(3553, 10242, texEdgeBehavior);
            RenderWrapper.texParameter(3553, 10243, texEdgeBehavior);
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.translate(transX, transY, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)rotation));
                poseStack.translate(-transX, -transY, 0.0);
            }
            double direction = flip ? -maxU : maxU;
            RenderWrapper.enableBlend();
            RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
            BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_TEX);
            DrawUtil.addVertexWithUV(graphics, buffer, x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexWithUV(graphics, buffer, x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexWithUV(graphics, buffer, x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexWithUV(graphics, buffer, x, y, zLevel, minU, minV);
            BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
            RenderWrapper.enableBlend();
            if (blend) {
                RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
                if (glBlendSfactor != 770 || glBlendDFactor != 771) {
                    RenderWrapper.enableBlend();
                    RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
                }
            }
        }
        finally {
            poseStack.popPose();
        }
    }

    public static void drawRectangle(GuiGraphics graphics, double x, double y, double width, double height, int color, float alpha) {
        int[] rgba = RGB.ints(color, alpha);
        RenderWrapper.enableBlend();
        RenderWrapper.defaultBlendFunc();
        RenderWrapper.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        DrawUtil.addVertex(graphics.pose().last().pose(), buffer, x, height + y, zLevel, rgba);
        DrawUtil.addVertex(graphics.pose().last().pose(), buffer, x + width, height + y, zLevel, rgba);
        DrawUtil.addVertex(graphics.pose().last().pose(), buffer, x + width, y, zLevel, rgba);
        DrawUtil.addVertex(graphics.pose().last().pose(), buffer, x, y, zLevel, rgba);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.disableBlend();
    }

    public static void drawGradientRect(GuiGraphics graphics, double x, double y, double width, double height, int startColor, float startAlpha, int endColor, float endAlpha) {
        if (startAlpha > 1.0f) {
            startAlpha /= 255.0f;
        }
        if (endAlpha > 1.0f) {
            endAlpha /= 255.0f;
        }
        int[] rgbaStart = RGB.ints(startColor, startAlpha);
        int[] rgbaEnd = RGB.ints(endColor, endAlpha);
        RenderWrapper.enableBlend();
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        RenderWrapper.setShader(GameRenderer::getPositionColorShader);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        DrawUtil.addVertexUV(graphics, buffer, x, height + y, zLevel, 0.0, 1.0, rgbaEnd);
        DrawUtil.addVertexUV(graphics, buffer, x + width, height + y, zLevel, 1.0, 1.0, rgbaEnd);
        DrawUtil.addVertexUV(graphics, buffer, x + width, y, zLevel, 1.0, 0.0, rgbaStart);
        DrawUtil.addVertexUV(graphics, buffer, x, y, zLevel, 0.0, 0.0, rgbaStart);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderWrapper.enableBlend();
    }

    public static void drawColoredEntity(GuiGraphics graphics, double x, double y, DynamicTexture texture, int color, float alpha, float scale, double rotation) {
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        drawX = Math.floor(drawX);
        drawY = Math.floor(drawY);
        DrawUtil.drawColoredImage(graphics, texture, color, alpha, drawX, drawY, scale, rotation);
    }

    public static void sizeDisplay(double width, double height) {
        if (width > 0.0 && height > 0.0) {
            Minecraft.getInstance().renderBuffers().bufferSource().endBatch();
            RenderWrapper.clear(256);
            Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)width, (float)height, 0.0f, 1000.0f, Services.CLIENT_SERVICE.getFarPlane());
            RenderWrapper.setProjectionMatrix(matrix4f, VertexSorting.ORTHOGRAPHIC_Z);
            Matrix4fStack posestack = RenderWrapper.getModelViewStack();
            posestack.identity();
            posestack.translate(0.0f, 0.0f, 10000.0f - Services.CLIENT_SERVICE.getFarPlane());
            RenderWrapper.applyModelViewMatrix();
        }
    }

    public static void drawQuad(GuiGraphics graphics, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double width, double height, double rotation, boolean flip) {
        DrawUtil.drawQuad(graphics, vertexBuilder, color, alpha, x, y, width, height, 0.0, 0.0, 1.0, 1.0, rotation, flip);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawQuad(GuiGraphics graphics, VertexConsumer vertexBuilder, int color, float alpha, double x, double y, double width, double height, double minU, double minV, double maxU, double maxV, double rotation, boolean flip) {
        PoseStack poseStack = graphics.pose();
        try {
            poseStack.pushPose();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            if (rotation != 0.0) {
                double transX = x + width / 2.0;
                double transY = y + height / 2.0;
                poseStack.translate(transX, transY, 0.0);
                poseStack.mulPose(Axis.ZP.rotationDegrees((float)(-rotation)));
                poseStack.translate(-transX, -transY, 0.0);
            }
            float[] rgba = RGB.floats(color, alpha);
            double direction = flip ? -maxU : maxU;
            DrawUtil.addVertexUV(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x, height + y, zLevel, minU, maxV);
            DrawUtil.addVertexUV(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x + width, height + y, zLevel, direction, maxV);
            DrawUtil.addVertexUV(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x + width, y, zLevel, direction, minV);
            DrawUtil.addVertexUV(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], x, y, zLevel, minU, minV);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.popPose();
        }
    }

    public static void drawColoredEntity(GuiGraphics graphics, VertexConsumer vertexBuilder, DynamicTexture texture, int color, float alpha, double x, double y, float scale, double rotation) {
        if (texture == null || texture.getPixels() == null) {
            return;
        }
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        drawX = Math.floor(drawX);
        drawY = Math.floor(drawY);
        DrawUtil.drawQuad(graphics, vertexBuilder, color, alpha, drawX, drawY, width, height, rotation, false);
    }

    public static void drawWaypointIcon(GuiGraphics graphics, VertexConsumer vertexBuilder, DynamicTexture texture, float scale, int color, float alpha, double x, double y, double rotation) {
        if (scale > 1.0f) {
            texture = ((TextureAccess)texture).journeymap$getScaledImage(scale);
            scale = 1.0f;
        }
        double width = (float)((TextureAccess)texture).journeymap$getWidth() * scale;
        double height = (float)((TextureAccess)texture).journeymap$getHeight() * scale;
        double drawX = x - width / 2.0;
        double drawY = y - height / 2.0;
        DrawUtil.drawQuad(graphics, vertexBuilder, color, alpha, drawX, drawY, width, height, rotation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void drawRectangle(GuiGraphics graphics, VertexConsumer vertexBuilder, double x, double y, double width, double height, int color, float alpha) {
        PoseStack poseStack = graphics.pose();
        try {
            poseStack.pushPose();
            if (alpha > 1.0f) {
                alpha /= 255.0f;
            }
            float[] rgba = RGB.floats(color, alpha);
            DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (float)x, (float)(height + y), zLevel);
            DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (float)(x + width), (float)(height + y), zLevel);
            DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (float)(x + width), (float)y, zLevel);
            DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], (float)x, (float)y, zLevel);
        }
        catch (Exception e) {
            Journeymap.getLogger().error((Object)e);
        }
        finally {
            poseStack.popPose();
        }
    }

    public static void drawPolygon(GuiGraphics graphics, MultiBufferSource buffers, double xOffset, double yOffset, List<Point2D.Double> fillPoints, List<List<Point2D.Double>> strokePoints, List<Point2D.Double> texturePoints, DynamicTexture texture, ShapeProperties shapeProperties) {
        int i;
        float[] rgba;
        if (shapeProperties.getFillOpacity() >= 0.01f) {
            rgba = RGB.floats(shapeProperties.getFillColor(), shapeProperties.getFillOpacity());
            int lastIndex = fillPoints.size() - 1;
            if (texture == null || shapeProperties.getTextureScaleX() == 0.0 || shapeProperties.getTextureScaleY() == 0.0) {
                RenderType renderType = JMRenderTypes.POLYGON_WITHOUT_TEXTURE_RENDER_TYPE;
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                for (int i2 = 0; i2 <= lastIndex; ++i2) {
                    Point2D.Double point = fillPoints.get(i2);
                    DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + xOffset, point.getY() + yOffset, zLevel);
                }
            } else {
                double textureWidth = (double)((TextureAccess)texture).journeymap$getWidth() * shapeProperties.getTextureScaleX();
                double textureHeight = (double)((TextureAccess)texture).journeymap$getHeight() * shapeProperties.getTextureScaleY();
                RenderType renderType = JMRenderTypes.getPolygonWithTexture((AbstractTexture)texture);
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                for (i = 0; i <= lastIndex; ++i) {
                    Point2D.Double point = fillPoints.get(i);
                    double xTex = (texturePoints.get(i).getX() - shapeProperties.getTexturePositionX()) / textureWidth;
                    double yTex = (texturePoints.get(i).getY() - shapeProperties.getTexturePositionY()) / textureHeight;
                    DrawUtil.addVertexUV(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + xOffset, point.getY() + yOffset, zLevel, xTex, yTex);
                }
            }
        }
        if (shapeProperties.getStrokeOpacity() >= 0.01f && shapeProperties.getStrokeWidth() > 0.0f) {
            rgba = RGB.floats(shapeProperties.getStrokeColor(), shapeProperties.getStrokeOpacity());
            float insideStroke = 0.0f;
            float outsideStroke = 0.0f;
            switch (shapeProperties.getStrokePosition()) {
                case INSIDE: {
                    insideStroke = shapeProperties.getStrokeWidth();
                    break;
                }
                case CENTER: {
                    outsideStroke = insideStroke = shapeProperties.getStrokeWidth() / 2.0f;
                    break;
                }
                default: {
                    outsideStroke = shapeProperties.getStrokeWidth();
                }
            }
            RenderType renderType = JMRenderTypes.POLYGON_STROKE_RENDER_TYPE;
            for (List<Point2D.Double> screenPoints : strokePoints) {
                if (screenPoints.size() < 3) continue;
                VertexConsumer vertexBuilder = buffers.getBuffer(renderType);
                int lastIndex = screenPoints.size() - 1;
                for (i = 0; i <= lastIndex + 1; ++i) {
                    int iPoint = i <= lastIndex ? i : 0;
                    int iPrev = iPoint > 0 ? iPoint - 1 : lastIndex;
                    int iNext = iPoint < lastIndex ? iPoint + 1 : 0;
                    Point2D.Double point = screenPoints.get(iPoint);
                    Point2D.Double prev = screenPoints.get(iPrev);
                    Point2D.Double next = screenPoints.get(iNext);
                    Point2D.Double normal = DrawUtil.calculateNormal(prev, point, next);
                    DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() + normal.getX() * (double)insideStroke + xOffset, point.getY() + normal.getY() * (double)insideStroke + yOffset, zLevel);
                    DrawUtil.addVertex(graphics, vertexBuilder, rgba[0], rgba[1], rgba[2], rgba[3], point.getX() - normal.getX() * (double)outsideStroke + xOffset, point.getY() - normal.getY() * (double)outsideStroke + yOffset, zLevel);
                }
            }
        }
    }

    private static Point2D.Double calculateNormal(Point2D.Double prev, Point2D.Double point, Point2D.Double next) {
        Vec2 edgeNormal2;
        Vec2 edge1 = new Vec2((float)(point.x - prev.x), (float)(point.y - prev.y));
        Vec2 edge2 = new Vec2((float)(next.x - point.x), (float)(next.y - point.y));
        Vec2 edgeNormal1 = new Vec2(-edge1.y, edge1.x).normalized();
        Vec2 vertexNormal = edgeNormal1.add(edgeNormal2 = new Vec2(-edge2.y, edge2.x).normalized()).normalized();
        double angle = Math.acos(vertexNormal.dot(edgeNormal1));
        double factor = Math.cos(angle);
        if (factor < 0.1) {
            factor = 0.1;
        }
        factor = 1.0 / factor;
        return new Point2D.Double((double)vertexNormal.x * factor, (double)vertexNormal.y * factor);
    }

    public static void drawRectangle(Matrix4f matrixPos, double x, double y, double width, double height, int color) {
        DrawUtil.fill(matrixPos, (int)x, (int)y, (int)(x + width), (int)(height + y), color);
    }

    public static void fill(Matrix4f matrixPos, int x, int y, int bottomX, int bottomY, int color) {
        if (x < bottomX) {
            int i = x;
            x = bottomX;
            bottomX = i;
        }
        if (y < bottomY) {
            int j = y;
            y = bottomY;
            bottomY = j;
        }
        float f3 = (float)(color >> 24 & 0xFF) / 255.0f;
        float f = (float)(color >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(color >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(color & 0xFF) / 255.0f;
        RenderWrapper.enableBlend();
        RenderWrapper.setShader(GameRenderer::getPositionColorShader);
        RenderWrapper.blendFuncSeparate(770, 771, 1, 0);
        BufferBuilder buffer = Tesselator.getInstance().begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR);
        buffer.addVertex(matrixPos, (float)x, (float)bottomY, 0.0f).setColor(f, f1, f2, f3);
        buffer.addVertex(matrixPos, (float)bottomX, (float)bottomY, 0.0f).setColor(f, f1, f2, f3);
        buffer.addVertex(matrixPos, (float)bottomX, (float)y, 0.0f).setColor(f, f1, f2, f3);
        buffer.addVertex(matrixPos, (float)x, (float)y, 0.0f).setColor(f, f1, f2, f3);
        BufferUploader.drawWithShader((MeshData)buffer.buildOrThrow());
        RenderWrapper.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        RenderWrapper.disableBlend();
    }

    public static void addVertexUV(GuiGraphics graphics, VertexConsumer bufferIn, float red, float green, float blue, float alpha, int y, float x, float z, float texU, float texV) {
        bufferIn.addVertex(graphics.pose().last().pose(), x, (float)y, z).setColor(red, green, blue, alpha).setUv(texU, texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(graphics.pose().last(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertexUV(GuiGraphics graphics, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, double z, double texU, double texV) {
        bufferIn.addVertex(graphics.pose().last().pose(), (float)x, (float)y, (float)z).setColor(red, green, blue, alpha).setUv((float)texU, (float)texV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(graphics.pose().last(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertex(GuiGraphics graphics, VertexConsumer bufferIn, float red, float green, float blue, float alpha, double x, double y, double z) {
        bufferIn.addVertex(graphics.pose().last().pose(), (float)x, (float)y, (float)z).setColor(red, green, blue, alpha).setNormal(graphics.pose().last(), 0.0f, 1.0f, 0.0f);
    }

    public static void addVertexWithUV(GuiGraphics graphics, BufferBuilder buff, float x, float y, float z, float u, float v) {
        PoseStack.Pose entry = graphics.pose().last();
        Matrix4f matrix4f = entry.pose();
        buff.addVertex(matrix4f, x, y, z).setUv(u, v);
    }

    public static void addVertexWithUV(GuiGraphics graphics, BufferBuilder buff, double x, double y, double z, double u, double v) {
        DrawUtil.addVertexWithUV(graphics, buff, (float)x, (float)y, (float)z, (float)u, (float)v);
    }

    public static void addVertexUV(GuiGraphics graphics, BufferBuilder buff, double x, double y, double z, double u, double v, int[] rgba) {
        PoseStack.Pose entry = graphics.pose().last();
        Matrix4f matrix4f = entry.pose();
        buff.addVertex(matrix4f, (float)x, (float)y, (float)z).setColor(rgba[0], rgba[1], rgba[2], rgba[3]).setUv((float)u, (float)v);
    }

    private static void addVertex(Matrix4f mat, BufferBuilder buff, double x, double y, double z, int[] rgba) {
        buff.addVertex(mat, (float)x, (float)y, (float)z).setColor(rgba[0], rgba[1], rgba[2], rgba[3]);
    }

    public static enum HAlign {
        Left,
        Center,
        Right;

    }

    public static enum VAlign {
        Above,
        Middle,
        Below;

    }
}

