/*
 * Decompiled with CFR 0.152.
 */
package journeymap.api.client.impl;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import journeymap.api.client.impl.InfoSlotFactory;
import journeymap.api.services.EventBus;
import journeymap.api.v2.client.event.RegistryEvent;
import journeymap.api.v2.client.option.BooleanOption;
import journeymap.api.v2.client.option.Config;
import journeymap.api.v2.client.option.CustomIntegerOption;
import journeymap.api.v2.client.option.CustomTextOption;
import journeymap.api.v2.client.option.EnumOption;
import journeymap.api.v2.client.option.FloatOption;
import journeymap.api.v2.client.option.IntegerOption;
import journeymap.api.v2.client.option.Option;
import journeymap.api.v2.client.option.OptionCategory;
import journeymap.api.v2.client.option.OptionsRegistry;
import journeymap.client.properties.AddonProperties;
import journeymap.client.properties.ClientCategory;
import journeymap.common.Journeymap;
import journeymap.common.properties.PropertiesBase;
import journeymap.common.properties.catagory.Category;
import journeymap.common.properties.config.BooleanField;
import journeymap.common.properties.config.ConfigField;
import journeymap.common.properties.config.CustomField;
import journeymap.common.properties.config.EnumField;
import journeymap.common.properties.config.FloatField;
import journeymap.common.properties.config.IntegerField;

public class OptionsDisplayFactory {
    public static final Map<String, AddonProperties> PROPERTIES_REGISTRY = new HashMap<String, AddonProperties>();
    public static final Map<String, Map<String, ConfigField<?>>> MOD_FIELD_REGISTRY = new HashMap();
    private final List<AddonProperties> addonPropertiesList = new ArrayList<AddonProperties>();

    public OptionsDisplayFactory() {
        EventBus.post(new RegistryEvent.InfoSlotRegistryEvent((RegistryEvent.InfoSlotRegistryEvent.InfoSlotRegistrar)new InfoSlotFactory()));
        EventBus.post(new RegistryEvent.OptionsRegistryEvent());
    }

    public static void register(String modId, AddonProperties prop) {
        PROPERTIES_REGISTRY.put(modId, prop);
    }

    public static void register(String modId, Map<String, ConfigField<?>> fieldMap) {
        MOD_FIELD_REGISTRY.put(modId, fieldMap);
    }

    public static Map<String, ConfigField<?>> getAllFields() {
        return MOD_FIELD_REGISTRY.values().stream().flatMap(map -> map.entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public OptionsDisplayFactory buildAddonProperties() {
        OptionsRegistry.OPTION_REGISTRY.forEach((modId, map) -> {
            AddonProperties prop = new AddonProperties();
            HashMap fieldMap = new HashMap();
            map.forEach((name, option) -> {
                ConfigField field = this.createField((Option)option);
                if (field != null) {
                    fieldMap.put(option.getFieldName(), field);
                }
            });
            prop.setName((String)modId);
            prop.setFieldMap(fieldMap);
            this.addonPropertiesList.add(prop);
            OptionsDisplayFactory.register(modId, fieldMap);
            OptionsDisplayFactory.register(modId, prop);
        });
        return this;
    }

    public OptionsDisplayFactory load() {
        this.addonPropertiesList.forEach(PropertiesBase::load);
        return this;
    }

    public void save() {
        this.addonPropertiesList.forEach(PropertiesBase::save);
    }

    private ConfigField createField(Option option) {
        try {
            ConfigField configField = null;
            int sortOrder = option.getSortOrder();
            Category category = this.getCategory(option);
            if (option instanceof BooleanOption) {
                BooleanOption booleanOption = (BooleanOption)option;
                configField = new BooleanField(category, option.getLabel(), (Boolean)booleanOption.getDefaultValue(), booleanOption.isMaster(), sortOrder);
            } else if (option instanceof EnumOption) {
                EnumOption enumOption = (EnumOption)option;
                configField = new EnumField<Enum>(category, option.getLabel(), (Enum)enumOption.getDefaultValue(), sortOrder);
            } else if (option instanceof CustomTextOption) {
                CustomTextOption customOption = (CustomTextOption)option;
                configField = new CustomField(category, option.getLabel(), (String)customOption.getDefaultValue(), sortOrder);
            } else if (option instanceof CustomIntegerOption) {
                CustomIntegerOption customOption = (CustomIntegerOption)option;
                configField = new CustomField(category, option.getLabel(), customOption.getMinValue(), customOption.getMaxValue(), (Integer)customOption.getDefaultValue(), sortOrder, customOption.getAllowNeg());
            } else if (option instanceof IntegerOption) {
                IntegerOption integerOption = (IntegerOption)option;
                configField = new IntegerField(category, option.getLabel(), integerOption.getMinValue(), integerOption.getMaxValue(), (Integer)integerOption.getDefaultValue(), sortOrder);
            } else if (option instanceof FloatOption) {
                FloatOption floatOption = (FloatOption)option;
                configField = new FloatField(category, option.getLabel(), floatOption.getMinValue(), floatOption.getMaxValue(), ((Float)floatOption.getDefaultValue()).floatValue(), floatOption.getIncrementValue(), floatOption.getPrecision(), sortOrder);
            } else {
                throw new UnsupportedOperationException("Type not supported for " + option.getClass().getSimpleName());
            }
            Method method = Option.class.getDeclaredMethod("setConfig", Config.class);
            method.setAccessible(true);
            method.invoke((Object)option, configField);
            return configField;
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            Journeymap.getLogger().error("Unable to get ConfigField from option:{}", (Object)option.getClass().getName(), (Object)e);
            return null;
        }
    }

    private Category getCategory(Option option) {
        OptionCategory optionCategory = option.getCategory();
        if ("Hidden".equalsIgnoreCase(optionCategory.getLabel())) {
            return Category.Hidden;
        }
        return ClientCategory.create(optionCategory.getModId(), optionCategory.getLabel(), optionCategory.getToolTip());
    }
}

