/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mixin.typing;

import dev.arbor.extrasoundsnext.sounds.SoundManager;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={EditBox.class})
public abstract class TextFieldWidgetMixin {
    @Unique
    private int extra_sounds$cursorStart = 0;
    @Unique
    private int extra_sounds$cursorEnd = 0;
    @Shadow
    private int cursorPos;
    @Shadow
    private int highlightPos;
    @Shadow
    private int maxLength;

    @Shadow
    public abstract String getHighlighted();

    @Shadow
    public abstract String getValue();

    @Unique
    private void extrasounds$cursorChanged() {
        boolean bSamePos;
        boolean bl = bSamePos = this.extra_sounds$cursorStart == this.cursorPos && this.extra_sounds$cursorEnd == this.highlightPos;
        if (bSamePos) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.CURSOR);
        this.extra_sounds$cursorStart = this.cursorPos;
        this.extra_sounds$cursorEnd = this.highlightPos;
    }

    @Inject(method={"deleteText(I)V"}, at={@At(value="HEAD")})
    private void extrasounds$eraseStrHead(int offset, CallbackInfo ci) {
        boolean bTailDelete;
        boolean bHeadBackspace = offset < 0 && this.cursorPos <= 0;
        boolean bl = bTailDelete = offset > 0 && this.highlightPos >= this.getValue().length();
        if ((bHeadBackspace || bTailDelete) && this.cursorPos == this.highlightPos) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.ERASE);
    }

    @Inject(method={"deleteText(I)V"}, at={@At(value="RETURN")})
    private void extrasounds$eraseStrReturn(int offset, CallbackInfo ci) {
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.highlightPos;
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getHighlighted()Ljava/lang/String;", shift=At.Shift.AFTER)})
    private void extrasounds$cutAction(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!Screen.isCut((int)keyCode) || this.getHighlighted().isEmpty()) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.CUT);
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.highlightPos;
    }

    @Inject(method={"charTyped(CI)Z"}, at={@At(value="RETURN")})
    private void extrasounds$appendChar(char chr, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!((Boolean)cir.getReturnValue()).booleanValue() || this.getValue().length() >= this.maxLength) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.INSERT);
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.highlightPos;
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/KeyboardHandler;getClipboard()Ljava/lang/String;", shift=At.Shift.AFTER)})
    private void extrasounds$pasteAction(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!Screen.isPaste((int)keyCode) || this.getValue().length() >= this.maxLength) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.PASTE);
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.highlightPos;
    }

    @Inject(method={"keyPressed(III)Z"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;getWordPosition(I)I", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursor(IZ)V", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorToStart(Z)V", shift=At.Shift.AFTER), @At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorToEnd(Z)V", shift=At.Shift.AFTER)})
    private void extrasounds$cursorMoveKeyTyped(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        this.extrasounds$cursorChanged();
    }

    @Inject(method={"onClick(DD)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/EditBox;moveCursorTo(IZ)V", shift=At.Shift.AFTER)})
    private void extrasounds$clickEvent(double mouseX, double mouseY, CallbackInfo ci) {
        this.extrasounds$cursorChanged();
    }
}

