/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.mixin.typing;

import dev.arbor.extrasoundsnext.sounds.SoundManager;
import java.util.function.Supplier;
import net.minecraft.client.gui.font.TextFieldHelper;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TextFieldHelper.class})
public abstract class SelectionManagerMixin {
    @Unique
    private int extra_sounds$cursorStart = 0;
    @Unique
    private int extra_sounds$cursorEnd = 0;
    @Unique
    private boolean extra_sounds$bPasteAction = false;
    @Unique
    private static final String METHOD_SIGN_DELETE = "removeFromCursor(ILnet/minecraft/client/gui/font/TextFieldHelper$CursorStep;)V";
    @Shadow
    private int cursorPos;
    @Shadow
    private int selectionPos;
    @Shadow
    @Final
    private Supplier<String> getMessageFn;

    @Unique
    private boolean extrasounds$isPosUpdated() {
        return this.extra_sounds$cursorStart == this.cursorPos && this.extra_sounds$cursorEnd == this.selectionPos;
    }

    @Inject(method={"removeFromCursor(ILnet/minecraft/client/gui/font/TextFieldHelper$CursorStep;)V"}, at={@At(value="HEAD")})
    private void extrasounds$beforeDelete(int offset, TextFieldHelper.CursorStep selectionType, CallbackInfo ci) {
        boolean bTailDelete;
        String text = this.getMessageFn.get();
        boolean bHeadBackspace = offset < 0 && this.cursorPos <= 0;
        boolean bl = bTailDelete = offset > 0 && this.selectionPos >= text.length();
        if ((bHeadBackspace || bTailDelete) && this.cursorPos == this.selectionPos) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.ERASE);
    }

    @Inject(method={"removeFromCursor(ILnet/minecraft/client/gui/font/TextFieldHelper$CursorStep;)V"}, at={@At(value="RETURN")})
    private void extrasounds$afterDelete(int offset, TextFieldHelper.CursorStep selectionType, CallbackInfo ci) {
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.selectionPos;
    }

    @Inject(method={"cut()V"}, at={@At(value="HEAD")})
    private void extrasounds$cutAction(CallbackInfo ci) {
        if (this.cursorPos == this.selectionPos) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.CUT);
    }

    @Inject(method={"cut()V"}, at={@At(value="RETURN")})
    private void extrasounds$afterCut(CallbackInfo ci) {
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.selectionPos;
    }

    @Inject(method={"insertText(Ljava/lang/String;Ljava/lang/String;)V"}, at={@At(value="RETURN")})
    private void extrasounds$appendChar(String string, String insertion, CallbackInfo ci) {
        if (this.extrasounds$isPosUpdated()) {
            return;
        }
        if (this.extra_sounds$bPasteAction) {
            SoundManager.keyboard(SoundManager.KeyType.PASTE);
            this.extra_sounds$bPasteAction = false;
        } else if (insertion.equals("\n")) {
            SoundManager.keyboard(SoundManager.KeyType.RETURN);
        } else {
            SoundManager.keyboard(SoundManager.KeyType.INSERT);
        }
        this.extra_sounds$cursorStart = this.extra_sounds$cursorEnd = this.selectionPos;
    }

    @Inject(method={"paste()V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/TextFieldHelper;insertText(Ljava/lang/String;Ljava/lang/String;)V")})
    private void extrasounds$pasteAction(CallbackInfo ci) {
        this.extra_sounds$bPasteAction = true;
    }

    @Inject(method={"resetSelectionIfNeeded(Z)V"}, at={@At(value="RETURN")})
    private void extrasounds$moveCursor(boolean shiftDown, CallbackInfo ci) {
        if (this.extrasounds$isPosUpdated()) {
            return;
        }
        SoundManager.keyboard(SoundManager.KeyType.CURSOR);
        this.extra_sounds$cursorStart = this.cursorPos;
        this.extra_sounds$cursorEnd = this.selectionPos;
    }
}

