/*
 * Decompiled with CFR 0.152.
 */
package dev.arbor.extrasoundsnext.gui;

import com.mojang.datafixers.util.Pair;
import dev.arbor.extrasoundsnext.gui.ImageButton;
import dev.arbor.extrasoundsnext.sounds.SoundSouceInit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.OptionInstance;
import net.minecraft.client.Options;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoundList
extends ContainerObjectSelectionList<SoundEntry> {
    public SoundList(Minecraft minecraftClient, int width, int height, int y, int itemHeight) {
        super(minecraftClient, width, height, y, itemHeight);
        this.centerListVertically = false;
    }

    public void addSingleOptionEntry(OptionInstance<?> option) {
        this.addEntry((AbstractSelectionList.Entry)SoundEntry.create(this.minecraft.options, this.width, option));
    }

    public void addOptionEntry(OptionInstance<?> firstOption, @Nullable OptionInstance<?> secondOption) {
        this.addEntry((AbstractSelectionList.Entry)SoundEntry.createDouble(this.minecraft.options, this.width, firstOption, secondOption));
    }

    public void addAll(OptionInstance<?>[] options) {
        for (int i = 0; i < options.length; i += 2) {
            this.addOptionEntry(options[i], i < options.length - 1 ? options[i + 1] : null);
        }
    }

    public void addCategory(SoundSource cat) {
        this.addSingleOptionEntry(this.createCustomizedOption(cat));
    }

    public void addDoubleCategory(SoundSource first, @Nullable SoundSource second) {
        this.addOptionEntry(this.createCustomizedOption(first), second != null ? this.createCustomizedOption(second) : null);
    }

    public void addAllCategory(SoundSource[] categories) {
        this.addAll((OptionInstance[])Arrays.stream(categories).map(this::createCustomizedOption).toArray(OptionInstance[]::new));
    }

    public void addGroup(SoundSource group, Button.OnPress pressAction) {
        super.addEntry((AbstractSelectionList.Entry)SoundEntry.createGroup(this.minecraft.options, this.createCustomizedOption(group), this.width, pressAction));
    }

    public int getRowWidth() {
        return 310;
    }

    protected int getScrollbarPosition() {
        return super.getScrollbarPosition() + 32;
    }

    private OptionInstance<?> createCustomizedOption(SoundSource category) {
        OptionInstance simpleOption = this.minecraft.options.getSoundSourceOptionInstance(category);
        if (((Boolean)SoundSouceInit.TOGGLEABLE_CATS.getOrDefault(category, (Pair<Boolean, Boolean>)Pair.of((Object)false, (Object)false)).getFirst()).booleanValue()) {
            return OptionInstance.createBoolean((String)simpleOption.toString(), value -> Tooltip.create((Component)SoundSouceInit.TOOLTIPS.getOrDefault(category, CommonComponents.EMPTY)), ((Double)simpleOption.get() == 1.0 ? 1 : 0) != 0, value -> simpleOption.set((Object)(value != false ? 1.0 : 0.0)));
        }
        return simpleOption;
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static class SoundEntry
    extends ContainerObjectSelectionList.Entry<SoundEntry> {
        List<? extends AbstractWidget> widgets;

        public SoundEntry(List<? extends AbstractWidget> w) {
            this.widgets = w;
        }

        public static SoundEntry create(Options options, int width, OptionInstance<?> simpleOption) {
            return new SoundEntry(List.of(simpleOption.createButton(options, width / 2 - 155, 0, 310)));
        }

        public static SoundEntry createDouble(Options options, int width, OptionInstance<?> first, @Nullable OptionInstance<?> second) {
            ArrayList<AbstractWidget> widgets = new ArrayList<AbstractWidget>();
            widgets.add(first.createButton(options, width / 2 - 155, 0, 150));
            if (second != null) {
                widgets.add(second.createButton(options, width / 2 + 5, 0, 150));
            }
            return new SoundEntry(widgets);
        }

        public static SoundEntry createGroup(Options options, OptionInstance<?> group, int width, Button.OnPress pressAction) {
            return new SoundEntry(List.of(group.createButton(options, width / 2 - 155, 0, 285), new ImageButton(width / 2 + 135, 0, 20, 20, pressAction)));
        }

        @NotNull
        public List<? extends GuiEventListener> children() {
            return this.widgets;
        }

        @NotNull
        public List<? extends NarratableEntry> narratables() {
            return this.widgets;
        }

        public void render(@NotNull GuiGraphics context, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float tickDelta) {
            this.widgets.forEach(s -> {
                s.setY(y);
                s.render(context, mouseX, mouseY, tickDelta);
            });
        }
    }
}

