/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createcentralkitchen.integration.kelaidoscopecookery.mechanicalArm;

import com.github.ysbbbbbb.kaleidoscopecookery.blockentity.kitchen.ShawarmaSpitBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmBlockEntity;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPoint;
import com.simibubi.create.content.kinetics.mechanicalArm.ArmInteractionPointType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeInput;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.SingleRecipeInput;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class ShawarmaSpitArmInteractionPoint
extends ArmInteractionPoint {
    public static RecipeManager.CachedCheck<SingleRecipeInput, CampfireCookingRecipe> QUICK_CHECK;

    public ShawarmaSpitArmInteractionPoint(ArmInteractionPointType type, Level level, BlockPos pos, BlockState state) {
        super(type, level, pos, state);
        if (QUICK_CHECK == null) {
            QUICK_CHECK = RecipeManager.createCheck((RecipeType)RecipeType.CAMPFIRE_COOKING);
        }
    }

    public ItemStack extract(ArmBlockEntity armBlockEntity, int slot, int amount, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity interaction = (ShawarmaSpitBlockEntity)blockEntity;
            if (interaction.cookTime == 0 && !interaction.cookedItem.isEmpty()) {
                ItemStack result = interaction.cookedItem.copy();
                if (!simulate) {
                    interaction.cookingItem = ItemStack.EMPTY;
                    interaction.cookedItem = ItemStack.EMPTY;
                    interaction.cookTime = 0;
                    interaction.refresh();
                }
                return result;
            }
        }
        return ItemStack.EMPTY;
    }

    public int getSlotCount(ArmBlockEntity armBlockEntity) {
        return 1;
    }

    public ItemStack insert(ArmBlockEntity armBlockEntity, ItemStack stack, boolean simulate) {
        BlockEntity blockEntity = this.level.getBlockEntity(this.pos);
        if (blockEntity instanceof ShawarmaSpitBlockEntity) {
            ShawarmaSpitBlockEntity interaction = (ShawarmaSpitBlockEntity)blockEntity;
            if (interaction.cookingItem.isEmpty() && interaction.cookedItem.isEmpty() && QUICK_CHECK.getRecipeFor((RecipeInput)new SingleRecipeInput(stack), armBlockEntity.getLevel()).isPresent()) {
                if (simulate) {
                    ItemStack result = stack.copy();
                    result.shrink(8);
                    return result;
                }
                interaction.onPutCookingItem(this.level, stack);
                return stack;
            }
        }
        return stack;
    }

    protected Vec3 getInteractionPositionVector() {
        return Vec3.upFromBottomCenterOf((Vec3i)this.pos, (double)0.5);
    }

    public static class Type
    extends ArmInteractionPointType {
        public boolean canCreatePoint(Level level, BlockPos pos, BlockState state) {
            return level.getBlockEntity(pos) instanceof ShawarmaSpitBlockEntity;
        }

        @Nullable
        public ArmInteractionPoint createPoint(Level level, BlockPos pos, BlockState state) {
            return new ShawarmaSpitArmInteractionPoint(this, level, pos, state);
        }
    }
}

