/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.ribbits.module.StructureProcessorTypeModule;
import com.yungnickyoung.minecraft.yungsapi.api.world.randomize.BlockStateRandomizer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.WorldGenRegion;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;
import net.minecraft.world.level.material.FluidState;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class PodzolProcessor
extends StructureProcessor {
    public static final PodzolProcessor INSTANCE = new PodzolProcessor();
    public static final MapCodec<PodzolProcessor> CODEC = MapCodec.unit(() -> INSTANCE);
    private final BlockStateRandomizer OUTPUT = new BlockStateRandomizer(Blocks.PODZOL.defaultBlockState()).addBlock(Blocks.COARSE_DIRT.defaultBlockState(), 0.3f);

    public StructureTemplate.StructureBlockInfo processBlock(LevelReader levelReader, BlockPos jigsawPiecePos, BlockPos jigsawPieceBottomCenterPos, StructureTemplate.StructureBlockInfo blockInfoLocal, StructureTemplate.StructureBlockInfo blockInfoGlobal, StructurePlaceSettings structurePlacementData) {
        if (blockInfoGlobal.state().is(Blocks.PODZOL)) {
            WorldGenRegion worldGenRegion;
            if (levelReader instanceof WorldGenRegion && !(worldGenRegion = (WorldGenRegion)levelReader).getCenter().equals((Object)new ChunkPos(blockInfoGlobal.pos()))) {
                return blockInfoGlobal;
            }
            RandomSource random = structurePlacementData.getRandom(blockInfoGlobal.pos());
            int y = levelReader.getHeight(Heightmap.Types.WORLD_SURFACE_WG, blockInfoGlobal.pos().getX(), blockInfoGlobal.pos().getZ()) - 1;
            BlockPos blockPos = new BlockPos(blockInfoGlobal.pos().getX(), y, blockInfoGlobal.pos().getZ());
            FluidState fluidState = levelReader.getFluidState(blockPos);
            BlockState blockStateBelow = levelReader.getBlockState(blockPos.below());
            blockInfoGlobal = fluidState.isEmpty() || blockStateBelow.isSolidRender((BlockGetter)levelReader, blockPos.below()) ? new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), this.OUTPUT.get(random), null) : new StructureTemplate.StructureBlockInfo(blockInfoGlobal.pos(), Blocks.OAK_PLANKS.defaultBlockState(), null);
        }
        return blockInfoGlobal;
    }

    protected StructureProcessorType<?> getType() {
        return StructureProcessorTypeModule.PODZOL_PROCESSOR;
    }
}

