/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity.goal;

import com.yungnickyoung.minecraft.ribbits.entity.RibbitEntity;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.animal.frog.Frog;

public class RibbitStopAndStareAtFrogGoal
extends Goal {
    private final RibbitEntity ribbit;
    @Nullable
    private Frog followingFrog;
    private final float searchRadius;

    public RibbitStopAndStareAtFrogGoal(RibbitEntity ribbit, float searchRadius) {
        this.ribbit = ribbit;
        this.searchRadius = searchRadius;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean canUse() {
        List nearbyFrogs = this.ribbit.level().getEntitiesOfClass(Frog.class, this.ribbit.getBoundingBox().inflate((double)this.searchRadius), target -> target instanceof Frog);
        if (!nearbyFrogs.isEmpty()) {
            for (Frog frog : nearbyFrogs) {
                if (frog.isInvisible() || !this.ribbit.hasLineOfSight((Entity)frog)) continue;
                this.followingFrog = frog;
                return true;
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.followingFrog != null && !this.followingFrog.isInvisible() && this.ribbit.hasLineOfSight((Entity)this.followingFrog) && this.ribbit.distanceToSqr((Entity)this.followingFrog) <= (double)(this.searchRadius * this.searchRadius);
    }

    public void start() {
    }

    public void stop() {
        this.followingFrog = null;
    }

    public void tick() {
        if (this.followingFrog != null && !this.ribbit.isLeashed()) {
            this.ribbit.getLookControl().setLookAt((Entity)this.followingFrog, 10.0f, (float)this.ribbit.getMaxHeadXRot());
        }
    }
}

