/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.block;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class SwampPlantBlock
extends BushBlock
implements BonemealableBlock {
    public static final MapCodec<SwampPlantBlock> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)SwampPlantBlock.propertiesCodec(), (App)ResourceKey.codec((ResourceKey)Registries.PLACED_FEATURE).fieldOf("bonemeal_patch").forGetter(block -> block.bonemealPatch)).apply((Applicative)builder, SwampPlantBlock::new));
    private static final VoxelShape SHAPE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private final ResourceKey<PlacedFeature> bonemealPatch;

    public SwampPlantBlock(BlockBehaviour.Properties properties, ResourceKey<PlacedFeature> bonemealPatch) {
        super(properties);
        this.bonemealPatch = bonemealPatch;
    }

    public VoxelShape getShape(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        Vec3 offset = blockState.getOffset(blockGetter, blockPos);
        return SHAPE.move(offset.x, offset.y, offset.z);
    }

    public boolean isValidBonemealTarget(LevelReader levelReader, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public boolean isBonemealSuccess(Level level, RandomSource random, BlockPos blockPos, BlockState blockState) {
        return true;
    }

    public void performBonemeal(ServerLevel serverLevel, RandomSource random, BlockPos blockPos, BlockState blockState) {
        Optional placedFeature = serverLevel.registryAccess().registryOrThrow(Registries.PLACED_FEATURE).getOptional(this.bonemealPatch);
        placedFeature.ifPresent(feature -> feature.place((WorldGenLevel)serverLevel, serverLevel.getChunkSource().getGenerator(), random, blockPos));
    }

    protected MapCodec<? extends BushBlock> codec() {
        return CODEC;
    }
}

