/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.chipped.common.blocks;

import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import java.util.Random;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ThrownTrident;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CauldronBlock;
import net.minecraft.world.level.block.Fallable;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DripstoneThickness;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
public class SpecialPointedDripstoneBlock
extends Block
implements Fallable,
SimpleWaterloggedBlock {
    public static final DirectionProperty TIP_DIRECTION = BlockStateProperties.VERTICAL_DIRECTION;
    public static final EnumProperty<DripstoneThickness> THICKNESS = BlockStateProperties.DRIPSTONE_THICKNESS;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    private static final VoxelShape TIP_MERGE_SHAPE = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_UP = Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0);
    private static final VoxelShape TIP_SHAPE_DOWN = Block.box((double)5.0, (double)5.0, (double)5.0, (double)11.0, (double)16.0, (double)11.0);
    private static final VoxelShape FRUSTUM_SHAPE = Block.box((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    private static final VoxelShape MIDDLE_SHAPE = Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0);
    private static final VoxelShape BASE_SHAPE = Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)16.0, (double)14.0);
    private static final VoxelShape REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0);

    public SpecialPointedDripstoneBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)TIP_DIRECTION, (Comparable)Direction.UP)).setValue(THICKNESS, (Comparable)DripstoneThickness.TIP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{TIP_DIRECTION, THICKNESS, WATERLOGGED});
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        return SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, (Direction)state.getValue((Property)TIP_DIRECTION));
    }

    @NotNull
    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        if (((Boolean)state.getValue((Property)WATERLOGGED)).booleanValue()) {
            level.scheduleTick(currentPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)level));
        }
        if (direction != Direction.UP && direction != Direction.DOWN) {
            return state;
        }
        Direction direction2 = (Direction)state.getValue((Property)TIP_DIRECTION);
        if (direction2 == Direction.DOWN && level.getBlockTicks().hasScheduledTick(currentPos, (Object)this)) {
            return state;
        }
        if (direction == direction2.getOpposite() && !this.canSurvive(state, (LevelReader)level, currentPos)) {
            if (direction2 == Direction.DOWN) {
                level.scheduleTick(currentPos, (Block)this, 2);
            } else {
                level.scheduleTick(currentPos, (Block)this, 1);
            }
            return state;
        }
        boolean bl = state.getValue(THICKNESS) == DripstoneThickness.TIP_MERGE;
        DripstoneThickness dripstoneThickness = SpecialPointedDripstoneBlock.calculateDripstoneThickness((LevelReader)level, currentPos, direction2, bl);
        return (BlockState)state.setValue(THICKNESS, (Comparable)dripstoneThickness);
    }

    public void onProjectileHit(Level level, BlockState state, BlockHitResult hit, Projectile projectile) {
        BlockPos blockPos = hit.getBlockPos();
        if (!level.isClientSide && projectile.mayInteract(level, blockPos) && projectile instanceof ThrownTrident && projectile.getDeltaMovement().length() > 0.6) {
            level.destroyBlock(blockPos, true);
        }
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP && state.getValue(THICKNESS) == DripstoneThickness.TIP) {
            entity.causeFallDamage(fallDistance + 2.0f, 2.0f, level.damageSources().stalagmite());
        } else {
            super.fallOn(level, state, pos, entity, fallDistance);
        }
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, Random random) {
        float f;
        if (SpecialPointedDripstoneBlock.canDrip(state) && !((f = random.nextFloat()) > 0.12f)) {
            SpecialPointedDripstoneBlock.getFluidAboveStalactite(level, pos, state).filter(fluid -> f < 0.02f || SpecialPointedDripstoneBlock.canFillCauldron(fluid)).ifPresent(fluid -> SpecialPointedDripstoneBlock.spawnDripParticle(level, pos, state, fluid));
        }
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        if (SpecialPointedDripstoneBlock.isStalagmite(state) && !this.canSurvive(state, (LevelReader)level, pos)) {
            level.destroyBlock(pos, true);
        } else {
            SpecialPointedDripstoneBlock.spawnFallingStalactite(state, level, pos);
        }
    }

    public void randomTick(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        SpecialPointedDripstoneBlock.maybeFillCauldron(state, level, pos, random.nextFloat());
        if (random.nextFloat() < 0.011377778f && SpecialPointedDripstoneBlock.isStalactiteStartPos(state, (LevelReader)level, pos)) {
            SpecialPointedDripstoneBlock.growStalactiteOrStalagmiteIfPossible(state, level, pos, random);
        }
    }

    @VisibleForTesting
    public static void maybeFillCauldron(BlockState state, ServerLevel level, BlockPos pos, float randChance) {
        if (!(randChance > 0.17578125f && randChance > 0.05859375f || !SpecialPointedDripstoneBlock.isStalactiteStartPos(state, (LevelReader)level, pos))) {
            BlockPos blockPos2;
            BlockPos blockPos;
            float f;
            Fluid fluid = SpecialPointedDripstoneBlock.getCauldronFillFluidType((Level)level, pos);
            if (fluid == Fluids.WATER) {
                f = 0.17578125f;
            } else {
                if (fluid != Fluids.LAVA) {
                    return;
                }
                f = 0.05859375f;
            }
            if (!(randChance >= f) && (blockPos = SpecialPointedDripstoneBlock.findTip(state, (LevelAccessor)level, pos, 11, false)) != null && (blockPos2 = SpecialPointedDripstoneBlock.findFillableCauldronBelowStalactiteTip((Level)level, blockPos, fluid)) != null) {
                level.levelEvent(1504, blockPos, 0);
                int i = blockPos.getY() - blockPos2.getY();
                int j = 50 + i;
                BlockState blockState = level.getBlockState(blockPos2);
                level.scheduleTick(blockPos2, blockState.getBlock(), j);
            }
        }
    }

    @NotNull
    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction;
        BlockPos blockPos;
        Level levelAccessor = context.getLevel();
        Direction direction2 = SpecialPointedDripstoneBlock.calculateTipDirection((LevelReader)levelAccessor, blockPos = context.getClickedPos(), direction = context.getNearestLookingVerticalDirection().getOpposite());
        if (direction2 == null) {
            return null;
        }
        boolean bl = !context.isSecondaryUseActive();
        DripstoneThickness dripstoneThickness = SpecialPointedDripstoneBlock.calculateDripstoneThickness((LevelReader)levelAccessor, blockPos, direction2, bl);
        return dripstoneThickness == null ? null : (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction2)).setValue(THICKNESS, (Comparable)dripstoneThickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.getFluidState(blockPos).getType() == Fluids.WATER));
    }

    @NotNull
    public FluidState getFluidState(BlockState state) {
        return (Boolean)state.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(state);
    }

    @NotNull
    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        return Shapes.empty();
    }

    @NotNull
    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        DripstoneThickness dripstoneThickness = (DripstoneThickness)state.getValue(THICKNESS);
        VoxelShape voxelShape = dripstoneThickness == DripstoneThickness.TIP_MERGE ? TIP_MERGE_SHAPE : (dripstoneThickness == DripstoneThickness.TIP ? (state.getValue((Property)TIP_DIRECTION) == Direction.DOWN ? TIP_SHAPE_DOWN : TIP_SHAPE_UP) : (dripstoneThickness == DripstoneThickness.FRUSTUM ? FRUSTUM_SHAPE : (dripstoneThickness == DripstoneThickness.MIDDLE ? MIDDLE_SHAPE : BASE_SHAPE)));
        Vec3 vec3 = state.getOffset(level, pos);
        return voxelShape.move(vec3.x, 0.0, vec3.z);
    }

    public boolean isCollisionShapeFullBlock(BlockState state, BlockGetter level, BlockPos pos) {
        return false;
    }

    public // Could not load outer class - annotation placement on inner may be incorrect
     @NotNull BlockBehaviour.OffsetType getOffsetType() {
        return BlockBehaviour.OffsetType.XZ;
    }

    public float getMaxHorizontalOffset() {
        return 0.125f;
    }

    public void onBrokenAfterFall(Level level, BlockPos pos, FallingBlockEntity fallingBlock) {
        if (!fallingBlock.isSilent()) {
            level.levelEvent(1045, pos, 0);
        }
    }

    @NotNull
    public Predicate<Entity> getHurtsEntitySelector() {
        return EntitySelector.NO_CREATIVE_OR_SPECTATOR.and(EntitySelector.LIVING_ENTITY_STILL_ALIVE);
    }

    private static void spawnFallingStalactite(BlockState state, ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        BlockState blockState = state;
        while (SpecialPointedDripstoneBlock.isStalactite(blockState)) {
            FallingBlockEntity fallingBlockEntity = FallingBlockEntity.fall((Level)level, (BlockPos)mutableBlockPos, (BlockState)blockState);
            if (SpecialPointedDripstoneBlock.isTip(blockState, true)) {
                int i = Math.max(1 + pos.getY() - mutableBlockPos.getY(), 6);
                float f = i;
                fallingBlockEntity.setHurtsEntities(f, 40);
                break;
            }
            mutableBlockPos.move(Direction.DOWN);
            blockState = level.getBlockState((BlockPos)mutableBlockPos);
        }
    }

    @VisibleForTesting
    public static void growStalactiteOrStalagmiteIfPossible(BlockState state, ServerLevel level, BlockPos pos, Random random) {
        BlockState blockState3;
        BlockPos blockPos;
        BlockState blockState2;
        BlockState blockState = level.getBlockState(pos.above(1));
        if (SpecialPointedDripstoneBlock.canGrow(blockState, blockState2 = level.getBlockState(pos.above(2))) && (blockPos = SpecialPointedDripstoneBlock.findTip(state, (LevelAccessor)level, pos, 7, false)) != null && SpecialPointedDripstoneBlock.canDrip(blockState3 = level.getBlockState(blockPos)) && SpecialPointedDripstoneBlock.canTipGrow(blockState3, level, blockPos)) {
            if (random.nextBoolean()) {
                SpecialPointedDripstoneBlock.grow(level, blockPos, Direction.DOWN);
            } else {
                SpecialPointedDripstoneBlock.growStalagmiteBelow(level, blockPos);
            }
        }
    }

    private static void growStalagmiteBelow(ServerLevel level, BlockPos pos) {
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 0; i < 10; ++i) {
            mutableBlockPos.move(Direction.DOWN);
            BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos);
            if (!blockState.getFluidState().isEmpty()) {
                return;
            }
            if (SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, Direction.UP) && SpecialPointedDripstoneBlock.canTipGrow(blockState, level, (BlockPos)mutableBlockPos)) {
                SpecialPointedDripstoneBlock.grow(level, (BlockPos)mutableBlockPos, Direction.UP);
                return;
            }
            if (SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement((LevelReader)level, (BlockPos)mutableBlockPos, Direction.UP) && !level.isWaterAt(mutableBlockPos.below())) {
                SpecialPointedDripstoneBlock.grow(level, mutableBlockPos.below(), Direction.UP);
                return;
            }
            if (SpecialPointedDripstoneBlock.canDripThrough((BlockGetter)level, (BlockPos)mutableBlockPos, blockState)) continue;
            return;
        }
    }

    private static void grow(ServerLevel server, BlockPos pos, Direction direction) {
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = server.getBlockState(blockPos);
        if (SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, direction.getOpposite())) {
            SpecialPointedDripstoneBlock.createMergedTips(blockState, (LevelAccessor)server, blockPos);
        } else if (blockState.isAir() || blockState.is(Blocks.WATER)) {
            SpecialPointedDripstoneBlock.createDripstone((LevelAccessor)server, blockPos, direction, DripstoneThickness.TIP);
        }
    }

    private static void createDripstone(LevelAccessor level, BlockPos pos, Direction direction, DripstoneThickness thickness) {
        Block block = level.getBlockState(pos).getBlock();
        if (block instanceof SpecialPointedDripstoneBlock) {
            SpecialPointedDripstoneBlock block2 = (SpecialPointedDripstoneBlock)block;
            BlockState blockState = (BlockState)((BlockState)((BlockState)block2.defaultBlockState().setValue((Property)TIP_DIRECTION, (Comparable)direction)).setValue(THICKNESS, (Comparable)thickness)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(pos).getType() == Fluids.WATER));
            level.setBlock(pos, blockState, 3);
        }
    }

    private static void createMergedTips(BlockState state, LevelAccessor level, BlockPos pos) {
        BlockPos blockPos2;
        BlockPos blockPos;
        if (state.getValue((Property)TIP_DIRECTION) == Direction.UP) {
            blockPos = pos;
            blockPos2 = pos.above();
        } else {
            blockPos2 = pos;
            blockPos = pos.below();
        }
        SpecialPointedDripstoneBlock.createDripstone(level, blockPos2, Direction.DOWN, DripstoneThickness.TIP_MERGE);
        SpecialPointedDripstoneBlock.createDripstone(level, blockPos, Direction.UP, DripstoneThickness.TIP_MERGE);
    }

    private static void spawnDripParticle(Level level, BlockPos pos, BlockState state, Fluid fluid) {
        Vec3 vec3 = state.getOffset((BlockGetter)level, pos);
        double e = (double)pos.getX() + 0.5 + vec3.x;
        double f = (double)((float)(pos.getY() + 1) - 0.6875f) - 0.0625;
        double g = (double)pos.getZ() + 0.5 + vec3.z;
        Fluid fluid2 = SpecialPointedDripstoneBlock.getDripFluid(level, fluid);
        SimpleParticleType particleOptions = fluid2.is(FluidTags.LAVA) ? ParticleTypes.DRIPPING_DRIPSTONE_LAVA : ParticleTypes.DRIPPING_DRIPSTONE_WATER;
        level.addParticle((ParticleOptions)particleOptions, e, f, g, 0.0, 0.0, 0.0);
    }

    @Nullable
    private static BlockPos findTip(BlockState state, LevelAccessor level, BlockPos pos, int maxIterations, boolean isTipMerge) {
        if (SpecialPointedDripstoneBlock.isTip(state, isTipMerge)) {
            return pos;
        }
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.getBlock() instanceof SpecialPointedDripstoneBlock && blockState.getValue((Property)TIP_DIRECTION) == direction;
        return SpecialPointedDripstoneBlock.findBlockVertical(level, pos, direction.getAxisDirection(), biPredicate, blockState -> SpecialPointedDripstoneBlock.isTip(blockState, isTipMerge), maxIterations).orElse(null);
    }

    @Nullable
    private static Direction calculateTipDirection(LevelReader level, BlockPos pos, Direction dir) {
        Direction direction;
        if (SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir)) {
            direction = dir;
        } else {
            if (!SpecialPointedDripstoneBlock.isValidPointedDripstonePlacement(level, pos, dir.getOpposite())) {
                return null;
            }
            direction = dir.getOpposite();
        }
        return direction;
    }

    private static DripstoneThickness calculateDripstoneThickness(LevelReader level, BlockPos pos, Direction dir, boolean isTipMerge) {
        Direction direction = dir.getOpposite();
        BlockState blockState = level.getBlockState(pos.relative(dir));
        if (SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, direction)) {
            return !isTipMerge && blockState.getValue(THICKNESS) != DripstoneThickness.TIP_MERGE ? DripstoneThickness.TIP : DripstoneThickness.TIP_MERGE;
        }
        if (!SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, dir)) {
            return DripstoneThickness.TIP;
        }
        DripstoneThickness dripstoneThickness = (DripstoneThickness)blockState.getValue(THICKNESS);
        if (dripstoneThickness != DripstoneThickness.TIP && dripstoneThickness != DripstoneThickness.TIP_MERGE) {
            BlockState blockState2 = level.getBlockState(pos.relative(direction));
            return !SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState2, dir) ? DripstoneThickness.BASE : DripstoneThickness.MIDDLE;
        }
        return DripstoneThickness.FRUSTUM;
    }

    public static boolean canDrip(BlockState state) {
        return SpecialPointedDripstoneBlock.isStalactite(state) && state.getValue(THICKNESS) == DripstoneThickness.TIP && (Boolean)state.getValue((Property)WATERLOGGED) == false;
    }

    private static boolean canTipGrow(BlockState state, ServerLevel level, BlockPos pos) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BlockPos blockPos = pos.relative(direction);
        BlockState blockState = level.getBlockState(blockPos);
        if (!blockState.getFluidState().isEmpty()) {
            return false;
        }
        return blockState.isAir() || SpecialPointedDripstoneBlock.isUnmergedTipWithDirection(blockState, direction.getOpposite());
    }

    private static Optional<BlockPos> findRootBlock(Level level, BlockPos pos, BlockState state, int maxIterations) {
        Direction direction = (Direction)state.getValue((Property)TIP_DIRECTION);
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> blockState.getBlock() instanceof SpecialPointedDripstoneBlock && blockState.getValue((Property)TIP_DIRECTION) == direction;
        return SpecialPointedDripstoneBlock.findBlockVertical((LevelAccessor)level, pos, direction.getOpposite().getAxisDirection(), biPredicate, blockState -> !(blockState.getBlock() instanceof SpecialPointedDripstoneBlock), maxIterations);
    }

    private static boolean isValidPointedDripstonePlacement(LevelReader level, BlockPos pos, Direction dir) {
        BlockPos blockPos = pos.relative(dir.getOpposite());
        BlockState blockState = level.getBlockState(blockPos);
        return blockState.isFaceSturdy((BlockGetter)level, blockPos, dir) || SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(blockState, dir);
    }

    private static boolean isTip(BlockState state, boolean isTipMerge) {
        if (!(state.getBlock() instanceof SpecialPointedDripstoneBlock)) {
            return false;
        }
        DripstoneThickness dripstoneThickness = (DripstoneThickness)state.getValue(THICKNESS);
        return dripstoneThickness == DripstoneThickness.TIP || isTipMerge && dripstoneThickness == DripstoneThickness.TIP_MERGE;
    }

    private static boolean isUnmergedTipWithDirection(BlockState state, Direction dir) {
        return SpecialPointedDripstoneBlock.isTip(state, false) && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    private static boolean isStalactite(BlockState state) {
        return SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.DOWN);
    }

    private static boolean isStalagmite(BlockState state) {
        return SpecialPointedDripstoneBlock.isPointedDripstoneWithDirection(state, Direction.UP);
    }

    private static boolean isStalactiteStartPos(BlockState state, LevelReader level, BlockPos pos) {
        return SpecialPointedDripstoneBlock.isStalactite(state) && !(level.getBlockState(pos.above()).getBlock() instanceof SpecialPointedDripstoneBlock);
    }

    public boolean isPathfindable(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }

    private static boolean isPointedDripstoneWithDirection(BlockState state, Direction dir) {
        return state.getBlock() instanceof SpecialPointedDripstoneBlock && state.getValue((Property)TIP_DIRECTION) == dir;
    }

    @Nullable
    private static BlockPos findFillableCauldronBelowStalactiteTip(Level level, BlockPos pos, Fluid fluid) {
        Predicate<BlockState> predicate = blockState -> blockState.getBlock() instanceof CauldronBlock;
        BiPredicate<BlockPos, BlockState> biPredicate = (blockPos, blockState) -> SpecialPointedDripstoneBlock.canDripThrough((BlockGetter)level, blockPos, blockState);
        return SpecialPointedDripstoneBlock.findBlockVertical((LevelAccessor)level, pos, Direction.DOWN.getAxisDirection(), biPredicate, predicate, 11).orElse(null);
    }

    public static Fluid getCauldronFillFluidType(Level level, BlockPos pos) {
        return SpecialPointedDripstoneBlock.getFluidAboveStalactite(level, pos, level.getBlockState(pos)).filter(SpecialPointedDripstoneBlock::canFillCauldron).orElse(Fluids.EMPTY);
    }

    private static Optional<Fluid> getFluidAboveStalactite(Level level, BlockPos pos, BlockState state) {
        return !SpecialPointedDripstoneBlock.isStalactite(state) ? Optional.empty() : SpecialPointedDripstoneBlock.findRootBlock(level, pos, state, 11).map(blockPos -> level.getFluidState(blockPos.above()).getType());
    }

    private static boolean canFillCauldron(Fluid fluid) {
        return fluid == Fluids.LAVA || fluid == Fluids.WATER;
    }

    private static boolean canGrow(BlockState dripstoneState, BlockState state) {
        return dripstoneState.is(Blocks.DRIPSTONE_BLOCK) && state.is(Blocks.WATER) && state.getFluidState().isSource();
    }

    private static Fluid getDripFluid(Level level, Fluid fluid) {
        if (fluid.isSame(Fluids.EMPTY)) {
            return level.dimensionType().ultraWarm() ? Fluids.LAVA : Fluids.WATER;
        }
        return fluid;
    }

    private static Optional<BlockPos> findBlockVertical(LevelAccessor level, BlockPos pos, Direction.AxisDirection axis, BiPredicate<BlockPos, BlockState> positionalStatePredicate, Predicate<BlockState> statePredicate, int maxIterations) {
        Direction direction = Direction.get((Direction.AxisDirection)axis, (Direction.Axis)Direction.Axis.Y);
        BlockPos.MutableBlockPos mutableBlockPos = pos.mutable();
        for (int i = 1; i < maxIterations; ++i) {
            mutableBlockPos.move(direction);
            BlockState blockState = level.getBlockState((BlockPos)mutableBlockPos);
            if (statePredicate.test(blockState)) {
                return Optional.of(mutableBlockPos.immutable());
            }
            if (!level.isOutsideBuildHeight(mutableBlockPos.getY()) && positionalStatePredicate.test((BlockPos)mutableBlockPos, blockState)) continue;
            return Optional.empty();
        }
        return Optional.empty();
    }

    private static boolean canDripThrough(BlockGetter level, BlockPos pos, BlockState state) {
        if (state.isAir()) {
            return true;
        }
        if (state.isSolidRender(level, pos)) {
            return false;
        }
        if (!state.getFluidState().isEmpty()) {
            return false;
        }
        VoxelShape voxelShape = state.getCollisionShape(level, pos);
        return !Shapes.joinIsNotEmpty((VoxelShape)REQUIRED_SPACE_TO_DRIP_THROUGH_NON_SOLID_BLOCK, (VoxelShape)voxelShape, (BooleanOp)BooleanOp.AND);
    }
}

