/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.foundation.advancement;

import com.cake.trading_floor.TradingFloor;
import com.cake.trading_floor.foundation.access.TFAdvancementBuilderAccess;
import com.cake.trading_floor.foundation.advancement.TFAdvancements;
import com.cake.trading_floor.registry.TFTriggers;
import com.simibubi.create.Create;
import com.simibubi.create.foundation.advancement.SimpleCreateTrigger;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public class TFAdvancement {
    static final String LANG = "advancement.trading_floor.";
    private SimpleCreateTrigger builtinTrigger;
    private final Advancement.Builder builder = Advancement.Builder.advancement();
    AdvancementHolder datagenResult;
    @Nullable
    public AdvancementHolder parent;
    @Nullable
    public ResourceLocation parentId;
    protected final String id;
    protected String title;
    protected String description;

    public TFAdvancement(String id, UnaryOperator<Builder> b) {
        this.id = id;
        Builder t = new Builder();
        b.apply(t);
        this.builtinTrigger = TFTriggers.addSimple(id + "_builtin");
        this.builder.addCriterion("0", this.builtinTrigger.createCriterion((CriterionTriggerInstance)this.builtinTrigger.instance()));
        this.builder.display(t.icon, (Component)Component.translatable((String)this.titleKey()), (Component)Component.translatable((String)this.descriptionKey()).withStyle(s -> s.withColor(14393875)), null, t.type.frame, t.type.toast, t.type.announce, t.type.hide);
        TFAdvancements.ENTRIES.add(this);
    }

    private String titleKey() {
        return LANG + this.id;
    }

    private String descriptionKey() {
        return this.titleKey() + ".desc";
    }

    public boolean isAlreadyAwardedTo(Player player) {
        ServerPlayer sp;
        if (!(player instanceof ServerPlayer) || (sp = (ServerPlayer)player).getServer() == null) {
            return true;
        }
        AdvancementHolder advancement = sp.getServer().getAdvancements().get(TradingFloor.asResource(this.id));
        if (advancement == null) {
            return true;
        }
        return sp.getAdvancements().getOrStartProgress(advancement).isDone();
    }

    public void awardTo(Player player) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer sp = (ServerPlayer)player;
        if (this.builtinTrigger == null) {
            throw new UnsupportedOperationException("Advancement " + this.id + " uses external Triggers, it cannot be awarded directly");
        }
        this.builtinTrigger.trigger(sp);
    }

    void save(Consumer<AdvancementHolder> t, HolderLookup.Provider registries) {
        if (this.parent != null) {
            this.builder.parent(this.parent);
        }
        if (this.parentId != null) {
            ((TFAdvancementBuilderAccess)this.builder).create_trading_floor$setParent(this.parentId);
        }
        this.datagenResult = this.builder.save(t, TradingFloor.asResource(this.id).toString());
    }

    void provideLang(BiConsumer<String, String> consumer) {
        consumer.accept(this.titleKey(), this.title);
        consumer.accept(this.descriptionKey(), this.description);
    }

    public class Builder {
        private TaskType type = TaskType.NORMAL;
        private ItemStack icon;

        Builder special(TaskType type) {
            this.type = type;
            return this;
        }

        Builder afterCreateRoot() {
            TFAdvancement.this.parentId = Create.asResource((String)"root");
            return this;
        }

        Builder after(TFAdvancement other) {
            TFAdvancement.this.parentId = TradingFloor.asResource(other.id);
            return this;
        }

        Builder icon(ItemProviderEntry<?, ?> item) {
            return this.icon(item.asStack());
        }

        Builder icon(ItemLike item) {
            return this.icon(new ItemStack(item));
        }

        Builder icon(ItemStack stack) {
            this.icon = stack;
            return this;
        }

        Builder title(String title) {
            TFAdvancement.this.title = title;
            return this;
        }

        Builder description(String description) {
            TFAdvancement.this.description = description;
            return this;
        }
    }

    public static enum TaskType {
        SILENT(AdvancementType.TASK, false, false, false),
        NORMAL(AdvancementType.TASK, true, false, false),
        NOISY(AdvancementType.TASK, true, true, false),
        EXPERT(AdvancementType.GOAL, true, true, false),
        SECRET(AdvancementType.GOAL, true, true, true);

        final AdvancementType frame;
        final boolean toast;
        final boolean announce;
        final boolean hide;

        private TaskType(AdvancementType frame, boolean toast, boolean announce, boolean hide) {
            this.frame = frame;
            this.toast = toast;
            this.announce = announce;
            this.hide = hide;
        }
    }
}

