/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.content.trading_depot;

import com.cake.trading_floor.content.trading_depot.behavior.TradingDepotBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.item.ItemHelper;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;

public class TradingDepotItemHandler
implements IItemHandler {
    TradingDepotBehaviour behaviour;

    public TradingDepotItemHandler(TradingDepotBehaviour behaviour) {
        this.behaviour = behaviour;
    }

    public int getSlots() {
        return 1 + this.behaviour.getResults().size();
    }

    public ItemStack getStackInSlot(int i) {
        return i == 0 ? this.behaviour.getOfferStack() : this.behaviour.getResults().get(i - 1);
    }

    public ItemStack insertItem(int i, ItemStack arg, boolean bl) {
        if (i != 0) {
            return arg;
        }
        if (!this.behaviour.getOfferStack().isEmpty() && !ItemHelper.canItemStackAmountsStack((ItemStack)this.behaviour.getOfferStack(), (ItemStack)arg)) {
            return arg;
        }
        ItemStack existingStack = this.behaviour.getOfferStack();
        int oldCount = existingStack.getCount();
        int newCount = Math.min(arg.getMaxStackSize(), oldCount + arg.getCount());
        int added = newCount - oldCount;
        int remaining = arg.getCount() - added;
        if (!bl) {
            this.behaviour.setOfferStack(arg.copyWithCount(newCount));
            if (newCount != oldCount) {
                this.behaviour.spinOfferOrSomething();
            }
            this.behaviour.blockEntity.sendData();
        }
        return arg.copyWithCount(remaining);
    }

    public ItemStack extractItem(int i, int j, boolean bl) {
        if (i == 0) {
            return ItemStack.EMPTY;
        }
        int listIndex = i - 1;
        if (listIndex >= this.behaviour.getResults().size()) {
            return ItemStack.EMPTY;
        }
        ItemStack currentStack = this.behaviour.getResults().get(listIndex);
        int extractedCount = Math.min(currentStack.getCount(), j);
        ItemStack resultStack = currentStack.copyWithCount(extractedCount);
        ItemStack remainderStack = currentStack.copyWithCount(currentStack.getCount() - extractedCount);
        if (!bl) {
            this.behaviour.getResults().set(listIndex, remainderStack);
            this.behaviour.doPruneEmptyStacksNextTick();
            this.behaviour.blockEntity.sendData();
        }
        return resultStack;
    }

    public int getSlotLimit(int i) {
        return 64;
    }

    public boolean isItemValid(int i, ItemStack arg) {
        return true;
    }

    public ItemStack insertItem(TransportedItemStack transportedItemStack, Direction direction, boolean b) {
        return this.insertItem(0, transportedItemStack.stack, b);
    }

    public TradingDepotBehaviour getBehaviour() {
        return this.behaviour;
    }
}

