/*
 * Decompiled with CFR 0.152.
 */
package com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade;

import com.cake.trading_floor.TradingFloor;
import com.cake.trading_floor.compat.jei.TradingFloorJei;
import com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade.CachedVillagerRenderer;
import com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade.PotentialMerchantOfferInfo;
import com.cake.trading_floor.compat.jei.virtual_recipes.potential_villager_trade.PotentialVillagerTrade;
import com.cake.trading_floor.foundation.TFLang;
import com.cake.trading_floor.registry.TFRegistry;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.compat.jei.EmptyBackground;
import com.simibubi.create.compat.jei.ItemIcon;
import javax.annotation.Nullable;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class PotentialVillagerTradeCategory
implements IRecipeCategory<PotentialVillagerTrade> {
    static final ResourceLocation TEXTURES = TradingFloor.asResource("textures/gui/jei.png");

    public RecipeType<PotentialVillagerTrade> getRecipeType() {
        return TradingFloorJei.POTENTIAL_TRADE_TYPE;
    }

    public Component getTitle() {
        return TFLang.translate("jei.potential_trade_type.title", new Object[0]).component();
    }

    public IDrawable getBackground() {
        return new EmptyBackground(177, 80);
    }

    @Nullable
    public IDrawable getIcon() {
        return new ItemIcon(() -> TFRegistry.TRADING_DEPOT.asStack());
    }

    public void setRecipe(IRecipeLayoutBuilder builder, PotentialVillagerTrade recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 11, 32).addItemStack(recipe.getOffer().getCostA());
        if (recipe.getOffer().getCostB().isEmpty()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 37, 32).addItemStack(recipe.getOffer().getCostB());
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 137, 32).addItemStacks(recipe.getOffer().getPossibleResults());
    }

    public void draw(PotentialVillagerTrade recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        MutableComponent tradeNoteTooltip;
        guiGraphics.blit(TEXTURES, 160, 64, 0, 0, 16, 16);
        if (Minecraft.getInstance().level != null) {
            PoseStack stack = guiGraphics.pose();
            stack.pushPose();
            CachedVillagerRenderer.renderVillagerForRecipe(guiGraphics, 92, 30, 30, (float)mouseX - 45.0f, (float)mouseY, recipe);
            stack.popPose();
        }
        if ((tradeNoteTooltip = PotentialVillagerTradeCategory.getTooltipOfTradeNote(recipe.offer)) != null && mouseX > 132.0 && mouseX < 140.0 && mouseY > 53.0 && mouseY < 61.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)tradeNoteTooltip, (int)mouseX, (int)mouseY);
        }
        if (mouseX > 170.0 && mouseX < 176.0 && mouseY > 65.0 && mouseY < 81.0) {
            guiGraphics.renderTooltip(Minecraft.getInstance().font, (Component)TFLang.translate("jei.missing_disclaimer", new Object[0]).component(), (int)mouseX, (int)mouseY);
        }
        guiGraphics.blit(TEXTURES, 10, 31, 16, 0, 44, 18);
        guiGraphics.blit(TEXTURES, 132, 27, 60, 0, 26, 26);
        Integer tradeNoteUV = PotentialVillagerTradeCategory.getUVXOffsetOfTradeNote(recipe.offer);
        if (tradeNoteUV != null) {
            guiGraphics.blit(TEXTURES, 132, 53, tradeNoteUV.intValue(), 32, 8, 8);
        }
    }

    @Nullable
    public static Integer getUVXOffsetOfTradeNote(PotentialMerchantOfferInfo merchantOfferInfo) {
        if (merchantOfferInfo.isNoteVillagerTypeSpecific()) {
            return 0;
        }
        if (merchantOfferInfo.isNoteRandomisedEmeraldCost()) {
            return 8;
        }
        if (merchantOfferInfo.isNoteRandomisedDyeColor()) {
            return 16;
        }
        if (merchantOfferInfo.isImplyEnchantedVariants()) {
            return 24;
        }
        return null;
    }

    @Nullable
    public static MutableComponent getTooltipOfTradeNote(PotentialMerchantOfferInfo merchantOfferInfo) {
        if (merchantOfferInfo.isNoteVillagerTypeSpecific()) {
            return TFLang.translate("jei.note.type_specific", new Object[0]).component();
        }
        if (merchantOfferInfo.isNoteRandomisedEmeraldCost()) {
            return TFLang.translate("jei.note.randomised_cost", new Object[0]).component();
        }
        if (merchantOfferInfo.isNoteRandomisedDyeColor()) {
            return TFLang.translate("jei.note.randomised_dye", new Object[0]).component();
        }
        if (merchantOfferInfo.isImplyEnchantedVariants()) {
            return TFLang.translate("jei.note.enchanted_variants", new Object[0]).component();
        }
        return null;
    }
}

