/*
 * Decompiled with CFR 0.152.
 */
package com.talhanation.smallships.world.entity.ship.abilities;

import com.talhanation.smallships.config.SmallShipsConfig;
import com.talhanation.smallships.world.entity.ship.Ship;
import com.talhanation.smallships.world.entity.ship.abilities.Ability;
import com.talhanation.smallships.world.sound.ModSoundTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface Sailable
extends Ability {
    default public void tickSailShip() {
        if (this.self().sailStateCooldown > 0) {
            --this.self().sailStateCooldown;
        }
    }

    default public void readSailShipSaveData(CompoundTag tag) {
        CompoundTag compoundTag = tag.getCompound("Sail");
        this.self().setData(Ship.SAIL_STATE, compoundTag.getByte("State"));
        this.self().setData(Ship.SAIL_COLOR, compoundTag.getString("Color"));
    }

    default public void addSailShipSaveData(CompoundTag tag) {
        CompoundTag compoundTag = new CompoundTag();
        compoundTag.putInt("State", (int)this.self().getData(Ship.SAIL_STATE).byteValue());
        compoundTag.putString("Color", this.self().getData(Ship.SAIL_COLOR));
        tag.put("Sail", (Tag)compoundTag);
    }

    default public void controlBoatSailShip() {
        byte sailState = this.getSailState();
        if (sailState != 0) {
            if (this.self().isForward() && sailState != 4 && this.self().sailStateCooldown == 0) {
                sailState = (byte)(sailState + 1);
                if (!this.self().level().isClientSide()) {
                    this.playSailSound(sailState);
                }
                this.self().sailStateCooldown = this.getSailStateCooldown();
                this.setSailState(sailState);
            }
            if (this.self().isBackward() && sailState != 1 && this.self().sailStateCooldown == 0) {
                sailState = (byte)(sailState - 1);
                if (!this.self().level().isClientSide()) {
                    this.playSailSound(sailState);
                }
                this.self().sailStateCooldown = this.getSailStateCooldown();
                this.setSailState(sailState);
            }
        }
    }

    default public boolean interactSail(Player player, InteractionHand interactionHand) {
        ItemStack item = player.getItemInHand(interactionHand);
        Item item2 = item.getItem();
        if (item2 instanceof DyeItem) {
            DyeItem dyeItem = (DyeItem)item2;
            String color = dyeItem.getDyeColor().getName();
            if (color.equals(this.self().getData(Ship.SAIL_COLOR))) {
                return false;
            }
            this.self().setData(Ship.SAIL_COLOR, color);
            if (!player.isCreative()) {
                item.shrink(1);
            }
            this.self().level().playSound(player, this.self().getX(), this.self().getY() + 4.0, this.self().getZ(), SoundEvents.WOOL_HIT, this.self().getSoundSource(), 15.0f, 1.5f);
            return true;
        }
        return false;
    }

    default public void toggleSail() {
        if (!this.self().isShipLeashed()) {
            byte state = this.getSailState();
            state = state > 0 ? (byte)0 : 1;
            this.setSailState(state);
            this.playSailSound(state);
        }
    }

    default public void playSailSound(int state) {
        if (state != 0) {
            this.self().playSound(ModSoundTypes.SAIL_MOVE, 15.0f, Math.max(0.5f, 1.4f - (float)state / 5.0f));
        } else {
            this.self().playSound(ModSoundTypes.SAIL_PULL, 10.0f, 1.0f);
        }
    }

    default public int getSailStateCooldown() {
        return (Integer)SmallShipsConfig.Common.shipGeneralSailCooldown.get();
    }

    default public void setSailState(byte state) {
        this.self().setData(Ship.SAIL_STATE, state);
    }

    default public byte getSailState() {
        return this.self().getData(Ship.SAIL_STATE);
    }
}

