/*
 * Decompiled with CFR 0.152.
 */
package com.hlysine.create_connected.content.kineticbridge;

import com.hlysine.create_connected.CCBlockEntityTypes;
import com.hlysine.create_connected.CCBlocks;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeBlockEntity;
import com.hlysine.create_connected.content.kineticbridge.KineticBridgeDestinationBlock;
import com.simibubi.create.content.kinetics.base.DirectionalKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class KineticBridgeBlock
extends DirectionalKineticBlock
implements IBE<KineticBridgeBlockEntity> {
    public KineticBridgeBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    private BlockState getBaseStateForPlacement(BlockPlaceContext context) {
        Direction preferred = this.getPreferredFacing(context);
        if (preferred == null || context.getPlayer() != null && context.getPlayer().isShiftKeyDown()) {
            Direction nearestLookingDirection = context.getNearestLookingDirection();
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)(context.getPlayer() != null && context.getPlayer().isShiftKeyDown() ? nearestLookingDirection.getOpposite() : nearestLookingDirection));
        }
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)preferred.getOpposite());
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        BlockState stateForPlacement = this.getBaseStateForPlacement(context);
        BlockPos pos = context.getClickedPos();
        Direction facing = (Direction)stateForPlacement.getValue((Property)FACING);
        BlockPos destinationPos = pos.relative(facing);
        BlockState occupiedState = context.getLevel().getBlockState(destinationPos);
        if (!occupiedState.canBeReplaced()) {
            return null;
        }
        return stateForPlacement;
    }

    public Direction getDirectionForPlacement(BlockPlaceContext context) {
        return (Direction)this.getBaseStateForPlacement(context).getValue((Property)FACING);
    }

    public InteractionResult onWrenched(BlockState state, UseOnContext context) {
        return InteractionResult.PASS;
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        super.onPlace(state, level, pos, oldState, isMoving);
        if (!level.getBlockTicks().hasScheduledTick(pos, (Object)this)) {
            level.scheduleTick(pos, (Block)this, 1);
        }
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        BlockState requiredStructure;
        Direction facing = (Direction)pState.getValue((Property)FACING);
        BlockPos destinationPos = pPos.relative(facing);
        BlockState occupiedState = pLevel.getBlockState(destinationPos);
        if (!occupiedState.equals(requiredStructure = (BlockState)CCBlocks.KINETIC_BRIDGE_DESTINATION.getDefaultState().setValue((Property)KineticBridgeDestinationBlock.FACING, (Comparable)facing))) {
            if (!occupiedState.canBeReplaced()) {
                pLevel.destroyBlock(pPos, false);
                return;
            }
            pLevel.setBlockAndUpdate(destinationPos, requiredStructure);
        }
    }

    public BlockEntityType<? extends KineticBridgeBlockEntity> getBlockEntityType() {
        return (BlockEntityType)CCBlockEntityTypes.KINETIC_BRIDGE.get();
    }

    public Class<KineticBridgeBlockEntity> getBlockEntityClass() {
        return KineticBridgeBlockEntity.class;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face == ((Direction)state.getValue((Property)FACING)).getOpposite();
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return ((Direction)state.getValue((Property)FACING)).getAxis();
    }
}

