/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.fallingleaves.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import de.cheaterpaul.fallingleaves.config.LeafSettingsEntry;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleJsonResourceReloadListener;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class LeafSettingLoader
extends SimpleJsonResourceReloadListener {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().create();
    private Map<ResourceLocation, LeafSettingsEntry> treeLeaveSizeValues = new HashMap<ResourceLocation, LeafSettingsEntry>();

    public LeafSettingLoader() {
        super(GSON, "fallingleaves/settings");
    }

    protected void apply(Map<ResourceLocation, JsonElement> values, @NotNull ResourceManager resourceManager, @NotNull ProfilerFiller profiler) {
        this.treeLeaveSizeValues = values.entrySet().stream().mapMulti((entry, consumer) -> {
            DataResult decode = LeafSettingsEntry.CODEC.decode((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)entry.getValue()));
            decode.result().ifPresent(res -> consumer.accept(Pair.of((Object)((ResourceLocation)entry.getKey()), (Object)((LeafSettingsEntry)res.getFirst()))));
            decode.error().ifPresent(error -> LOGGER.error(error.message()));
        }).collect(Collectors.toMap(Pair::getFirst, Pair::getSecond));
    }

    @Nullable
    public LeafSettingsEntry getLeafSetting(ResourceLocation loc) {
        return this.treeLeaveSizeValues.get(loc);
    }

    @Nonnull
    public Collection<LeafSettingsEntry> getALlSettings() {
        return this.treeLeaveSizeValues.values();
    }
}

