/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.fusion.api.provider;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.supermartijn642.fusion.api.util.Pair;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.ModList;
import net.neoforged.neoforgespi.language.IModInfo;

public abstract class FusionBlockModelModifierProvider
implements DataProvider {
    private final Map<ResourceLocation, ModifierBuilder> modifiers = new HashMap<ResourceLocation, ModifierBuilder>();
    private final String modName;
    private final PackOutput output;

    public FusionBlockModelModifierProvider(String modid, PackOutput output) {
        this.modName = ModList.get().getModContainerById(modid).map(ModContainer::getModInfo).map(IModInfo::getDisplayName).orElse(modid);
        this.output = output;
    }

    public final CompletableFuture<?> run(CachedOutput cache) {
        this.generate();
        ArrayList<CompletableFuture> tasks = new ArrayList<CompletableFuture>();
        Path output = this.output.getOutputFolder();
        for (Map.Entry<ResourceLocation, ModifierBuilder> entry : this.modifiers.entrySet()) {
            ResourceLocation location = entry.getKey();
            JsonObject json = this.toJson(entry.getValue());
            String extension = location.getPath().endsWith(".json") ? "" : ".json";
            Path path = Path.of("assets", location.getNamespace(), "fusion/model_modifiers/blocks", location.getPath() + extension);
            tasks.add(DataProvider.saveStable((CachedOutput)cache, (JsonElement)json, (Path)output.resolve(path)));
        }
        return CompletableFuture.allOf((CompletableFuture[])tasks.toArray(CompletableFuture[]::new));
    }

    private JsonObject toJson(ModifierBuilder modifier) {
        JsonObject json = new JsonObject();
        if (modifier.targets.isEmpty()) {
            throw new IllegalArgumentException("Modifier '" + String.valueOf(modifier.location) + "' must have at least one target!");
        }
        JsonArray targets = new JsonArray();
        modifier.targets.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            ResourceLocation block = (ResourceLocation)entry.getKey();
            Map properties = (Map)entry.getValue();
            if (properties.isEmpty()) {
                targets.add(block.toString());
                return;
            }
            JsonObject object = new JsonObject();
            object.addProperty("block", block.toString());
            JsonObject propertiesJson = new JsonObject();
            properties.entrySet().stream().sorted(Comparator.comparing(e -> ((Property)e.getKey()).getName())).forEach(e -> {
                Property property = (Property)e.getKey();
                JsonArray values = new JsonArray();
                ((Set)e.getValue()).stream().map(v -> property.getName((Comparable)v)).sorted().forEach(arg_0 -> ((JsonArray)values).add(arg_0));
                propertiesJson.add(property.getName(), (JsonElement)values);
            });
            object.add("properties", (JsonElement)propertiesJson);
            targets.add((JsonElement)object);
        });
        json.add("targets", (JsonElement)targets);
        if (!modifier.appendModels.isEmpty() || !modifier.paneCullingFix) {
            JsonArray appendModels = new JsonArray();
            modifier.appendModels.stream().map(ResourceLocation::toString).sorted().forEach(arg_0 -> ((JsonArray)appendModels).add(arg_0));
            json.add("append", (JsonElement)appendModels);
        }
        if (modifier.paneCullingFix) {
            json.addProperty("pane_culling_fix", Boolean.valueOf(true));
        }
        return json;
    }

    protected abstract void generate();

    public final ModifierBuilder modifier(ResourceLocation location) {
        return this.modifiers.computeIfAbsent(location, ModifierBuilder::new);
    }

    public String getName() {
        return "Fusion Block Model Modifier Provider: " + this.modName;
    }

    public static final class ModifierBuilder {
        private final ResourceLocation location;
        private final Map<ResourceLocation, Map<Property<?>, Set<Object>>> targets = new HashMap();
        private final Set<ResourceLocation> appendModels = new HashSet<ResourceLocation>();
        private boolean paneCullingFix = false;

        private ModifierBuilder(ResourceLocation location) {
            this.location = location;
        }

        public ModifierBuilder target(ResourceLocation block) {
            if (!this.targets.containsKey(block)) {
                this.targets.put(block, new HashMap());
            }
            return this;
        }

        public ModifierBuilder target(Block block) {
            return this.target(BuiltInRegistries.BLOCK.getKey((Object)block));
        }

        public ModifierBuilder target(Block block, Map<Property<?>, Set<?>> properties) {
            ResourceLocation identifier = BuiltInRegistries.BLOCK.getKey((Object)block);
            Map map = this.targets.computeIfAbsent(identifier, o -> new HashMap());
            for (Map.Entry<Property<?>, Set<?>> entry : properties.entrySet()) {
                Property<?> property = entry.getKey();
                Set values = map.computeIfAbsent(property, o -> new HashSet());
                for (Object value : entry.getValue()) {
                    if (!property.getPossibleValues().contains(value)) {
                        throw new IllegalStateException("Value '" + String.valueOf(value) + "' is not a valid value for property '" + property.getName() + "'!");
                    }
                    values.add(value);
                }
            }
            return this;
        }

        public <T extends Comparable<T>> ModifierBuilder target(Block block, Property<T> property, T ... values) {
            return this.target(block, new HashMap(Map.of(property, new HashSet<T>(Set.of(values)))));
        }

        public ModifierBuilder target(BlockState state) {
            return this.target(state.getBlock(), state.getProperties().stream().sorted(Comparator.comparing(Property::getName)).map(property -> Pair.of(property, Set.of(state.getValue(property)))).collect(Collectors.toMap(Pair::left, Pair::right, (a, b) -> {
                throw new AssertionError();
            }, HashMap::new)));
        }

        public ModifierBuilder appendModel(ResourceLocation location) {
            this.appendModels.add(location);
            return this;
        }

        public ModifierBuilder paneCullingFix(boolean enabled) {
            this.paneCullingFix = enabled;
            return this;
        }
    }
}

