/*
 * Decompiled with CFR 0.152.
 */
package fuzs.easyshulkerboxes.data;

import fuzs.easyshulkerboxes.world.item.container.MapProvider;
import fuzs.iteminteractions.api.v1.DyeBackedColor;
import fuzs.iteminteractions.api.v1.data.AbstractItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.ItemContentsProvider;
import fuzs.iteminteractions.api.v1.provider.impl.BundleProvider;
import fuzs.iteminteractions.api.v1.provider.impl.ContainerProvider;
import fuzs.iteminteractions.api.v1.provider.impl.EnderChestProvider;
import fuzs.puzzleslib.api.data.v2.core.DataProviderContext;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.ShulkerBoxBlock;

public class ModItemContentsProvider
extends AbstractItemContentsProvider {
    public ModItemContentsProvider(DataProviderContext context) {
        super(context);
    }

    public void addItemProviders() {
        this.registerVanillaProviders();
    }

    private void registerVanillaProviders() {
        this.registerShulkerBoxProviders();
        this.add((ItemContentsProvider)new EnderChestProvider(), Items.ENDER_CHEST);
        this.add((ItemContentsProvider)new BundleProvider(1, DyeBackedColor.fromDyeColor((DyeColor)DyeColor.BROWN)), Items.BUNDLE);
        this.add((ItemContentsProvider)new MapProvider(), Items.FILLED_MAP);
        this.add("dispenser", (ItemContentsProvider)new ContainerProvider(3, 3).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.DISPENSER, Items.DROPPER});
        this.add("chest", (ItemContentsProvider)new ContainerProvider(9, 3).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.CHEST, Items.TRAPPED_CHEST, Items.BARREL});
        this.add((ItemContentsProvider)new ContainerProvider(5, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), Items.HOPPER);
        this.add("furnace", (ItemContentsProvider)new ContainerProvider(3, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.FURNACE, Items.BLAST_FURNACE, Items.SMOKER});
        this.add((ItemContentsProvider)new ContainerProvider(5, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), Items.BREWING_STAND);
        this.add("campfire", (ItemContentsProvider)new ContainerProvider(4, 1).interactionPermissions(ContainerProvider.InteractionPermissions.NEVER), new Item[]{Items.CAMPFIRE, Items.SOUL_CAMPFIRE});
    }

    private void registerShulkerBoxProviders() {
        this.add((ItemContentsProvider)new ContainerProvider(9, 3).filterContainerItems(true), Items.SHULKER_BOX);
        for (DyeColor dyeColor : DyeColor.values()) {
            Item item = ShulkerBoxBlock.getBlockByColor((DyeColor)dyeColor).asItem();
            this.add((ItemContentsProvider)new ContainerProvider(9, 3, DyeBackedColor.fromDyeColor((DyeColor)dyeColor)).filterContainerItems(true), item);
        }
    }
}

