/*
 * Decompiled with CFR 0.152.
 */
package com.moepus.createbetterfps.renderer;

import com.moepus.createbetterfps.renderer.BlockVertex;
import com.moepus.createbetterfps.renderer.EntityVertex;
import com.moepus.createbetterfps.renderer.IrisCompat;
import com.moepus.createbetterfps.renderer.IrisEntityVertex;
import com.moepus.createbetterfps.renderer.IrisTerrainVertex;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import dev.engine_room.flywheel.lib.util.ShadersModHelper;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import javax.annotation.ParametersAreNonnullByDefault;
import net.caffeinemc.mods.sodium.api.math.MatrixHelper;
import net.caffeinemc.mods.sodium.api.util.NormI8;
import net.caffeinemc.mods.sodium.api.vertex.buffer.VertexBufferWriter;
import net.createmod.catnip.render.SpriteShiftEntry;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.TemplateMesh;
import net.createmod.catnip.theme.Color;
import net.createmod.ponder.mixin.client.accessor.RenderSystemAccessor;
import net.irisshaders.iris.vertices.NormalHelper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector2f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.lwjgl.system.MemoryStack;
import org.lwjgl.system.MemoryUtil;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class SodiumByteBuffer
implements SuperByteBuffer {
    private static final Long2IntMap WORLD_LIGHT_CACHE = new Long2IntOpenHashMap();
    private final TemplateMesh template;
    private final int[] shadeSwapVertices;
    private final PoseStack transforms = new PoseStack();
    private final boolean invertFakeDiffuseNormal;
    private int vertexColor;
    private boolean disableDiffuse;
    @Nullable
    private SuperByteBuffer.SpriteShiftFunc spriteShiftFunc;
    private boolean hasCustomOverlay;
    private int overlay;
    private boolean hasCustomLight;
    private int packedLight;
    private boolean useLevelLight;
    @Nullable
    private BlockAndTintGetter levelWithLight;
    @Nullable
    private Matrix4f lightTransform;
    private static final Matrix4f modelMat = new Matrix4f();
    private final Matrix3f normalMat = new Matrix3f();
    private final SuperByteBuffer.ShiftOutput shiftOutput = new SuperByteBuffer.ShiftOutput();
    private static final Vector3f lightDir0 = new Vector3f();
    private static final Vector3f lightDir1 = new Vector3f();
    private static final Vector3f float3 = new Vector3f();
    private static final Vector3f pos0 = new Vector3f();
    private static final Vector3f pos1 = new Vector3f();
    private static final Vector3f pos2 = new Vector3f();
    private static final Vector3f pos3 = new Vector3f();
    private static final Vector2f uv0 = new Vector2f();
    private static final Vector2f uv1 = new Vector2f();
    private static final Vector2f uv2 = new Vector2f();
    private static final Vector2f uv3 = new Vector2f();
    private static final int BUFFER_VERTEX_COUNT = 48;
    private static final MemoryStack STACK = MemoryStack.create();
    private static final int BUFFER_SIZE = 48 * IrisEntityVertex.STRIDE;
    private static final long SCRATCH_BUFFER;
    private static long BUFFER_PTR;
    private static int BUFFED_VERTEX;

    public SodiumByteBuffer(TemplateMesh template, int[] shadeSwapVertices, boolean invertFakeDiffuseNormal) {
        this.template = template;
        this.shadeSwapVertices = shadeSwapVertices;
        this.invertFakeDiffuseNormal = invertFakeDiffuseNormal;
        this.reset();
    }

    public SodiumByteBuffer(TemplateMesh template, int[] shadeSwapVertices) {
        this(template, shadeSwapVertices, false);
    }

    public SodiumByteBuffer(TemplateMesh template) {
        this(template, new int[0]);
    }

    public SuperByteBuffer reset() {
        while (!this.transforms.clear()) {
            this.transforms.popPose();
        }
        this.transforms.pushPose();
        this.vertexColor = -1;
        this.disableDiffuse = false;
        this.spriteShiftFunc = null;
        this.hasCustomOverlay = false;
        this.overlay = OverlayTexture.NO_OVERLAY;
        this.hasCustomLight = false;
        this.packedLight = 0;
        this.useLevelLight = false;
        this.levelWithLight = null;
        this.lightTransform = null;
        return this;
    }

    public boolean isEmpty() {
        return this.template.isEmpty();
    }

    public PoseStack getTransforms() {
        return this.transforms;
    }

    public SuperByteBuffer scale(float factorX, float factorY, float factorZ) {
        this.transforms.scale(factorX, factorY, factorZ);
        return this;
    }

    public SuperByteBuffer rotate(Quaternionfc quaternion) {
        PoseStack.Pose last = this.transforms.last();
        last.pose().rotate(quaternion);
        last.normal().rotate(quaternion);
        return this;
    }

    public SuperByteBuffer translate(float x, float y, float z) {
        this.transforms.translate(x, y, z);
        return this;
    }

    public SuperByteBuffer mulPose(Matrix4fc pose) {
        this.transforms.last().pose().mul(pose);
        return this;
    }

    public SuperByteBuffer mulNormal(Matrix3fc normal) {
        this.transforms.last().normal().mul(normal);
        return this;
    }

    public SuperByteBuffer pushPose() {
        this.transforms.pushPose();
        return this;
    }

    public SuperByteBuffer popPose() {
        this.transforms.popPose();
        return this;
    }

    public SuperByteBuffer color(float r, float g, float b, float a) {
        this.color((int)(r * 255.0f), (int)(g * 255.0f), (int)(b * 255.0f), (int)(a * 255.0f));
        return this;
    }

    public SuperByteBuffer color(int r, int g, int b, int a) {
        this.vertexColor = (a & 0xFF) << 24 | (b & 0xFF) << 16 | (g & 0xFF) << 8 | r & 0xFF;
        return this;
    }

    public SuperByteBuffer color(int color) {
        this.vertexColor = 0xFF000000 | (color & 0xFF) << 16 | color & 0xFF00 | (color & 0xFF0000) >>> 16;
        return this;
    }

    public SuperByteBuffer color(Color c) {
        return this.color(c.getRGB());
    }

    public SuperByteBuffer disableDiffuse() {
        this.disableDiffuse = true;
        return this;
    }

    public SuperByteBuffer shiftUV(SpriteShiftEntry entry) {
        this.spriteShiftFunc = (u, v, output) -> output.accept(entry.getTargetU(u), entry.getTargetV(v));
        return this;
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollV) {
        return this.shiftUVScrolling(entry, 0.0f, scrollV);
    }

    public SuperByteBuffer shiftUVScrolling(SpriteShiftEntry entry, float scrollU, float scrollV) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = u - entry.getOriginal().getU0() + entry.getTarget().getU0() + scrollU;
            float targetV = v - entry.getOriginal().getV0() + entry.getTarget().getV0() + scrollV;
            output.accept(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer shiftUVtoSheet(SpriteShiftEntry entry, float uTarget, float vTarget, int sheetSize) {
        this.spriteShiftFunc = (u, v, output) -> {
            float targetU = entry.getTarget().getU(SpriteShiftEntry.getUnInterpolatedU((TextureAtlasSprite)entry.getOriginal(), (float)u) / (float)sheetSize + uTarget);
            float targetV = entry.getTarget().getV(SpriteShiftEntry.getUnInterpolatedV((TextureAtlasSprite)entry.getOriginal(), (float)v) / (float)sheetSize + vTarget);
            output.accept(targetU, targetV);
        };
        return this;
    }

    public SuperByteBuffer overlay(int overlay) {
        this.hasCustomOverlay = true;
        this.overlay = overlay;
        return this;
    }

    public SuperByteBuffer light(int packedLight) {
        this.hasCustomLight = true;
        this.packedLight = packedLight;
        return this;
    }

    public SuperByteBuffer useLevelLight(BlockAndTintGetter level) {
        this.useLevelLight = true;
        this.levelWithLight = level;
        return this;
    }

    public SuperByteBuffer useLevelLight(BlockAndTintGetter level, Matrix4f lightTransform) {
        this.useLevelLight = true;
        this.levelWithLight = level;
        this.lightTransform = lightTransform;
        return this;
    }

    private static float calculateDiffuse(Vector3fc normal, Vector3fc lightDir0, Vector3fc lightDir1) {
        float light0 = Math.max(0.0f, lightDir0.dot(normal));
        float light1 = Math.max(0.0f, lightDir1.dot(normal));
        return Math.min(1.0f, (light0 + light1) * 0.6f + 0.4f);
    }

    public static int getLight(BlockAndTintGetter world, Vector3f lightPos) {
        BlockPos pos = BlockPos.containing((double)lightPos.x(), (double)lightPos.y(), (double)lightPos.z());
        return WORLD_LIGHT_CACHE.computeIfAbsent(pos.asLong(), $ -> LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)pos));
    }

    public int getLight(Vector3f lightPos) {
        return SodiumByteBuffer.getLight(this.levelWithLight, this.lightTransform == null ? lightPos : lightPos.mulPosition((Matrix4fc)this.lightTransform));
    }

    private static boolean isBufferMax() {
        return BUFFED_VERTEX >= 48;
    }

    private static void flush(VertexBufferWriter writer, boolean force, VertexFormat format) {
        if (!force && !SodiumByteBuffer.isBufferMax()) {
            return;
        }
        if (BUFFED_VERTEX == 0) {
            return;
        }
        STACK.push();
        writer.push(STACK, SCRATCH_BUFFER, BUFFED_VERTEX, format);
        STACK.pop();
        BUFFER_PTR = SCRATCH_BUFFER;
        BUFFED_VERTEX = 0;
    }

    private static boolean isPerspectiveProjection() {
        return RenderSystem.getModelViewMatrix().m32() == 0.0f;
    }

    private static int calcColorSodium(int quadColor, int vertexColor, int unshadedDiffuse, boolean applyDiffuse, boolean shaded, float nx, float ny, float nz) {
        int r = (quadColor & 0xFF) * (vertexColor & 0xFF) + 255 >>> 8;
        int g = (quadColor >>> 8 & 0xFF) * (vertexColor >>> 8 & 0xFF) + 255 >>> 8;
        int b = (quadColor >>> 16 & 0xFF) * (vertexColor >>> 16 & 0xFF) + 255 >>> 8;
        int a = (quadColor >>> 24 & 0xFF) * (vertexColor >>> 24 & 0xFF) + 255 >>> 8;
        if (applyDiffuse) {
            float3.set(nx, ny, nz);
            int factor = shaded ? (int)(255.0f * SodiumByteBuffer.calculateDiffuse((Vector3fc)float3, (Vector3fc)lightDir0, (Vector3fc)lightDir1)) : unshadedDiffuse;
            r = r * factor + 255 >>> 8;
            g = g * factor + 255 >>> 8;
            b = b * factor + 255 >>> 8;
        }
        return a << 24 | b << 16 | g << 8 | r;
    }

    private static int calcColorIris(int quadColor, int vertexColor) {
        int r = (quadColor & 0xFF) * (vertexColor & 0xFF) + 255 >>> 8;
        int g = (quadColor >>> 8 & 0xFF) * (vertexColor >>> 8 & 0xFF) + 255 >>> 8;
        int b = (quadColor >>> 16 & 0xFF) * (vertexColor >>> 16 & 0xFF) + 255 >>> 8;
        int a = (quadColor >>> 24 & 0xFF) * (vertexColor >>> 24 & 0xFF) + 255 >>> 8;
        return a << 24 | b << 16 | g << 8 | r;
    }

    private void IrisRenderShadowInto(PoseStack input, VertexBufferWriter writer, VertexFormat format) {
        modelMat.set((Matrix4fc)input.last().pose());
        Matrix4f localTransforms = this.transforms.last().pose();
        modelMat.mul((Matrix4fc)localTransforms);
        this.normalMat.set((Matrix3fc)this.transforms.last().normal());
        Matrix4f sunMat = IrisCompat.getShadowMV();
        boolean isTerrain = format == IrisTerrainVertex.FORMAT;
        int vertexCount = this.template.vertexCount();
        for (int i = 0; i < vertexCount; i += 4) {
            int packedNormal = this.template.normal(i);
            float unpackedX = NormI8.unpackX((int)packedNormal);
            float unpackedY = NormI8.unpackY((int)packedNormal);
            float unpackedZ = NormI8.unpackZ((int)packedNormal);
            float nx = MatrixHelper.transformNormalX((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float ny = MatrixHelper.transformNormalY((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float nz = MatrixHelper.transformNormalZ((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            if (nx * sunMat.m02() + ny * sunMat.m12() + nz * sunMat.m22() >= 0.0f) continue;
            pos0.set(this.template.x(i), this.template.y(i), this.template.z(i)).mulPosition((Matrix4fc)modelMat);
            pos1.set(this.template.x(i + 1), this.template.y(i + 1), this.template.z(i + 1)).mulPosition((Matrix4fc)modelMat);
            pos2.set(this.template.x(i + 2), this.template.y(i + 2), this.template.z(i + 2)).mulPosition((Matrix4fc)modelMat);
            pos3.set(this.template.x(i + 3), this.template.y(i + 3), this.template.z(i + 3)).mulPosition((Matrix4fc)modelMat);
            int normal = NormI8.pack((float)nx, (float)ny, (float)nz);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(this.template.u(i), this.template.v(i), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv0.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 1), this.template.v(i + 1), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv1.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 2), this.template.v(i + 2), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv2.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 3), this.template.v(i + 3), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv3.set(this.shiftOutput.u, this.shiftOutput.v);
            } else {
                uv0.set(this.template.u(i), this.template.v(i));
                uv1.set(this.template.u(i + 1), this.template.v(i + 1));
                uv2.set(this.template.u(i + 2), this.template.v(i + 2));
                uv3.set(this.template.u(i + 3), this.template.v(i + 3));
            }
            if (isTerrain) {
                IrisTerrainVertex.write(BUFFER_PTR, SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z, -1, SodiumByteBuffer.uv0.x, SodiumByteBuffer.uv0.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, SodiumByteBuffer.pos1.x, SodiumByteBuffer.pos1.y, SodiumByteBuffer.pos1.z, -1, SodiumByteBuffer.uv1.x, SodiumByteBuffer.uv1.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, SodiumByteBuffer.pos2.x, SodiumByteBuffer.pos2.y, SodiumByteBuffer.pos2.z, -1, SodiumByteBuffer.uv2.x, SodiumByteBuffer.uv2.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, SodiumByteBuffer.pos3.x, SodiumByteBuffer.pos3.y, SodiumByteBuffer.pos3.z, -1, SodiumByteBuffer.uv3.x, SodiumByteBuffer.uv3.y, 0.5f, 0.5f, 0xF000F0, normal, -1);
                BUFFER_PTR += 52L;
            } else {
                IrisEntityVertex.write(BUFFER_PTR, SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z, -1, SodiumByteBuffer.uv0.x, SodiumByteBuffer.uv0.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                IrisEntityVertex.write(BUFFER_PTR += (long)IrisEntityVertex.STRIDE, SodiumByteBuffer.pos1.x, SodiumByteBuffer.pos1.y, SodiumByteBuffer.pos1.z, -1, SodiumByteBuffer.uv1.x, SodiumByteBuffer.uv1.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                IrisEntityVertex.write(BUFFER_PTR += (long)IrisEntityVertex.STRIDE, SodiumByteBuffer.pos2.x, SodiumByteBuffer.pos2.y, SodiumByteBuffer.pos2.z, -1, SodiumByteBuffer.uv2.x, SodiumByteBuffer.uv2.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                IrisEntityVertex.write(BUFFER_PTR += (long)IrisEntityVertex.STRIDE, SodiumByteBuffer.pos3.x, SodiumByteBuffer.pos3.y, SodiumByteBuffer.pos3.z, -1, SodiumByteBuffer.uv3.x, SodiumByteBuffer.uv3.y, 0.5f, 0.5f, -1, 0xF000F0, normal, -1);
                BUFFER_PTR += (long)IrisEntityVertex.STRIDE;
            }
            BUFFED_VERTEX += 4;
            SodiumByteBuffer.flush(writer, false, format);
        }
        SodiumByteBuffer.flush(writer, true, format);
    }

    private void IrisRenderInto(PoseStack input, VertexBufferWriter writer, VertexFormat format) {
        modelMat.set((Matrix4fc)input.last().pose());
        Matrix4f localTransforms = this.transforms.last().pose();
        modelMat.mul((Matrix4fc)localTransforms);
        this.normalMat.set((Matrix3fc)input.last().normal());
        Matrix3f localNormalTransforms = this.transforms.last().normal();
        this.normalMat.mul((Matrix3fc)localNormalTransforms);
        boolean isTerrain = format == IrisTerrainVertex.FORMAT;
        boolean isPerspectiveProjection = SodiumByteBuffer.isPerspectiveProjection();
        int vertexCount = this.template.vertexCount();
        for (int i = 0; i < vertexCount; i += 4) {
            int packedNormal = this.template.normal(i);
            float unpackedX = NormI8.unpackX((int)packedNormal);
            float unpackedY = NormI8.unpackY((int)packedNormal);
            float unpackedZ = NormI8.unpackZ((int)packedNormal);
            float nx = MatrixHelper.transformNormalX((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float ny = MatrixHelper.transformNormalY((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float nz = MatrixHelper.transformNormalZ((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            pos0.set(this.template.x(i), this.template.y(i), this.template.z(i)).mulPosition((Matrix4fc)modelMat);
            pos2.set(this.template.x(i + 2), this.template.y(i + 2), this.template.z(i + 2)).mulPosition((Matrix4fc)modelMat);
            if (isPerspectiveProjection && nx * (SodiumByteBuffer.pos0.x + SodiumByteBuffer.pos2.x) + ny * (SodiumByteBuffer.pos0.y + SodiumByteBuffer.pos2.y) + nz * (SodiumByteBuffer.pos0.z + SodiumByteBuffer.pos2.z) > 0.0f) continue;
            pos1.set(this.template.x(i + 1), this.template.y(i + 1), this.template.z(i + 1)).mulPosition((Matrix4fc)modelMat);
            pos3.set(this.template.x(i + 3), this.template.y(i + 3), this.template.z(i + 3)).mulPosition((Matrix4fc)modelMat);
            int normal = NormI8.pack((float)nx, (float)ny, (float)nz);
            int tangent = NormalHelper.computeTangent((float)nx, (float)ny, (float)nz, (float)SodiumByteBuffer.pos0.x, (float)SodiumByteBuffer.pos0.y, (float)SodiumByteBuffer.pos0.z, (float)SodiumByteBuffer.uv0.x, (float)SodiumByteBuffer.uv0.y, (float)SodiumByteBuffer.pos1.x, (float)SodiumByteBuffer.pos1.y, (float)SodiumByteBuffer.pos1.z, (float)SodiumByteBuffer.uv1.x, (float)SodiumByteBuffer.uv1.y, (float)SodiumByteBuffer.pos2.x, (float)SodiumByteBuffer.pos2.y, (float)SodiumByteBuffer.pos2.z, (float)SodiumByteBuffer.uv2.x, (float)SodiumByteBuffer.uv2.y);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(this.template.u(i), this.template.v(i), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv0.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 1), this.template.v(i + 1), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv1.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 2), this.template.v(i + 2), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv2.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 3), this.template.v(i + 3), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv3.set(this.shiftOutput.u, this.shiftOutput.v);
            } else {
                uv0.set(this.template.u(i), this.template.v(i));
                uv1.set(this.template.u(i + 1), this.template.v(i + 1));
                uv2.set(this.template.u(i + 2), this.template.v(i + 2));
                uv3.set(this.template.u(i + 3), this.template.v(i + 3));
            }
            float mid_u = (SodiumByteBuffer.uv0.x + SodiumByteBuffer.uv1.x + SodiumByteBuffer.uv2.x + SodiumByteBuffer.uv3.x) / 4.0f;
            float mid_v = (SodiumByteBuffer.uv0.y + SodiumByteBuffer.uv1.y + SodiumByteBuffer.uv2.y + SodiumByteBuffer.uv3.y) / 4.0f;
            int color0 = SodiumByteBuffer.calcColorIris(this.template.color(i), this.vertexColor);
            int color1 = SodiumByteBuffer.calcColorIris(this.template.color(i + 1), this.vertexColor);
            int color2 = SodiumByteBuffer.calcColorIris(this.template.color(i + 2), this.vertexColor);
            int color3 = SodiumByteBuffer.calcColorIris(this.template.color(i + 3), this.vertexColor);
            int light0 = this.template.light(i);
            int light1 = this.template.light(i + 1);
            int light2 = this.template.light(i + 2);
            int light3 = this.template.light(i + 3);
            if (this.hasCustomLight) {
                light0 = SuperByteBuffer.maxLight((int)light0, (int)this.packedLight);
                light1 = SuperByteBuffer.maxLight((int)light1, (int)this.packedLight);
                light2 = SuperByteBuffer.maxLight((int)light2, (int)this.packedLight);
                light3 = SuperByteBuffer.maxLight((int)light3, (int)this.packedLight);
            }
            if (this.useLevelLight) {
                float3.set((this.template.x(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light0 = SuperByteBuffer.maxLight((int)light0, (int)this.getLight(float3));
                float3.set((this.template.x(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light1 = SuperByteBuffer.maxLight((int)light1, (int)this.getLight(float3));
                float3.set((this.template.x(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light2 = SuperByteBuffer.maxLight((int)light2, (int)this.getLight(float3));
                float3.set((this.template.x(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light3 = SuperByteBuffer.maxLight((int)light3, (int)this.getLight(float3));
            }
            if (isTerrain) {
                IrisTerrainVertex.write(BUFFER_PTR, SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z, color0, SodiumByteBuffer.uv0.x, SodiumByteBuffer.uv0.y, mid_u, mid_v, light0, normal, tangent);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, SodiumByteBuffer.pos1.x, SodiumByteBuffer.pos1.y, SodiumByteBuffer.pos1.z, color1, SodiumByteBuffer.uv1.x, SodiumByteBuffer.uv1.y, mid_u, mid_v, light1, normal, tangent);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, SodiumByteBuffer.pos2.x, SodiumByteBuffer.pos2.y, SodiumByteBuffer.pos2.z, color2, SodiumByteBuffer.uv2.x, SodiumByteBuffer.uv2.y, mid_u, mid_v, light2, normal, tangent);
                IrisTerrainVertex.write(BUFFER_PTR += 52L, SodiumByteBuffer.pos3.x, SodiumByteBuffer.pos3.y, SodiumByteBuffer.pos3.z, color3, SodiumByteBuffer.uv3.x, SodiumByteBuffer.uv3.y, mid_u, mid_v, light3, normal, tangent);
                BUFFER_PTR += 52L;
            } else {
                int overlay0;
                int overlay1;
                int overlay2;
                int overlay3;
                if (this.hasCustomOverlay) {
                    overlay2 = overlay3 = this.overlay;
                    overlay1 = overlay3;
                    overlay0 = overlay3;
                } else {
                    overlay0 = this.template.overlay(i);
                    overlay1 = this.template.overlay(i + 1);
                    overlay2 = this.template.overlay(i + 2);
                    overlay3 = this.template.overlay(i + 3);
                }
                IrisEntityVertex.write(BUFFER_PTR, SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z, color0, SodiumByteBuffer.uv0.x, SodiumByteBuffer.uv0.y, mid_u, mid_v, overlay0, light0, normal, tangent);
                IrisEntityVertex.write(BUFFER_PTR += (long)IrisEntityVertex.STRIDE, SodiumByteBuffer.pos1.x, SodiumByteBuffer.pos1.y, SodiumByteBuffer.pos1.z, color1, SodiumByteBuffer.uv1.x, SodiumByteBuffer.uv1.y, mid_u, mid_v, overlay1, light1, normal, tangent);
                IrisEntityVertex.write(BUFFER_PTR += (long)IrisEntityVertex.STRIDE, SodiumByteBuffer.pos2.x, SodiumByteBuffer.pos2.y, SodiumByteBuffer.pos2.z, color2, SodiumByteBuffer.uv2.x, SodiumByteBuffer.uv2.y, mid_u, mid_v, overlay2, light2, normal, tangent);
                IrisEntityVertex.write(BUFFER_PTR += (long)IrisEntityVertex.STRIDE, SodiumByteBuffer.pos3.x, SodiumByteBuffer.pos3.y, SodiumByteBuffer.pos3.z, color3, SodiumByteBuffer.uv3.x, SodiumByteBuffer.uv3.y, mid_u, mid_v, overlay3, light3, normal, tangent);
                BUFFER_PTR += (long)IrisEntityVertex.STRIDE;
            }
            BUFFED_VERTEX += 4;
            SodiumByteBuffer.flush(writer, false, format);
        }
        SodiumByteBuffer.flush(writer, true, format);
    }

    private void SodiumRenderInto(PoseStack input, VertexBufferWriter writer, VertexFormat format) {
        boolean applyDiffuse;
        modelMat.set((Matrix4fc)input.last().pose());
        Matrix4f localTransforms = this.transforms.last().pose();
        modelMat.mul((Matrix4fc)localTransforms);
        this.normalMat.set((Matrix3fc)input.last().normal());
        Matrix3f localNormalTransforms = this.transforms.last().normal();
        this.normalMat.mul((Matrix3fc)localNormalTransforms);
        boolean shaded = true;
        int shadeSwapIndex = 0;
        int nextShadeSwapVertex = shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : Integer.MAX_VALUE;
        int unshadedDiffuse = 255;
        boolean bl = applyDiffuse = !this.disableDiffuse;
        if (applyDiffuse) {
            lightDir0.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[0]).normalize();
            lightDir1.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[1]).normalize();
            if (this.shadeSwapVertices.length > 0) {
                float3.set(0.0f, this.invertFakeDiffuseNormal ? -1.0f : 1.0f, 0.0f);
                unshadedDiffuse = (int)(255.0f * SodiumByteBuffer.calculateDiffuse((Vector3fc)float3, (Vector3fc)lightDir0, (Vector3fc)lightDir1));
            }
        }
        boolean isPerspectiveProjection = SodiumByteBuffer.isPerspectiveProjection();
        int vertexCount = this.template.vertexCount();
        for (int i = 0; i < vertexCount; i += 4) {
            if (i >= nextShadeSwapVertex) {
                shaded = !shaded;
                nextShadeSwapVertex = ++shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : Integer.MAX_VALUE;
            }
            int packedNormal = this.template.normal(i);
            float unpackedX = NormI8.unpackX((int)packedNormal);
            float unpackedY = NormI8.unpackY((int)packedNormal);
            float unpackedZ = NormI8.unpackZ((int)packedNormal);
            float nx = MatrixHelper.transformNormalX((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float ny = MatrixHelper.transformNormalY((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            float nz = MatrixHelper.transformNormalZ((Matrix3f)this.normalMat, (float)unpackedX, (float)unpackedY, (float)unpackedZ);
            pos0.set(this.template.x(i), this.template.y(i), this.template.z(i)).mulPosition((Matrix4fc)modelMat);
            pos2.set(this.template.x(i + 2), this.template.y(i + 2), this.template.z(i + 2)).mulPosition((Matrix4fc)modelMat);
            if (isPerspectiveProjection && nx * (SodiumByteBuffer.pos0.x + SodiumByteBuffer.pos2.x) + ny * (SodiumByteBuffer.pos0.y + SodiumByteBuffer.pos2.y) + nz * (SodiumByteBuffer.pos0.z + SodiumByteBuffer.pos2.z) > 0.0f) continue;
            int normal = NormI8.pack((float)nx, (float)ny, (float)nz);
            pos1.set(this.template.x(i + 1), this.template.y(i + 1), this.template.z(i + 1)).mulPosition((Matrix4fc)modelMat);
            pos3.set(this.template.x(i + 3), this.template.y(i + 3), this.template.z(i + 3)).mulPosition((Matrix4fc)modelMat);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(this.template.u(i), this.template.v(i), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv0.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 1), this.template.v(i + 1), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv1.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 2), this.template.v(i + 2), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv2.set(this.shiftOutput.u, this.shiftOutput.v);
                this.spriteShiftFunc.shift(this.template.u(i + 3), this.template.v(i + 3), (SuperByteBuffer.SpriteShiftFunc.Output)this.shiftOutput);
                uv3.set(this.shiftOutput.u, this.shiftOutput.v);
            } else {
                uv0.set(this.template.u(i), this.template.v(i));
                uv1.set(this.template.u(i + 1), this.template.v(i + 1));
                uv2.set(this.template.u(i + 2), this.template.v(i + 2));
                uv3.set(this.template.u(i + 3), this.template.v(i + 3));
            }
            int color0 = SodiumByteBuffer.calcColorSodium(this.template.color(i), this.vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int color1 = SodiumByteBuffer.calcColorSodium(this.template.color(i + 1), this.vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int color2 = SodiumByteBuffer.calcColorSodium(this.template.color(i + 2), this.vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int color3 = SodiumByteBuffer.calcColorSodium(this.template.color(i + 3), this.vertexColor, unshadedDiffuse, applyDiffuse, shaded, nx, ny, nz);
            int light0 = this.template.light(i);
            int light1 = this.template.light(i + 1);
            int light2 = this.template.light(i + 2);
            int light3 = this.template.light(i + 3);
            if (this.hasCustomLight) {
                light0 = SuperByteBuffer.maxLight((int)light0, (int)this.packedLight);
                light1 = SuperByteBuffer.maxLight((int)light1, (int)this.packedLight);
                light2 = SuperByteBuffer.maxLight((int)light2, (int)this.packedLight);
                light3 = SuperByteBuffer.maxLight((int)light3, (int)this.packedLight);
            }
            if (this.useLevelLight) {
                float3.set((this.template.x(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light0 = SuperByteBuffer.maxLight((int)light0, (int)this.getLight(float3));
                float3.set((this.template.x(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i + 1) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light1 = SuperByteBuffer.maxLight((int)light1, (int)this.getLight(float3));
                float3.set((this.template.x(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i + 2) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light2 = SuperByteBuffer.maxLight((int)light2, (int)this.getLight(float3));
                float3.set((this.template.x(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.y(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f, (this.template.z(i + 3) - 0.5f) * 15.0f / 16.0f + 0.5f).mulPosition((Matrix4fc)localTransforms);
                light3 = SuperByteBuffer.maxLight((int)light3, (int)this.getLight(float3));
            }
            if (format == BlockVertex.FORMAT) {
                BlockVertex.write(BUFFER_PTR, SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z, color0, SodiumByteBuffer.uv0.x, SodiumByteBuffer.uv0.y, light0, normal);
                BlockVertex.write(BUFFER_PTR += 32L, SodiumByteBuffer.pos1.x, SodiumByteBuffer.pos1.y, SodiumByteBuffer.pos1.z, color1, SodiumByteBuffer.uv1.x, SodiumByteBuffer.uv1.y, light1, normal);
                BlockVertex.write(BUFFER_PTR += 32L, SodiumByteBuffer.pos2.x, SodiumByteBuffer.pos2.y, SodiumByteBuffer.pos2.z, color2, SodiumByteBuffer.uv2.x, SodiumByteBuffer.uv2.y, light2, normal);
                BlockVertex.write(BUFFER_PTR += 32L, SodiumByteBuffer.pos3.x, SodiumByteBuffer.pos3.y, SodiumByteBuffer.pos3.z, color3, SodiumByteBuffer.uv3.x, SodiumByteBuffer.uv3.y, light3, normal);
                BUFFER_PTR += 32L;
            } else {
                int overlay0;
                int overlay1;
                int overlay2;
                int overlay3;
                if (this.hasCustomOverlay) {
                    overlay2 = overlay3 = this.overlay;
                    overlay1 = overlay3;
                    overlay0 = overlay3;
                } else {
                    overlay0 = this.template.overlay(i);
                    overlay1 = this.template.overlay(i + 1);
                    overlay2 = this.template.overlay(i + 2);
                    overlay3 = this.template.overlay(i + 3);
                }
                EntityVertex.write(BUFFER_PTR, SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z, color0, SodiumByteBuffer.uv0.x, SodiumByteBuffer.uv0.y, overlay0, light0, normal);
                EntityVertex.write(BUFFER_PTR += 36L, SodiumByteBuffer.pos1.x, SodiumByteBuffer.pos1.y, SodiumByteBuffer.pos1.z, color1, SodiumByteBuffer.uv1.x, SodiumByteBuffer.uv1.y, overlay1, light1, normal);
                EntityVertex.write(BUFFER_PTR += 36L, SodiumByteBuffer.pos2.x, SodiumByteBuffer.pos2.y, SodiumByteBuffer.pos2.z, color2, SodiumByteBuffer.uv2.x, SodiumByteBuffer.uv2.y, overlay2, light2, normal);
                EntityVertex.write(BUFFER_PTR += 36L, SodiumByteBuffer.pos3.x, SodiumByteBuffer.pos3.y, SodiumByteBuffer.pos3.z, color3, SodiumByteBuffer.uv3.x, SodiumByteBuffer.uv3.y, overlay3, light3, normal);
                BUFFER_PTR += 36L;
            }
            BUFFED_VERTEX += 4;
            SodiumByteBuffer.flush(writer, false, format);
        }
        SodiumByteBuffer.flush(writer, true, format);
    }

    public void defaultRenderInto(PoseStack input, VertexConsumer builder) {
        Matrix4f modelMat = SodiumByteBuffer.modelMat.set((Matrix4fc)input.last().pose());
        Matrix4f localTransforms = this.transforms.last().pose();
        modelMat.mul((Matrix4fc)localTransforms);
        Matrix3f normalMat = this.normalMat.set((Matrix3fc)input.last().normal());
        Matrix3f localNormalTransforms = this.transforms.last().normal();
        normalMat.mul((Matrix3fc)localNormalTransforms);
        SuperByteBuffer.ShiftOutput shiftOutput = this.shiftOutput;
        boolean applyDiffuse = !this.disableDiffuse && !ShadersModHelper.isShaderPackInUse();
        boolean shaded = true;
        int shadeSwapIndex = 0;
        int nextShadeSwapVertex = shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : -1;
        int unshadedDiffuse = 255;
        if (applyDiffuse) {
            lightDir0.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[0]).normalize();
            lightDir1.set((Vector3fc)RenderSystemAccessor.catnip$getShaderLightDirections()[1]).normalize();
            if (this.shadeSwapVertices.length > 0) {
                float3.set(0.0f, this.invertFakeDiffuseNormal ? -1.0f : 1.0f, 0.0f);
                unshadedDiffuse = (int)(255.0f * SodiumByteBuffer.calculateDiffuse((Vector3fc)float3, (Vector3fc)lightDir0, (Vector3fc)lightDir1));
            }
        }
        int vertexCount = this.template.vertexCount();
        for (int i = 0; i < vertexCount; ++i) {
            if (i == nextShadeSwapVertex) {
                shaded = !shaded;
                nextShadeSwapVertex = ++shadeSwapIndex < this.shadeSwapVertices.length ? this.shadeSwapVertices[shadeSwapIndex] : -1;
            }
            float x = this.template.x(i);
            float y = this.template.y(i);
            float z = this.template.z(i);
            pos0.set(x, y, z);
            pos0.mulPosition((Matrix4fc)modelMat);
            int light = this.template.light(i);
            if (this.hasCustomLight) {
                light = SuperByteBuffer.maxLight((int)light, (int)this.packedLight);
            }
            if (this.useLevelLight) {
                float3.set((x - 0.5f) * 15.0f / 16.0f + 0.5f, (y - 0.5f) * 15.0f / 16.0f + 0.5f, (z - 0.5f) * 15.0f / 16.0f + 0.5f);
                light = SuperByteBuffer.maxLight((int)light, (int)this.getLight(float3));
            }
            int packedNormal = this.template.normal(i);
            float normalX = (float)((byte)(packedNormal & 0xFF)) / 127.0f;
            float normalY = (float)((byte)(packedNormal >>> 8 & 0xFF)) / 127.0f;
            float normalZ = (float)((byte)(packedNormal >>> 16 & 0xFF)) / 127.0f;
            float3.set(normalX, normalY, normalZ);
            float3.mul((Matrix3fc)normalMat);
            int quadColor = this.template.color(i);
            int r = (quadColor & 0xFF) * (this.vertexColor & 0xFF) + 255 >>> 8;
            int g = (quadColor >>> 8 & 0xFF) * (this.vertexColor >>> 8 & 0xFF) + 255 >>> 8;
            int b = (quadColor >>> 16 & 0xFF) * (this.vertexColor >>> 16 & 0xFF) + 255 >>> 8;
            int a = (quadColor >>> 24 & 0xFF) * (this.vertexColor >>> 24 & 0xFF) + 255 >>> 8;
            if (applyDiffuse) {
                int factor = shaded ? (int)(255.0f * SodiumByteBuffer.calculateDiffuse((Vector3fc)float3, (Vector3fc)lightDir0, (Vector3fc)lightDir1)) : unshadedDiffuse;
                r = r * factor + 255 >>> 8;
                g = g * factor + 255 >>> 8;
                b = b * factor + 255 >>> 8;
            }
            int color = a << 24 | r << 16 | g << 8 | b;
            float u = this.template.u(i);
            float v = this.template.v(i);
            if (this.spriteShiftFunc != null) {
                this.spriteShiftFunc.shift(u, v, (SuperByteBuffer.SpriteShiftFunc.Output)shiftOutput);
                u = shiftOutput.u;
                v = shiftOutput.v;
            }
            int overlay = this.hasCustomOverlay ? this.overlay : this.template.overlay(i);
            builder.addVertex(SodiumByteBuffer.pos0.x, SodiumByteBuffer.pos0.y, SodiumByteBuffer.pos0.z).setColor(color).setUv(u, v).setOverlay(overlay).setLight(light).setNormal(SodiumByteBuffer.float3.x, SodiumByteBuffer.float3.y, SodiumByteBuffer.float3.z);
        }
    }

    public boolean renderIntoSodium(PoseStack input, VertexConsumer builder) {
        VertexBufferWriter writer = VertexBufferWriter.tryOf((VertexConsumer)builder);
        if (writer == null) {
            return false;
        }
        if (builder instanceof BufferBuilder) {
            BufferBuilder bb = (BufferBuilder)builder;
            if (bb.format == IrisTerrainVertex.FORMAT || bb.format == IrisEntityVertex.FORMAT) {
                if (!IrisCompat.isShadowPass()) {
                    this.IrisRenderInto(input, writer, bb.format);
                } else {
                    this.IrisRenderShadowInto(input, writer, bb.format);
                }
                return true;
            }
            if (bb.format == BlockVertex.FORMAT || bb.format == EntityVertex.FORMAT) {
                this.SodiumRenderInto(input, writer, bb.format);
                return true;
            }
        }
        return false;
    }

    public void renderInto(PoseStack input, VertexConsumer builder) {
        if (!this.renderIntoSodium(input, builder)) {
            this.defaultRenderInto(input, builder);
        }
        this.reset();
    }

    static {
        BUFFER_PTR = SCRATCH_BUFFER = MemoryUtil.nmemAlignedAlloc((long)64L, (long)BUFFER_SIZE);
        BUFFED_VERTEX = 0;
    }
}

