/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.fml.loading.FMLEnvironment;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import org.jetbrains.annotations.NotNull;

public class BlockSet
extends HashMap<BlockPos, BlockEntry>
implements Iterable<BlockEntry> {
    public static boolean logging = true;
    public BlockPos firstPos;
    public BlockPos lastPos;
    public boolean skipFirst;

    public BlockSet() {
    }

    public BlockSet(BlockSet blockSet) {
        super(blockSet);
        this.firstPos = blockSet.firstPos;
        this.lastPos = blockSet.lastPos;
        this.skipFirst = blockSet.skipFirst;
    }

    public BlockSet(List<BlockEntry> blockEntries, BlockPos firstPos, BlockPos lastPos, boolean skipFirst) {
        for (BlockEntry blockEntry : blockEntries) {
            this.add(blockEntry);
        }
        this.firstPos = firstPos;
        this.lastPos = lastPos;
        this.skipFirst = skipFirst;
    }

    public void setStartPos(BlockEntry startPos) {
        this.clear();
        this.add(startPos);
        this.firstPos = startPos.blockPos;
        this.lastPos = startPos.blockPos;
    }

    public void add(BlockEntry blockEntry) {
        if (!this.containsKey(blockEntry.blockPos)) {
            if (FMLEnvironment.dist.isClient()) {
                if (!ClientSide.isFull(this)) {
                    this.put(blockEntry.blockPos, blockEntry);
                }
            } else {
                this.put(blockEntry.blockPos, blockEntry);
            }
        } else if (logging) {
            EffortlessBuilding.log("BlockSet already contains block at " + String.valueOf(blockEntry.blockPos));
        }
    }

    public HashSet<BlockPos> getCoordinates() {
        return new HashSet<BlockPos>(this.keySet());
    }

    public BlockEntry getFirstBlockEntry() {
        return (BlockEntry)this.get(this.firstPos);
    }

    public BlockEntry getLastBlockEntry() {
        return (BlockEntry)this.get(this.lastPos);
    }

    @Override
    @NotNull
    public Iterator<BlockEntry> iterator() {
        return this.values().iterator();
    }

    public static void encode(FriendlyByteBuf buf, BlockSet block) {
        buf.writeCollection(block.values().stream().filter(be -> !be.invalid).toList(), BlockEntry::encode);
        buf.writeBlockPos(block.firstPos);
        buf.writeBlockPos(block.lastPos);
        buf.writeBoolean(block.skipFirst);
    }

    public static BlockSet decode(FriendlyByteBuf buf) {
        return new BlockSet(buf.readList(BlockEntry::decode), buf.readBlockPos(), buf.readBlockPos(), buf.readBoolean());
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ClientSide {
        public static boolean isFull(BlockSet blockSet) {
            int limit = AttachmentHandler.getMaxBlocksPlacedAtOnce((Player)Minecraft.getInstance().player, false);
            if (blockSet.size() >= limit) {
                if (logging) {
                    EffortlessBuilding.log("BlockSet limit reached, not adding block.");
                }
                return true;
            }
            return false;
        }
    }
}

