/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.utilities;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.utilities.BlockUtilities;
import nl.requios.effortlessbuilding.utilities.MyPlaceContext;

public class BlockEntry {
    public final BlockPos blockPos;
    public boolean mirrorX;
    public boolean mirrorY;
    public boolean mirrorZ;
    public Rotation rotation = Rotation.NONE;
    public BlockState existingBlockState;
    public BlockState newBlockState;
    public Item item;
    public boolean invalid = false;

    public BlockEntry(BlockPos blockPos) {
        this.blockPos = blockPos;
    }

    public BlockEntry(BlockPos blockPos, BlockState blockState, Item item) {
        this.blockPos = blockPos;
        this.newBlockState = blockState;
        this.item = item;
    }

    public void copyRotationSettingsFrom(BlockEntry blockEntry) {
        this.mirrorX = blockEntry.mirrorX;
        this.mirrorY = blockEntry.mirrorY;
        this.mirrorZ = blockEntry.mirrorZ;
        this.rotation = blockEntry.rotation;
    }

    public void setItemAndFindNewBlockState(ItemStack itemStack, Level world, Direction originalDirection, Direction clickedFace, Vec3 relativeHitVec) {
        this.item = itemStack.getItem();
        Block block = Block.byItem((Item)this.item);
        Direction direction = originalDirection;
        if (this.rotation != null) {
            direction = this.rotation.rotate(direction);
        }
        direction = this.applyMirror(direction);
        MyPlaceContext blockPlaceContext = new MyPlaceContext(world, this.blockPos, direction, itemStack, clickedFace, relativeHitVec);
        this.newBlockState = block.getStateForPlacement((BlockPlaceContext)blockPlaceContext);
        this.applyMirrorToBlockState();
    }

    private Direction applyMirror(Direction direction) {
        if (this.mirrorX && direction.getAxis() == Direction.Axis.X) {
            direction = direction.getOpposite();
        }
        if (this.mirrorY && direction.getAxis() == Direction.Axis.Y) {
            direction = direction.getOpposite();
        }
        if (this.mirrorZ && direction.getAxis() == Direction.Axis.Z) {
            direction = direction.getOpposite();
        }
        return direction;
    }

    private void applyMirrorToBlockState() {
        if (this.mirrorY) {
            this.newBlockState = BlockUtilities.getVerticalMirror(this.newBlockState);
        }
    }

    public static void encode(FriendlyByteBuf buf, BlockEntry block) {
        buf.writeBlockPos(block.blockPos);
        buf.writeNullable((Object)block.newBlockState, (buffer, blockState) -> buffer.writeNbt((Tag)NbtUtils.writeBlockState((BlockState)blockState)));
        buf.writeInt(Item.getId((Item)block.item));
    }

    public static BlockEntry decode(FriendlyByteBuf buf) {
        BlockEntry block = new BlockEntry(buf.readBlockPos());
        block.newBlockState = (BlockState)buf.readNullable(buffer -> {
            CompoundTag nbt = buf.readNbt();
            if (nbt == null) {
                return null;
            }
            return NbtUtils.readBlockState((HolderGetter)BuiltInRegistries.BLOCK.asLookup(), (CompoundTag)nbt);
        });
        block.item = Item.byId((int)buf.readInt());
        return block;
    }
}

