/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.systems;

import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.systems.BuildSettings;
import nl.requios.effortlessbuilding.systems.BuilderChain;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;
import nl.requios.effortlessbuilding.utilities.PlaceChecker;

@OnlyIn(value=Dist.CLIENT)
public class BuilderFilter {
    public void filterOnCoordinates(BlockSet blocks, Player player) {
        Level world = player.level();
        Iterator iter = blocks.entrySet().iterator();
        while (iter.hasNext()) {
            BlockPos pos = ((BlockEntry)iter.next().getValue()).blockPos;
            boolean remove = false;
            if (!world.isLoaded(pos)) {
                remove = true;
            }
            if (!world.getWorldBorder().isWithinBounds(pos)) {
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    public void filterOnExistingBlockStates(BlockSet blocks, Player player) {
        BuildSettings buildSettings = EffortlessBuildingClient.BUILD_SETTINGS;
        BuilderChain.BuildingState buildingState = EffortlessBuildingClient.BUILDER_CHAIN.getPretendBuildingState();
        boolean placing = buildingState == BuilderChain.BuildingState.PLACING;
        Iterator iter = blocks.entrySet().iterator();
        while (iter.hasNext()) {
            ItemStack offhandItem;
            BlockEntry blockEntry = (BlockEntry)iter.next().getValue();
            BlockState blockState = blockEntry.existingBlockState;
            boolean remove = false;
            if (buildSettings.shouldProtectTileEntities() && blockState.hasBlockEntity()) {
                remove = true;
            }
            if (placing && !buildSettings.shouldReplaceFiltered()) {
                if (!buildSettings.shouldReplaceAir() && blockState.isAir()) {
                    remove = true;
                }
                boolean isReplaceable = blockState.canBeReplaced();
                if (!buildSettings.shouldReplaceBlocks() && !isReplaceable) {
                    remove = true;
                }
            }
            if (buildSettings.shouldReplaceFiltered() && !CompatHelper.containsBlock(offhandItem = player.getOffhandItem(), blockState.getBlock())) {
                remove = true;
            }
            if (!remove) continue;
            iter.remove();
        }
    }

    public boolean filterOnNewBlockState(BlockEntry blockEntry, Player player) {
        BuilderChain.BuildingState buildingState = EffortlessBuildingClient.BUILDER_CHAIN.getPretendBuildingState();
        boolean placing = buildingState == BuilderChain.BuildingState.PLACING;
        boolean remove = false;
        if (placing && !PlaceChecker.shouldPlaceBlock(player.level(), blockEntry)) {
            remove = true;
        }
        return remove;
    }
}

