/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.awt.Color;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.buildmodifier.Mirror;
import nl.requios.effortlessbuilding.buildmodifier.RadialMirror;
import nl.requios.effortlessbuilding.render.RenderHandler;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class ModifierRenderer {
    protected static final Color colorX = new Color(255, 72, 52);
    protected static final Color colorY = new Color(67, 204, 51);
    protected static final Color colorZ = new Color(52, 247, 255);
    protected static final Color colorRadial = new Color(52, 247, 255);
    protected static final int lineAlpha = 200;
    protected static final int planeAlpha = 50;
    protected static final Vec3 epsilon = new Vec3(0.001, 0.001, 0.001);

    public static void render(PoseStack ms, MultiBufferSource.BufferSource buffer) {
        List<BaseModifier> modifierSettingsList = EffortlessBuildingClient.BUILD_MODIFIERS.getModifierSettingsList();
        for (BaseModifier modifierSettings : modifierSettingsList) {
            if (modifierSettings == null) continue;
            if (modifierSettings instanceof Mirror) {
                ModifierRenderer.renderMirror(ms, buffer, (Mirror)modifierSettings);
                continue;
            }
            if (!(modifierSettings instanceof RadialMirror)) continue;
            ModifierRenderer.renderRadialMirror(ms, buffer, (RadialMirror)modifierSettings);
        }
    }

    private static void renderMirror(PoseStack ms, MultiBufferSource.BufferSource buffer, Mirror m) {
        if (m != null && m.enabled && (m.mirrorX || m.mirrorY || m.mirrorZ)) {
            Vec3 posB;
            Vec3 posA;
            Vec3 pos = m.position.add(epsilon);
            int radius = m.radius;
            if (m.mirrorX) {
                posA = new Vec3(pos.x, pos.y - (double)radius, pos.z - (double)radius);
                posB = new Vec3(pos.x, pos.y + (double)radius, pos.z + (double)radius);
                ModifierRenderer.drawMirrorPlane(ms, buffer, posA, posB, colorX, m.drawLines, m.drawPlanes, true);
            }
            if (m.mirrorY) {
                posA = new Vec3(pos.x - (double)radius, pos.y, pos.z - (double)radius);
                posB = new Vec3(pos.x + (double)radius, pos.y, pos.z + (double)radius);
                ModifierRenderer.drawMirrorPlaneY(ms, buffer, posA, posB, colorY, m.drawLines, m.drawPlanes);
            }
            if (m.mirrorZ) {
                posA = new Vec3(pos.x - (double)radius, pos.y - (double)radius, pos.z);
                posB = new Vec3(pos.x + (double)radius, pos.y + (double)radius, pos.z);
                ModifierRenderer.drawMirrorPlane(ms, buffer, posA, posB, colorZ, m.drawLines, m.drawPlanes, true);
            }
            if (m.drawLines && (m.mirrorX && m.mirrorY || m.mirrorX && m.mirrorZ || m.mirrorY && m.mirrorZ)) {
                ModifierRenderer.drawMirrorLines(ms, buffer, m);
            }
        }
    }

    private static void renderRadialMirror(PoseStack ms, MultiBufferSource.BufferSource buffer, RadialMirror r) {
        if (r != null && r.enabled) {
            Vec3 pos = r.position.add(epsilon);
            int radius = r.radius;
            float angle = (float)Math.PI * 2 / (float)r.slices;
            Vec3 relStartVec = new Vec3((double)radius, 0.0, 0.0);
            if (r.slices % 4 == 2) {
                relStartVec = relStartVec.yRot(angle / 2.0f);
            }
            for (int i = 0; i < r.slices; ++i) {
                Vec3 relNewVec = relStartVec.yRot(angle * (float)i);
                Vec3 newVec = pos.add(relNewVec);
                Vec3 posA = new Vec3(pos.x, pos.y - (double)radius, pos.z);
                Vec3 posB = new Vec3(newVec.x, pos.y + (double)radius, newVec.z);
                ModifierRenderer.drawMirrorPlane(ms, buffer, posA, posB, colorRadial, r.drawLines, r.drawPlanes, false);
            }
        }
    }

    protected static void drawMirrorPlane(PoseStack ms, MultiBufferSource.BufferSource renderTypeBuffer, Vec3 posA, Vec3 posB, Color c, boolean drawLines, boolean drawPlanes, boolean drawVerticalLines) {
        VertexConsumer buffer;
        Matrix4f matrixPos = ms.last().pose();
        if (drawPlanes) {
            buffer = RenderHandler.beginPlanes(renderTypeBuffer);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posA.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posB.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posB.x, (float)posA.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posB.x, (float)posB.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posA.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posB.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            RenderHandler.endPlanes(renderTypeBuffer);
        }
        if (drawLines) {
            buffer = RenderHandler.beginLines(renderTypeBuffer);
            Vec3 middle = posA.add(posB).scale(0.5);
            buffer.addVertex(matrixPos, (float)posA.x, (float)middle.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            buffer.addVertex(matrixPos, (float)posB.x, (float)middle.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            if (drawVerticalLines) {
                buffer.addVertex(matrixPos, (float)middle.x, (float)posA.y, (float)middle.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
                buffer.addVertex(matrixPos, (float)middle.x, (float)posB.y, (float)middle.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            }
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    protected static void drawMirrorPlaneY(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, Vec3 posA, Vec3 posB, Color c, boolean drawLines, boolean drawPlanes) {
        VertexConsumer buffer;
        Matrix4f matrixPos = matrixStack.last().pose();
        if (drawPlanes) {
            buffer = RenderHandler.beginPlanes(renderTypeBuffer);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posA.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posA.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posB.x, (float)posA.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posB.x, (float)posA.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posA.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            buffer.addVertex(matrixPos, (float)posA.x, (float)posA.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 50);
            RenderHandler.endPlanes(renderTypeBuffer);
        }
        if (drawLines) {
            buffer = RenderHandler.beginLines(renderTypeBuffer);
            Vec3 middle = posA.add(posB).scale(0.5);
            buffer.addVertex(matrixPos, (float)middle.x, (float)middle.y, (float)posA.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            buffer.addVertex(matrixPos, (float)middle.x, (float)middle.y, (float)posB.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            buffer.addVertex(matrixPos, (float)posA.x, (float)middle.y, (float)middle.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            buffer.addVertex(matrixPos, (float)posB.x, (float)middle.y, (float)middle.z).setColor(c.getRed(), c.getGreen(), c.getBlue(), 200);
            RenderHandler.endLines(renderTypeBuffer);
        }
    }

    protected static void drawMirrorLines(PoseStack matrixStack, MultiBufferSource.BufferSource renderTypeBuffer, Mirror m) {
        VertexConsumer buffer = RenderHandler.beginLines(renderTypeBuffer);
        Matrix4f matrixPos = matrixStack.last().pose();
        Vec3 pos = m.position.add(epsilon);
        buffer.addVertex(matrixPos, (float)pos.x - (float)m.radius, (float)pos.y, (float)pos.z).setColor(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200);
        buffer.addVertex(matrixPos, (float)pos.x + (float)m.radius, (float)pos.y, (float)pos.z).setColor(colorX.getRed(), colorX.getGreen(), colorX.getBlue(), 200);
        buffer.addVertex(matrixPos, (float)pos.x, (float)pos.y - (float)m.radius, (float)pos.z).setColor(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200);
        buffer.addVertex(matrixPos, (float)pos.x, (float)pos.y + (float)m.radius, (float)pos.z).setColor(colorY.getRed(), colorY.getGreen(), colorY.getBlue(), 200);
        buffer.addVertex(matrixPos, (float)pos.x, (float)pos.y, (float)pos.z - (float)m.radius).setColor(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200);
        buffer.addVertex(matrixPos, (float)pos.x, (float)pos.y, (float)pos.z + (float)m.radius).setColor(colorZ.getRed(), colorZ.getGreen(), colorZ.getBlue(), 200);
        RenderHandler.endLines(renderTypeBuffer);
    }
}

