/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.network.message;

import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import nl.requios.effortlessbuilding.EffortlessBuilding;
import nl.requios.effortlessbuilding.attachment.PowerLevel;

public record PowerLevelPacket(int powerLevel) implements CustomPacketPayload
{
    public static final StreamCodec<FriendlyByteBuf, PowerLevelPacket> CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, PowerLevelPacket::powerLevel, PowerLevelPacket::new);
    public static final CustomPacketPayload.Type<PowerLevelPacket> ID = new CustomPacketPayload.Type(EffortlessBuilding.asResource("power_level"));

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }

    public static class Handler {
        public static void handle(PowerLevelPacket packet, IPayloadContext context) {
            context.enqueueWork(() -> {
                if (context.player() != null) {
                    Player player = context.player();
                    PowerLevel currentLevel = (PowerLevel)player.getData(EffortlessBuilding.POWER_LEVEL.get());
                    currentLevel.setPowerLevel(packet.powerLevel);
                    player.setData(EffortlessBuilding.POWER_LEVEL.get(), (Object)currentLevel);
                }
            }).exceptionally(e -> {
                context.disconnect((Component)Component.translatable((String)"effortlessbuilding.networking.power_level.failed", (Object[])new Object[]{e.getMessage()}));
                return null;
            });
        }
    }
}

