/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.gui.elements;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
@ParametersAreNonnullByDefault
public class GuiIconButton
extends Button {
    private final ResourceLocation resourceLocation;
    private final int iconX;
    private final int iconY;
    private final int iconWidth;
    private final int iconHeight;
    private final int iconAltX;
    private final int iconAltY;
    List<Component> tooltip = new ArrayList<Component>();
    private boolean useAltIcon = false;

    public GuiIconButton(int x, int y, int iconX, int iconY, ResourceLocation resourceLocation, Button.OnPress onPress) {
        this(x, y, 20, 20, iconX, iconY, 20, 20, 20, 0, resourceLocation, onPress);
    }

    public GuiIconButton(int x, int y, int width, int height, int iconX, int iconY, int iconWidth, int iconHeight, int iconAltX, int iconAltY, ResourceLocation resourceLocation, Button.OnPress onPress) {
        super(x, y, width, height, (Component)Component.empty(), onPress, DEFAULT_NARRATION);
        this.iconX = iconX;
        this.iconY = iconY;
        this.iconWidth = iconWidth;
        this.iconHeight = iconHeight;
        this.iconAltX = iconAltX;
        this.iconAltY = iconAltY;
        this.resourceLocation = resourceLocation;
    }

    public void setTooltip(Component tooltip) {
        this.setTooltip(Collections.singletonList(tooltip));
    }

    public void setTooltip(List<Component> tooltip) {
        this.tooltip = tooltip;
    }

    public void setUseAlternateIcon(boolean useAlternateIcon) {
        this.useAltIcon = useAlternateIcon;
    }

    public void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        int currentIconX = this.iconX;
        int currentIconY = this.iconY;
        if (this.useAltIcon) {
            currentIconX += this.iconAltX;
            currentIconY += this.iconAltY;
        }
        guiGraphics.blit(this.resourceLocation, this.getX(), this.getY(), currentIconX, currentIconY, this.iconWidth, this.iconHeight);
    }

    public void drawTooltip(GuiGraphics guiGraphics, Screen screen, int mouseX, int mouseY) {
        boolean flag;
        boolean bl = flag = mouseX >= this.getX() && mouseX < this.getX() + this.width && mouseY >= this.getY() && mouseY < this.getY() + this.height;
        if (flag) {
            guiGraphics.renderComponentTooltip(screen.getMinecraft().font, this.tooltip, mouseX - 10, mouseY + 25);
        }
    }
}

