/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.create.foundation.gui.widget;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import nl.requios.effortlessbuilding.create.AllKeys;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.AbstractSimiWidget;
import nl.requios.effortlessbuilding.create.foundation.gui.widget.Label;
import nl.requios.effortlessbuilding.create.foundation.utility.Components;
import nl.requios.effortlessbuilding.create.foundation.utility.Lang;

public class ScrollInput
extends AbstractSimiWidget {
    protected Consumer<Integer> onScroll;
    protected int state = 0;
    protected Component title = Lang.translateDirect("gui.scrollInput.defaultTitle", new Object[0]);
    protected final Component scrollToModify = Lang.translateDirect("gui.scrollInput.scrollToModify", new Object[0]);
    protected final Component shiftScrollsFaster = Lang.translateDirect("gui.scrollInput.shiftScrollsFaster", new Object[0]);
    protected Component hint = null;
    protected Label displayLabel;
    protected boolean inverted;
    protected boolean soundPlayed = false;
    protected Function<Integer, Component> formatter;
    protected int min = 0;
    protected int max = 1;
    protected int shiftStep = 5;
    Function<StepContext, Integer> step = this.standardStep();

    public ScrollInput(int xIn, int yIn, int widthIn, int heightIn) {
        super(xIn, yIn, widthIn, heightIn);
        this.formatter = i -> Components.literal(String.valueOf(i));
    }

    public Function<StepContext, Integer> standardStep() {
        return c -> c.shift ? this.shiftStep : 1;
    }

    public ScrollInput inverted() {
        this.inverted = true;
        return this;
    }

    public ScrollInput withRange(int min, int max) {
        this.min = min;
        this.max = max;
        return this;
    }

    public ScrollInput calling(Consumer<Integer> onScroll) {
        this.onScroll = onScroll;
        return this;
    }

    public ScrollInput format(Function<Integer, Component> formatter) {
        this.formatter = formatter;
        return this;
    }

    public ScrollInput removeCallback() {
        this.onScroll = null;
        return this;
    }

    public ScrollInput titled(MutableComponent title) {
        this.title = title;
        this.updateTooltip();
        return this;
    }

    public ScrollInput addHint(MutableComponent hint) {
        this.hint = hint;
        this.updateTooltip();
        return this;
    }

    public ScrollInput withStepFunction(Function<StepContext, Integer> step) {
        this.step = step;
        return this;
    }

    public ScrollInput writingTo(Label label) {
        this.displayLabel = label;
        if (label != null) {
            this.writeToLabel();
        }
        return this;
    }

    @Override
    public void tick() {
        super.tick();
        this.soundPlayed = false;
    }

    public int getState() {
        return this.state;
    }

    public ScrollInput setState(int state) {
        this.state = state;
        this.clampState();
        this.updateTooltip();
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        return this;
    }

    public ScrollInput withShiftStep(int step) {
        this.shiftStep = step;
        return this;
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (!this.visible || !this.isHovered) {
            return false;
        }
        if (this.inverted) {
            scrollX *= -1.0;
        }
        StepContext context = new StepContext();
        context.control = AllKeys.ctrlDown();
        context.shift = AllKeys.shiftDown();
        context.currentValue = this.state;
        context.forward = scrollX > 0.0;
        int priorState = this.state;
        boolean shifted = AllKeys.shiftDown();
        int step = (int)Math.signum(scrollX) * this.step.apply(context);
        this.state += step;
        if (shifted) {
            this.state -= this.state % this.shiftStep;
        }
        this.clampState();
        if (priorState != this.state) {
            this.onChanged();
        }
        return true;
    }

    protected void clampState() {
        if (this.state >= this.max) {
            this.state = this.max - 1;
        }
        if (this.state < this.min) {
            this.state = this.min;
        }
    }

    public void onChanged() {
        if (this.displayLabel != null) {
            this.writeToLabel();
        }
        if (this.onScroll != null) {
            this.onScroll.accept(this.state);
        }
        this.updateTooltip();
    }

    protected void writeToLabel() {
        this.displayLabel.text = this.formatter.apply(this.state);
    }

    protected void updateTooltip() {
        this.toolTip.clear();
        if (this.title == null) {
            return;
        }
        this.toolTip.add(this.title.plainCopy().withStyle(s -> s.withColor(5476833)));
        if (this.hint != null) {
            this.toolTip.add(this.hint.plainCopy().withStyle(s -> s.withColor(9877472)));
        }
        this.toolTip.add(this.scrollToModify.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
        this.toolTip.add(this.shiftScrollsFaster.plainCopy().withStyle(new ChatFormatting[]{ChatFormatting.ITALIC, ChatFormatting.DARK_GRAY}));
    }

    public static class StepContext {
        public int currentValue;
        public boolean forward;
        public boolean shift;
        public boolean control;
    }
}

