/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.compatibility;

import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import nl.requios.effortlessbuilding.create.foundation.item.ItemHelper;
import nl.requios.effortlessbuilding.item.AbstractRandomizerBagItem;

public class CompatHelper {
    public static void setup() {
    }

    public static boolean isItemBlockProxy(ItemStack stack) {
        return CompatHelper.isItemBlockProxy(stack, true);
    }

    public static boolean isItemBlockProxy(ItemStack stack, boolean seeBlockItemsAsProxies) {
        Item item = stack.getItem();
        if (item instanceof BlockItem) {
            return seeBlockItemsAsProxies;
        }
        return item instanceof AbstractRandomizerBagItem;
    }

    public static ItemStack getItemBlockFromStack(ItemStack proxy) {
        Item proxyItem = proxy.getItem();
        if (proxyItem instanceof BlockItem) {
            return proxy;
        }
        if (proxyItem instanceof AbstractRandomizerBagItem) {
            ItemStack itemStack = proxy;
            while (!(itemStack.getItem() instanceof BlockItem) && !itemStack.isEmpty()) {
                if (!(itemStack.getItem() instanceof AbstractRandomizerBagItem)) continue;
                AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)itemStack.getItem();
                itemStack = randomizerBagItem.pickRandomStack(randomizerBagItem.getBagInventory(itemStack));
            }
            return itemStack;
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getItemBlockByState(ItemStack stack, BlockState state) {
        if (state == null) {
            return ItemStack.EMPTY;
        }
        Item blockItem = Item.byBlock((Block)state.getBlock());
        if (stack.getItem() instanceof BlockItem) {
            return stack;
        }
        if (stack.getItem() instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)stack.getItem();
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(stack);
            return randomizerBagItem.findStack(bagInventory, blockItem);
        }
        return ItemStack.EMPTY;
    }

    public static boolean containsBlock(ItemStack stack, Block block) {
        if (stack == null || stack.isEmpty() || !CompatHelper.isItemBlockProxy(stack)) {
            return block == null || block == Blocks.AIR;
        }
        if (stack.getItem() instanceof BlockItem) {
            return ((BlockItem)stack.getItem()).getBlock() == block;
        }
        Item item = stack.getItem();
        if (item instanceof AbstractRandomizerBagItem) {
            AbstractRandomizerBagItem randomizerBagItem = (AbstractRandomizerBagItem)item;
            IItemHandler bagInventory = randomizerBagItem.getBagInventory(stack);
            ItemStack firstMatch = ItemHelper.findFirstMatch(bagInventory, s -> s.getItem() instanceof BlockItem);
            return firstMatch != null && !firstMatch.isEmpty();
        }
        return false;
    }
}

