/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmodifier;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.buildmodifier.BaseModifier;
import nl.requios.effortlessbuilding.utilities.BlockEntry;
import nl.requios.effortlessbuilding.utilities.BlockSet;

public class RadialMirror
extends BaseModifier {
    public Vec3 position = new Vec3(0.5, 64.5, 0.5);
    public int slices = 4;
    public boolean alternate = false;
    public int radius = 20;
    public boolean drawLines = true;
    public boolean drawPlanes = false;

    public RadialMirror() {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null) {
            this.position = Vec3.atLowerCornerOf((Vec3i)Minecraft.getInstance().player.blockPosition());
        }
    }

    @Override
    public void findCoordinates(BlockSet blocks, Player player) {
        if (!this.enabled) {
            return;
        }
        BlockSet originalBlocks = new BlockSet(blocks);
        for (BlockEntry blockEntry : originalBlocks) {
            if (!this.isWithinRange(blockEntry.blockPos)) continue;
            this.performRadialMirror(blocks, blockEntry);
        }
    }

    @Override
    public void onPowerLevelChanged(int powerLevel) {
        this.radius = AttachmentHandler.getMaxMirrorRadius((Player)Minecraft.getInstance().player, false);
    }

    public void performRadialMirror(BlockSet blocks, BlockEntry blockEntry) {
        double sliceAngle = Math.PI * 2 / (double)this.slices;
        Vec3 relStartVec = Vec3.atCenterOf((Vec3i)blockEntry.blockPos).subtract(this.position);
        double startAngleToCenter = Mth.atan2((double)relStartVec.x, (double)relStartVec.z);
        if (startAngleToCenter < 0.0) {
            startAngleToCenter += Math.PI;
        }
        double startAngleInSlice = startAngleToCenter % sliceAngle;
        for (int i = 1; i < this.slices; ++i) {
            Vec3 relNewVec;
            BlockPos newBlockPos;
            boolean doAlternate;
            double curAngle = sliceAngle * (double)i;
            boolean bl = doAlternate = this.alternate && i % 2 == 1;
            if (doAlternate) {
                curAngle = curAngle - startAngleInSlice + (sliceAngle - startAngleInSlice);
            }
            if (blocks.containsKey(newBlockPos = BlockPos.containing((Position)this.position.add(relNewVec = relStartVec.yRot((float)curAngle))))) continue;
            BlockEntry newBlockEntry = new BlockEntry(newBlockPos);
            newBlockEntry.copyRotationSettingsFrom(blockEntry);
            double angleToCenter = Mth.atan2((double)relNewVec.x, (double)relNewVec.z);
            this.rotateBlockEntry(newBlockEntry, angleToCenter, doAlternate);
            blocks.add(newBlockEntry);
        }
    }

    private void rotateBlockEntry(BlockEntry blockEntry, double angleToCenter, boolean alternate) {
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            blockEntry.rotation = blockEntry.rotation.getRotated(Rotation.CLOCKWISE_180);
            if (alternate) {
                // empty if block
            }
        } else if (angleToCenter < -0.7885397560510381) {
            blockEntry.rotation = blockEntry.rotation.getRotated(Rotation.CLOCKWISE_90);
            if (alternate) {
                // empty if block
            }
        } else if (angleToCenter > 0.7822565707438585) {
            blockEntry.rotation = blockEntry.rotation.getRotated(Rotation.COUNTERCLOCKWISE_90);
            if (alternate) {
                // empty if block
            }
        } else if (alternate) {
            // empty if block
        }
    }

    private static BlockState rotateOriginalBlockState(Player player, BlockPos startPos, double startAngleToCenter, BlockState blockState) {
        BlockState newBlockState = blockState;
        if (startAngleToCenter < -2.3593360828459344 || startAngleToCenter > 2.3530528975387552) {
            newBlockState = blockState.rotate((LevelAccessor)player.level(), startPos, Rotation.CLOCKWISE_180);
        } else if (startAngleToCenter < -0.7885397560510381) {
            newBlockState = blockState.rotate((LevelAccessor)player.level(), startPos, Rotation.COUNTERCLOCKWISE_90);
        } else if (startAngleToCenter > 0.7822565707438585) {
            newBlockState = blockState.rotate((LevelAccessor)player.level(), startPos, Rotation.CLOCKWISE_90);
        }
        return newBlockState;
    }

    private static BlockState rotateBlockState(Player player, BlockPos startPos, Vec3 relVec, BlockState blockState, boolean alternate) {
        BlockState newBlockState;
        double angleToCenter = Mth.atan2((double)relVec.x, (double)relVec.z);
        if (angleToCenter < -2.3593360828459344 || angleToCenter > 2.3530528975387552) {
            newBlockState = blockState.rotate((LevelAccessor)player.level(), startPos, Rotation.CLOCKWISE_180);
            if (alternate) {
                newBlockState = newBlockState.mirror(Mirror.FRONT_BACK);
            }
        } else if (angleToCenter < -0.7885397560510381) {
            newBlockState = blockState.rotate((LevelAccessor)player.level(), startPos, Rotation.CLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.mirror(Mirror.LEFT_RIGHT);
            }
        } else if (angleToCenter > 0.7822565707438585) {
            newBlockState = blockState.rotate((LevelAccessor)player.level(), startPos, Rotation.COUNTERCLOCKWISE_90);
            if (alternate) {
                newBlockState = newBlockState.mirror(Mirror.LEFT_RIGHT);
            }
        } else {
            newBlockState = blockState;
            if (alternate) {
                newBlockState = newBlockState.mirror(Mirror.FRONT_BACK);
            }
        }
        return newBlockState;
    }

    public boolean isWithinRange(BlockPos startPos) {
        return new Vec3((double)startPos.getX() + 0.5, (double)startPos.getY() + 0.5, (double)startPos.getZ() + 0.5).subtract(this.position).lengthSqr() < (double)(this.radius * this.radius);
    }

    public int getReach() {
        return this.radius * 2;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag compound = super.serializeNBT();
        compound.putDouble("positionX", this.position.x);
        compound.putDouble("positionY", this.position.y);
        compound.putDouble("positionZ", this.position.z);
        compound.putInt("slices", this.slices);
        compound.putBoolean("alternate", this.alternate);
        compound.putInt("radius", this.radius);
        compound.putBoolean("drawLines", this.drawLines);
        compound.putBoolean("drawPlanes", this.drawPlanes);
        return compound;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        this.position = new Vec3(nbt.getDouble("positionX"), nbt.getDouble("positionY"), nbt.getDouble("positionZ"));
        this.slices = nbt.getInt("slices");
        this.alternate = nbt.getBoolean("alternate");
        this.radius = nbt.getInt("radius");
        this.drawLines = nbt.getBoolean("drawLines");
        this.drawPlanes = nbt.getBoolean("drawPlanes");
    }
}

