/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding.buildmode.buildmodes;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.Vec3;
import nl.requios.effortlessbuilding.attachment.AttachmentHandler;
import nl.requios.effortlessbuilding.buildmode.BuildModes;
import nl.requios.effortlessbuilding.buildmode.TwoClicksBuildMode;

public class Line
extends TwoClicksBuildMode {
    public static BlockPos findLine(Player player, BlockPos firstPos, boolean skipRaytrace) {
        Vec3 look = BuildModes.getPlayerLookVec(player);
        Vec3 start = new Vec3(player.getX(), player.getY() + (double)player.getEyeHeight(), player.getZ());
        ArrayList<Criteria> criteriaList = new ArrayList<Criteria>(3);
        Vec3 xBound = BuildModes.findXBound(firstPos.getX(), start, look);
        criteriaList.add(new Criteria(xBound, firstPos, start));
        Vec3 yBound = BuildModes.findYBound(firstPos.getY(), start, look);
        criteriaList.add(new Criteria(yBound, firstPos, start));
        Vec3 zBound = BuildModes.findZBound(firstPos.getZ(), start, look);
        criteriaList.add(new Criteria(zBound, firstPos, start));
        int reach = AttachmentHandler.getBuildModeReach(player);
        criteriaList.removeIf(criteria -> !criteria.isValid(start, look, reach, player, skipRaytrace));
        if (criteriaList.isEmpty()) {
            return null;
        }
        Criteria selected = (Criteria)criteriaList.get(0);
        if (criteriaList.size() > 1) {
            for (int i = 1; i < criteriaList.size(); ++i) {
                Criteria criteria2 = (Criteria)criteriaList.get(i);
                if (criteria2.distToLineSq < 2.0 && selected.distToLineSq < 2.0) {
                    if (!(criteria2.distToPlayerSq < selected.distToPlayerSq)) continue;
                    selected = criteria2;
                    continue;
                }
                if (!(criteria2.distToLineSq < selected.distToLineSq)) continue;
                selected = criteria2;
            }
        }
        return BlockPos.containing((Position)selected.lineBound);
    }

    public static List<BlockPos> getLineBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        ArrayList<BlockPos> list = new ArrayList<BlockPos>();
        if (x1 != x2) {
            Line.addXLineBlocks(list, x1, x2, y1, z1);
        } else if (y1 != y2) {
            Line.addYLineBlocks(list, y1, y2, x1, z1);
        } else {
            Line.addZLineBlocks(list, z1, z2, x1, y1);
        }
        return list;
    }

    public static void addXLineBlocks(List<BlockPos> list, int x1, int x2, int y, int z) {
        int x = x1;
        while (x1 < x2 ? x <= x2 : x >= x2) {
            list.add(new BlockPos(x, y, z));
            x += x1 < x2 ? 1 : -1;
        }
    }

    public static void addYLineBlocks(List<BlockPos> list, int y1, int y2, int x, int z) {
        int y = y1;
        while (y1 < y2 ? y <= y2 : y >= y2) {
            list.add(new BlockPos(x, y, z));
            y += y1 < y2 ? 1 : -1;
        }
    }

    public static void addZLineBlocks(List<BlockPos> list, int z1, int z2, int x, int y) {
        int z = z1;
        while (z1 < z2 ? z <= z2 : z >= z2) {
            list.add(BlockPos.containing((double)x, (double)y, (double)z));
            z += z1 < z2 ? 1 : -1;
        }
    }

    @Override
    protected BlockPos findSecondPos(Player player, BlockPos firstPos, boolean skipRaytrace) {
        return Line.findLine(player, firstPos, skipRaytrace);
    }

    @Override
    protected List<BlockPos> getAllBlocks(Player player, int x1, int y1, int z1, int x2, int y2, int z2) {
        return Line.getLineBlocks(player, x1, y1, z1, x2, y2, z2);
    }

    static class Criteria {
        Vec3 planeBound;
        Vec3 lineBound;
        double distToLineSq;
        double distToPlayerSq;

        Criteria(Vec3 planeBound, BlockPos firstPos, Vec3 start) {
            this.planeBound = planeBound;
            this.lineBound = this.toLongestLine(this.planeBound, firstPos);
            this.distToLineSq = this.lineBound.subtract(this.planeBound).lengthSqr();
            this.distToPlayerSq = this.planeBound.subtract(start).lengthSqr();
        }

        private Vec3 toLongestLine(Vec3 boundVec, BlockPos firstPos) {
            BlockPos bound = BlockPos.containing((Position)boundVec);
            BlockPos firstToSecond = bound.subtract((Vec3i)firstPos);
            int longest = Math.max((firstToSecond = new BlockPos(Math.abs(firstToSecond.getX()), Math.abs(firstToSecond.getY()), Math.abs(firstToSecond.getZ()))).getX(), Math.max(firstToSecond.getY(), firstToSecond.getZ()));
            if (longest == firstToSecond.getX()) {
                return new Vec3((double)bound.getX(), (double)firstPos.getY(), (double)firstPos.getZ());
            }
            if (longest == firstToSecond.getY()) {
                return new Vec3((double)firstPos.getX(), (double)bound.getY(), (double)firstPos.getZ());
            }
            if (longest == firstToSecond.getZ()) {
                return new Vec3((double)firstPos.getX(), (double)firstPos.getY(), (double)bound.getZ());
            }
            return null;
        }

        public boolean isValid(Vec3 start, Vec3 look, int reach, Player player, boolean skipRaytrace) {
            return BuildModes.isCriteriaValid(start, look, reach, player, skipRaytrace, this.lineBound, this.planeBound, this.distToPlayerSq);
        }
    }
}

