/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import com.mojang.serialization.MapCodec;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.IExtensionPoint;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.config.IConfigSpec;
import net.neoforged.fml.config.ModConfig;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.fml.loading.FMLEnvironment;
import net.neoforged.neoforge.attachment.AttachmentType;
import net.neoforged.neoforge.client.gui.ConfigurationScreen;
import net.neoforged.neoforge.client.gui.IConfigScreenFactory;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.common.loot.IGlobalLootModifier;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.network.IContainerFactory;
import net.neoforged.neoforge.registries.DeferredItem;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import nl.requios.effortlessbuilding.ClientConfig;
import nl.requios.effortlessbuilding.CommonConfig;
import nl.requios.effortlessbuilding.EffortlessBuildingClient;
import nl.requios.effortlessbuilding.ServerConfig;
import nl.requios.effortlessbuilding.attachment.PowerLevel;
import nl.requios.effortlessbuilding.compatibility.CompatHelper;
import nl.requios.effortlessbuilding.gui.DiamondRandomizerBagContainer;
import nl.requios.effortlessbuilding.gui.GoldenRandomizerBagContainer;
import nl.requios.effortlessbuilding.gui.RandomizerBagContainer;
import nl.requios.effortlessbuilding.item.DiamondRandomizerBagItem;
import nl.requios.effortlessbuilding.item.GoldenRandomizerBagItem;
import nl.requios.effortlessbuilding.item.PowerLevelItem;
import nl.requios.effortlessbuilding.item.RandomizerBagItem;
import nl.requios.effortlessbuilding.item.ReachUpgrade1Item;
import nl.requios.effortlessbuilding.item.ReachUpgrade2Item;
import nl.requios.effortlessbuilding.item.ReachUpgrade3Item;
import nl.requios.effortlessbuilding.item.SingleItemLootModifier;
import nl.requios.effortlessbuilding.network.PacketHandler;
import nl.requios.effortlessbuilding.proxy.ClientProxy;
import nl.requios.effortlessbuilding.proxy.ServerProxy;
import nl.requios.effortlessbuilding.systems.ItemUsageTracker;
import nl.requios.effortlessbuilding.systems.ServerBlockPlacer;
import nl.requios.effortlessbuilding.systems.UndoRedo;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="effortlessbuilding")
public class EffortlessBuilding {
    public static final String MODID = "effortlessbuilding";
    public static final Logger logger = LogManager.getLogger();
    public static EffortlessBuilding instance;
    public static final ServerBlockPlacer SERVER_BLOCK_PLACER;
    public static final UndoRedo UNDO_REDO;
    public static final ItemUsageTracker ITEM_USAGE_TRACKER;
    private static final DeferredRegister.Items ITEMS;
    private static final DeferredRegister<MenuType<?>> CONTAINERS;
    private static final DeferredRegister<MapCodec<? extends IGlobalLootModifier>> LOOT_MODIFIERS;
    private static final DeferredRegister<AttachmentType<?>> ATTACHMENT_TYPES;
    public static final DeferredItem<RandomizerBagItem> RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<GoldenRandomizerBagItem> GOLDEN_RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<DiamondRandomizerBagItem> DIAMOND_RANDOMIZER_BAG_ITEM;
    public static final DeferredItem<ReachUpgrade1Item> REACH_UPGRADE_1_ITEM;
    public static final DeferredItem<ReachUpgrade2Item> REACH_UPGRADE_2_ITEM;
    public static final DeferredItem<ReachUpgrade3Item> REACH_UPGRADE_3_ITEM;
    public static final DeferredItem<PowerLevelItem> MUSCLES_ITEM;
    public static final DeferredItem<PowerLevelItem> ELASTIC_HAND_ITEM;
    public static final DeferredItem<PowerLevelItem> BUILDING_TECHNIQUES_BOOK_ITEM;
    public static final Supplier<MenuType<RandomizerBagContainer>> RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MenuType<GoldenRandomizerBagContainer>> GOLDEN_RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MenuType<DiamondRandomizerBagContainer>> DIAMOND_RANDOMIZER_BAG_CONTAINER;
    public static final Supplier<MapCodec<SingleItemLootModifier>> SINGLE_ITEM_LOOT_MODIFIER;
    public static final Supplier<AttachmentType<PowerLevel>> POWER_LEVEL;

    public EffortlessBuilding(IEventBus modEventBus, ModContainer container, Dist dist) {
        instance = this;
        IEventBus forgeEventBus = NeoForge.EVENT_BUS;
        modEventBus.addListener(EffortlessBuilding::setup);
        modEventBus.addListener(EffortlessBuilding::addTabContents);
        modEventBus.addListener(PacketHandler::setupPackets);
        ITEMS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        LOOT_MODIFIERS.register(modEventBus);
        ATTACHMENT_TYPES.register(modEventBus);
        container.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)CommonConfig.spec);
        container.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ServerConfig.spec);
        if (dist.isClient()) {
            container.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientConfig.spec);
            container.registerExtensionPoint(IConfigScreenFactory.class, (IExtensionPoint)((IConfigScreenFactory)ConfigurationScreen::new));
            EffortlessBuildingClient.onConstructorClient(modEventBus, forgeEventBus);
        }
    }

    public static void setup(FMLCommonSetupEvent event) {
        CompatHelper.setup();
    }

    public static void addTabContents(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.TOOLS_AND_UTILITIES) {
            List<ItemStack> stacks = ITEMS.getEntries().stream().map(reg -> new ItemStack((ItemLike)reg.get())).toList();
            event.acceptAll(stacks);
        }
    }

    public static <T extends AbstractContainerMenu> MenuType<T> registerContainer(IContainerFactory<T> fact) {
        MenuType type = new MenuType(fact, FeatureFlags.REGISTRY.allFlags());
        return type;
    }

    public static void log(String msg) {
        logger.info(msg);
    }

    public static void log(Player player, String msg) {
        EffortlessBuilding.log(player, msg, false);
    }

    public static void log(Player player, String msg, boolean actionBar) {
        player.displayClientMessage((Component)Component.literal((String)msg), actionBar);
    }

    public static void logTranslate(Player player, String prefix, String translationKey, String suffix, boolean actionBar) {
        if (FMLEnvironment.dist.isClient()) {
            ClientProxy.logTranslate(player, prefix, translationKey, suffix, actionBar);
        } else {
            ServerProxy.logTranslate(player, prefix, translationKey, suffix, actionBar);
        }
    }

    public static void logError(String msg) {
        logger.error(msg);
    }

    public static ResourceLocation asResource(String path) {
        return ResourceLocation.fromNamespaceAndPath((String)MODID, (String)path);
    }

    static {
        SERVER_BLOCK_PLACER = new ServerBlockPlacer();
        UNDO_REDO = new UndoRedo();
        ITEM_USAGE_TRACKER = new ItemUsageTracker();
        ITEMS = DeferredRegister.createItems((String)MODID);
        CONTAINERS = DeferredRegister.create((Registry)BuiltInRegistries.MENU, (String)MODID);
        LOOT_MODIFIERS = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)MODID);
        ATTACHMENT_TYPES = DeferredRegister.create((ResourceKey)NeoForgeRegistries.Keys.ATTACHMENT_TYPES, (String)MODID);
        RANDOMIZER_BAG_ITEM = ITEMS.register("randomizer_bag", RandomizerBagItem::new);
        GOLDEN_RANDOMIZER_BAG_ITEM = ITEMS.register("golden_randomizer_bag", GoldenRandomizerBagItem::new);
        DIAMOND_RANDOMIZER_BAG_ITEM = ITEMS.register("diamond_randomizer_bag", DiamondRandomizerBagItem::new);
        REACH_UPGRADE_1_ITEM = ITEMS.register("reach_upgrade1", ReachUpgrade1Item::new);
        REACH_UPGRADE_2_ITEM = ITEMS.register("reach_upgrade2", ReachUpgrade2Item::new);
        REACH_UPGRADE_3_ITEM = ITEMS.register("reach_upgrade3", ReachUpgrade3Item::new);
        MUSCLES_ITEM = ITEMS.register("muscles", PowerLevelItem::new);
        ELASTIC_HAND_ITEM = ITEMS.register("elastic_hand", PowerLevelItem::new);
        BUILDING_TECHNIQUES_BOOK_ITEM = ITEMS.register("building_techniques_book", PowerLevelItem::new);
        RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("randomizer_bag", () -> EffortlessBuilding.registerContainer(RandomizerBagContainer::new));
        GOLDEN_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("golden_randomizer_bag", () -> EffortlessBuilding.registerContainer(GoldenRandomizerBagContainer::new));
        DIAMOND_RANDOMIZER_BAG_CONTAINER = CONTAINERS.register("diamond_randomizer_bag", () -> EffortlessBuilding.registerContainer(DiamondRandomizerBagContainer::new));
        SINGLE_ITEM_LOOT_MODIFIER = LOOT_MODIFIERS.register("single_item_loot_modifier", SingleItemLootModifier.CODEC);
        POWER_LEVEL = ATTACHMENT_TYPES.register("power_level", () -> AttachmentType.serializable(PowerLevel::new).build());
    }
}

