/*
 * Decompiled with CFR 0.152.
 */
package nl.requios.effortlessbuilding;

import net.neoforged.neoforge.common.ModConfigSpec;

public class ClientConfig {
    private static final ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
    public static final Visuals visuals = new Visuals(builder);
    public static final ModConfigSpec spec = builder.build();

    public static class Visuals {
        public final ModConfigSpec.BooleanValue showBlockPreviews;
        public final ModConfigSpec.BooleanValue onlyShowBlockPreviewsWhenBuilding;
        public final ModConfigSpec.IntValue maxBlockPreviews;
        public final ModConfigSpec.IntValue appearAnimationLength;
        public final ModConfigSpec.IntValue breakAnimationLength;

        public Visuals(ModConfigSpec.Builder builder) {
            builder.push("Visuals");
            this.showBlockPreviews = builder.comment("Show previews of the blocks while placing them").define("showBlockPreviews", true);
            this.onlyShowBlockPreviewsWhenBuilding = builder.comment("Show block previews only when actively using a build mode").define("onlyShowBlockPreviewsWhenBuilding", true);
            this.maxBlockPreviews = builder.comment("Don't show block previews when placing more than this many blocks. The outline will always be rendered.").defineInRange("maxBlockPreviews", 400, 0, 5000);
            this.appearAnimationLength = builder.comment(new String[]{"How long it takes for a block to appear when placed in ticks.", "Set to 0 to disable animation."}).defineInRange("appearAnimationLength", 5, 0, 100);
            this.breakAnimationLength = builder.comment(new String[]{"How long the break animation is in ticks.", "Set to 0 to disable animation."}).defineInRange("breakAnimationLength", 10, 0, 100);
            builder.pop();
        }
    }
}

