/*
 * Decompiled with CFR 0.152.
 */
package dev.terminalmc.moremousetweaks.mixin.quick.craft;

import dev.terminalmc.moremousetweaks.MoreMouseTweaks;
import dev.terminalmc.moremousetweaks.config.Config;
import dev.terminalmc.moremousetweaks.inventory.helper.InteractionHelper;
import dev.terminalmc.moremousetweaks.network.InteractionManager;
import dev.terminalmc.moremousetweaks.util.InputUtil;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeBookComponent;
import net.minecraft.client.gui.screens.recipebook.RecipeBookPage;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import yalter.mousetweaks.MouseButton;

@Mixin(value={RecipeBookComponent.class})
public abstract class RecipeBookComponentMixin {
    @Shadow
    public static final int IMAGE_WIDTH = 147;
    @Shadow
    public static final int IMAGE_HEIGHT = 166;
    @Shadow
    @Final
    private RecipeBookPage recipeBookPage;
    @Shadow
    private int width;
    @Shadow
    private int xOffset;
    @Shadow
    private int height;
    @Shadow
    private boolean ignoreTextInput;
    @Shadow
    protected Minecraft minecraft;
    @Shadow
    @Final
    private StackedContents stackedContents;
    @Shadow
    protected RecipeBookMenu<?, ?> menu;

    @Shadow
    public abstract boolean isVisible();

    @Inject(method={"mouseClicked"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/MultiPlayerGameMode;handlePlaceRecipe(ILnet/minecraft/world/item/crafting/RecipeHolder;Z)V", shift=At.Shift.AFTER)})
    public void mouseClicked(double mouseX, double mouseY, int mouseButton, CallbackInfoReturnable<Boolean> cir) {
        if (!Config.options().useQuickCrafting || mouseButton != MouseButton.RIGHT.getValue()) {
            return;
        }
        int resultSlotId = this.menu.getResultSlotIndex();
        if (Screen.hasShiftDown() && InputUtil.isMatchingSlotsKeyDown()) {
            this.mmt$bulkQuickCraft(resultSlotId, false);
        } else {
            this.mmt$quickCraft(resultSlotId);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int keyCode, int scanCode, int modifiers, CallbackInfoReturnable<Boolean> cir) {
        if (!this.isVisible() || this.minecraft.player.isSpectator()) {
            return;
        }
        if (!Config.options().useQuickCrafting || !this.minecraft.options.keyDrop.matches(keyCode, scanCode)) {
            return;
        }
        if (!this.minecraft.player.containerMenu.getCarried().isEmpty()) {
            return;
        }
        this.ignoreTextInput = false;
        boolean clickSuccess = this.recipeBookPage.mouseClicked(InputUtil.getMouseX(), InputUtil.getMouseY(), MouseButton.LEFT.getValue(), (this.width - 147) / 2 - this.xOffset, (this.height - 166) / 2, 147, 166);
        if (!clickSuccess) {
            return;
        }
        RecipeHolder recipe = this.recipeBookPage.getLastClickedRecipe();
        RecipeCollection collection = this.recipeBookPage.getLastClickedRecipeCollection();
        if (recipe == null || collection == null) {
            return;
        }
        int resultSlotId = this.menu.getResultSlotIndex();
        InteractionManager.pushPacketEvent(new ServerboundPlaceRecipePacket(this.menu.containerId, recipe, Screen.hasShiftDown()), InteractionManager.TICK_WAITER);
        if (Screen.hasShiftDown() && InputUtil.isMatchingSlotsKeyDown()) {
            this.mmt$bulkQuickCraft(resultSlotId, true);
        } else if (Screen.hasShiftDown()) {
            this.mmt$dropAll(recipe, resultSlotId);
        } else {
            InteractionHelper.drop(this.menu.containerId, resultSlotId);
        }
        cir.setReturnValue((Object)true);
    }

    @Unique
    private void mmt$bulkQuickCraft(int resultSlotId, boolean drop) {
        RecipeHolder recipe = this.recipeBookPage.getLastClickedRecipe();
        RecipeCollection collection = this.recipeBookPage.getLastClickedRecipeCollection();
        if (recipe == null || collection == null) {
            return;
        }
        int maxOps = 0;
        for (Slot slot : this.minecraft.player.containerMenu.slots) {
            if (!slot.hasItem()) continue;
            ++maxOps;
        }
        AtomicBoolean abort = new AtomicBoolean(false);
        for (int i = 0; i < maxOps && !abort.get(); ++i) {
            InteractionManager.pushPacketEvent(new ServerboundPlaceRecipePacket(this.menu.containerId, recipe, true), type -> {
                if (!collection.isCraftable(recipe)) {
                    abort.set(true);
                    InteractionManager.clear();
                    return false;
                }
                return MoreMouseTweaks.lastUpdatedSlot >= this.menu.getSize();
            });
            if (drop) {
                this.mmt$dropAll(recipe, resultSlotId);
                continue;
            }
            InteractionHelper.quickMove(this.menu.containerId, resultSlotId);
        }
    }

    @Unique
    private void mmt$quickCraft(int resultSlotId) {
        boolean pickupClick = false;
        boolean quickMoveClick = false;
        if (Screen.hasShiftDown()) {
            quickMoveClick = true;
        } else {
            switch (Config.options().qcSingleCraftMode) {
                case CURSOR: {
                    pickupClick = true;
                    break;
                }
                case CURSOR_INVENTORY: {
                    pickupClick = true;
                    quickMoveClick = true;
                    break;
                }
                case INVENTORY: {
                    quickMoveClick = true;
                }
            }
        }
        if (pickupClick) {
            InteractionHelper.pickup(this.menu.containerId, resultSlotId);
        }
        if (quickMoveClick) {
            InteractionHelper.quickMove(this.menu.containerId, resultSlotId);
        }
    }

    @Unique
    private void mmt$dropAll(RecipeHolder<?> recipe, int resSlot) {
        int maxOps = this.stackedContents.getBiggestCraftableStack(recipe, recipe.value().getResultItem((HolderLookup.Provider)this.minecraft.level.registryAccess()).getMaxStackSize(), null);
        for (int i = 0; i < maxOps; ++i) {
            InteractionHelper.drop(this.menu.containerId, resSlot);
        }
    }
}

