/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.util;

import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;

public class CarriedItemUtil {
    private static int stashedSlotIndex = -1;

    public static void stashCarriedItem(LocalPlayer player, MultiPlayerGameMode gameMode, AbstractContainerMenu containerMenu) {
        int screenSlotIndex;
        int emptyInventorySlot;
        if (!containerMenu.getCarried().isEmpty() && (emptyInventorySlot = player.getInventory().getFreeSlot()) != -1 && (screenSlotIndex = CarriedItemUtil.findScreenSlotIndex(player, containerMenu, emptyInventorySlot)) != -1) {
            gameMode.handleInventoryMouseClick(containerMenu.containerId, screenSlotIndex, 0, ClickType.PICKUP, (Player)player);
            stashedSlotIndex = emptyInventorySlot;
        }
    }

    public static void unstashCarriedItem(LocalPlayer player, MultiPlayerGameMode gameMode, AbstractContainerMenu containerMenu) {
        if (stashedSlotIndex != -1) {
            int screenSlotIndex = CarriedItemUtil.findScreenSlotIndex(player, containerMenu, stashedSlotIndex);
            if (screenSlotIndex != -1) {
                gameMode.handleInventoryMouseClick(containerMenu.containerId, screenSlotIndex, 0, ClickType.PICKUP, (Player)player);
            }
            stashedSlotIndex = -1;
        }
    }

    public static void reset() {
        stashedSlotIndex = -1;
    }

    public static boolean isStashed() {
        return stashedSlotIndex != -1;
    }

    private static int findScreenSlotIndex(LocalPlayer player, AbstractContainerMenu containerMenu, int inventorySlotIndex) {
        for (int i = 0; i < containerMenu.slots.size(); ++i) {
            Slot slot = (Slot)containerMenu.slots.get(i);
            if (slot.container != player.getInventory() || slot.getSlotIndex() != inventorySlotIndex) continue;
            return i;
        }
        return -1;
    }
}

