/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.gui;

import com.yukami.backpacktab.client.tabs.InventoryTab;
import com.yukami.backpacktab.client.util.CarriedItemUtil;
import net.minecraft.client.multiplayer.MultiPlayerGameMode;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.world.entity.player.Player;

public class TabSwitcher {
    public static void switchToTab(InventoryTab targetTab, Player player, MultiPlayerGameMode gameMode) {
        if (!(player instanceof LocalPlayer)) {
            return;
        }
        LocalPlayer localPlayer = (LocalPlayer)player;
        if (gameMode == null) {
            return;
        }
        TabSwitcher.prepareContainerSwitch(localPlayer, gameMode);
        targetTab.open(player, player.level(), player.containerMenu, gameMode);
    }

    private static void prepareContainerSwitch(LocalPlayer localPlayer, MultiPlayerGameMode gameMode) {
        CarriedItemUtil.stashCarriedItem(localPlayer, gameMode, localPlayer.containerMenu);
        if (localPlayer.connection != null) {
            localPlayer.connection.send((Packet)new ServerboundContainerClosePacket(localPlayer.containerMenu.containerId));
        }
    }

    public static void restoreCarriedItems(LocalPlayer localPlayer, MultiPlayerGameMode gameMode) {
        if (gameMode != null && localPlayer.containerMenu != null) {
            CarriedItemUtil.unstashCarriedItem(localPlayer, gameMode, localPlayer.containerMenu);
        }
    }
}

