/*
 * Decompiled with CFR 0.152.
 */
package com.yukami.backpacktab.client.config;

import java.util.Arrays;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class TabConfig {
    public static final ModConfigSpec CLIENT_SPEC;
    public static final Client CLIENT;

    public static TabPosition getTabPosition() {
        return (TabPosition)((Object)TabConfig.CLIENT.tabPosition.get());
    }

    public static List<? extends String> getAdditionalTabBlocks() {
        return (List)TabConfig.CLIENT.additionalTabBlocks.get();
    }

    static {
        ModConfigSpec.Builder clientBuilder = new ModConfigSpec.Builder();
        CLIENT = new Client(clientBuilder);
        CLIENT_SPEC = clientBuilder.build();
    }

    public static class Client {
        public final ModConfigSpec.EnumValue<TabPosition> tabPosition;
        public final ModConfigSpec.ConfigValue<List<? extends String>> additionalTabBlocks;

        public Client(ModConfigSpec.Builder builder) {
            builder.comment("Yukami Backpack Tab Configuration").push("general");
            this.tabPosition = builder.comment(new String[]{"Position of the inventory tabs", "Valid values: TOP_LEFT, TOP_RIGHT, BOTTOM_LEFT, BOTTOM_RIGHT"}).defineEnum("tabPosition", (Enum)TabPosition.TOP_LEFT);
            this.additionalTabBlocks = builder.comment(new String[]{"Additional blocks that should have tabs enabled", "Format: modID:block_name (e.g., 'minecraft:chest', 'sophisticatedbackpacks:backpack')"}).defineList("additionalTabBlocks", Arrays.asList(new String[0]), mapping -> ((String)mapping).matches("^[a-z0-9_.-]+:[a-z0-9/_.-]+$"));
            builder.pop();
        }
    }

    public static enum TabPosition {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;


        public boolean isBottom() {
            return this == BOTTOM_LEFT || this == BOTTOM_RIGHT;
        }

        public boolean isRight() {
            return this == TOP_RIGHT || this == BOTTOM_RIGHT;
        }
    }
}

