/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.widget;

import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.level.material.Fluid;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.utility.BnCFluidItemDisplays;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;

public class BnCFluidWidget
extends SlotWidget {
    private final Function<Random, EmiStack> fluidGenerator = random -> {
        List stacks = fluid.getEmiStacks();
        return (EmiStack)stacks.get(random.nextInt(stacks.size()));
    };
    private final int unique;
    private long lastFluidGenerate = 0L;
    private EmiIngredient fluidIngredient = null;
    private boolean invalidateItemStack = false;
    private EmiIngredient itemIngredient = null;

    public BnCFluidWidget(EmiIngredient fluid, int unique, int x, int y) {
        super((EmiIngredient)EmiStack.EMPTY, x, y);
        this.unique = unique;
        this.custom = true;
        this.customWidth = 28;
        this.customHeight = 32;
        this.output = true;
    }

    public void drawBackground(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        AbstractedFluidStack fluidStack = new AbstractedFluidStack((Fluid)((EmiStack)this.getStack().getEmiStacks().getFirst()).getKey(), ((EmiStack)this.getStack().getEmiStacks().getFirst()).getAmount(), (DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)((EmiStack)this.getStack().getEmiStacks().getFirst()).getComponentChanges()), FluidUnit.getLoaderUnit());
        if (((BnCConfiguration.Client)BnCConfiguration.CLIENT_CONFIG.get()).renderFluidInKeg()) {
            BrewinAndChewinClient.getHelper().renderFluidInKeg(fluidStack, draw, bounds.x() + 2, bounds.y() + 2, 1.0f);
        }
    }

    public void drawStack(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        int xOff = (bounds.width() - 16) / 2;
        int yOff = (bounds.height() - 16) / 2 - 4;
        this.getItemStack().render(draw, bounds.x() + xOff, bounds.y() + yOff, delta);
    }

    public void drawOverlay(GuiGraphics draw, int mouseX, int mouseY, float delta) {
        Bounds bounds = this.getBounds();
        draw.blit(FermentingEmiRecipe.BACKGROUND, bounds.x() + 1, bounds.y() + 1, 170, 45, bounds.width(), bounds.height() - 2);
        super.drawOverlay(draw, mouseX, mouseY, delta);
    }

    public EmiIngredient getStack() {
        long time = System.currentTimeMillis() / 1000L;
        if (this.fluidIngredient == null || time > this.lastFluidGenerate) {
            this.lastFluidGenerate = time;
            this.fluidIngredient = (EmiIngredient)this.fluidGenerator.apply(this.getRandom(time));
            this.invalidateItemStack = true;
        }
        return this.fluidIngredient;
    }

    public EmiIngredient getItemStack() {
        if (this.invalidateItemStack) {
            AbstractedFluidStack fluidStack = new AbstractedFluidStack((Fluid)((EmiStack)this.getStack().getEmiStacks().getFirst()).getKey(), ((EmiStack)this.getStack().getEmiStacks().getFirst()).getAmount(), (DataComponentMap)PatchedDataComponentMap.fromPatch((DataComponentMap)DataComponentMap.EMPTY, (DataComponentPatch)((EmiStack)this.getStack().getEmiStacks().getFirst()).getComponentChanges()), FluidUnit.getLoaderUnit());
            ItemStack itemDisplay = BnCFluidItemDisplays.getFluidItemDisplay((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), fluidStack).copy();
            Optional<KegPouringRecipe> pouringRecipe = Minecraft.getInstance().level.getRecipeManager().getAllRecipesFor(BnCRecipeTypes.KEG_POURING).stream().map(RecipeHolder::value).sorted(Comparator.comparing(KegPouringRecipe::isStrict)).filter(kegPouringRecipe -> {
                if (kegPouringRecipe.isStrict()) {
                    return ItemStack.isSameItemSameComponents((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
                }
                return ItemStack.isSameItem((ItemStack)itemDisplay, (ItemStack)kegPouringRecipe.getResultItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess()));
            }).findFirst();
            int pourCount = pouringRecipe.map(kegPouringRecipe -> (int)(Math.min(FluidUnit.convert(((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().capacity(), ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().capacityUnit(), FluidUnit.getLoaderUnit()), fluidStack.amount()) / kegPouringRecipe.getLoaderAmount())).orElse(1);
            itemDisplay.setCount(pourCount);
            this.itemIngredient = EmiStack.of((ItemStack)itemDisplay);
            this.invalidateItemStack = false;
        }
        return this.itemIngredient;
    }

    private Random getRandom(long time) {
        return new Random(new Random(time ^ (long)this.unique).nextInt());
    }
}

