/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.emi.handler;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.recipe.EmiPlayerInventory;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.handler.EmiCraftContext;
import dev.emi.emi.api.recipe.handler.StandardRecipeHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Bounds;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.Widget;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.IntFunction;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.network.serverbound.EMIFillFermentingRecipeServerboundPacket;
import umpaz.brewinandchewin.common.network.serverbound.EMIFillPouringRecipeServerboundPacket;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.integration.emi.BnCRecipeCategories;
import umpaz.brewinandchewin.integration.emi.handler.BnCEMIRecipeFiller;
import umpaz.brewinandchewin.integration.emi.recipe.FermentingEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.KegEmiRecipe;
import umpaz.brewinandchewin.integration.emi.recipe.PouringEmiRecipe;
import umpaz.brewinandchewin.integration.emi.widget.BnCFluidWidget;

public class KegEmiRecipeHandler
implements StandardRecipeHandler<KegMenu> {
    private static final Component WARMER_TEMPERATURE = Component.translatable((String)"brewinandchewin.emi.warmer_temperature");
    private static final Component COOLER_TEMPERATURE = Component.translatable((String)"brewinandchewin.emi.cooler_temperature");
    private static final Component CANT_EMPTY = Component.translatable((String)"brewinandchewin.emi.cant_empty");
    private static final Component INCORRECT_FLUID = Component.translatable((String)"brewinandchewin.emi.incorrect_fluid");

    public List<Slot> getInputSources(KegMenu menu) {
        int invStart;
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 4; ++i) {
            list.add(menu.getSlot(i));
        }
        for (int i = invStart = 6; i < invStart + 36; ++i) {
            list.add(menu.getSlot(i));
        }
        return list;
    }

    public List<Slot> getCraftingSlots(KegMenu menu) {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < 6; ++i) {
            list.add(menu.getSlot(i));
        }
        return list;
    }

    public Slot getOutputSlot(KegMenu menu) {
        return menu.getSlot(5);
    }

    public EmiPlayerInventory getInventory(AbstractContainerScreen<KegMenu> screen) {
        return new EmiPlayerInventory(this.getInputSources((KegMenu)screen.getMenu()).stream().map(slot -> EmiStack.of((ItemStack)slot.getItem())).toList());
    }

    public boolean canCraft(EmiRecipe recipe, EmiCraftContext<KegMenu> context) {
        PouringEmiRecipe pouringRecipe;
        if (recipe instanceof FermentingEmiRecipe) {
            FermentingEmiRecipe fermentingRecipe = (FermentingEmiRecipe)recipe;
            if (!KegBlockEntity.isValidTemp(((KegMenu)context.getScreenHandler()).getKegTemperature(), fermentingRecipe.getTemperature())) {
                return false;
            }
            if (!KegEmiRecipeHandler.validFluidOrCanEmpty(fermentingRecipe, fermentingRecipe.getFluidInput(), fermentingRecipe.getFluidItemInput(), context)) {
                return false;
            }
        } else if (recipe instanceof PouringEmiRecipe && !KegEmiRecipeHandler.hasFluid((pouringRecipe = (PouringEmiRecipe)recipe).getFluidInput(), context)) {
            return false;
        }
        if (recipe instanceof KegEmiRecipe) {
            KegEmiRecipe kegRecipe = (KegEmiRecipe)recipe;
            return KegEmiRecipeHandler.hasItems(kegRecipe.getItemInputs(), context);
        }
        return false;
    }

    private static boolean hasItems(List<EmiIngredient> ingredients, EmiCraftContext<KegMenu> context) {
        Object2LongOpenHashMap used = new Object2LongOpenHashMap();
        boolean failure = false;
        block0: for (EmiIngredient ingredient : ingredients) {
            if (ingredient.isEmpty()) continue;
            for (EmiStack stack : ingredient.getEmiStacks()) {
                long desired = stack.getAmount();
                if (!context.getInventory().inventory.containsKey(stack)) continue;
                EmiStack identity = (EmiStack)context.getInventory().inventory.get(stack);
                long alreadyUsed = used.getOrDefault((Object)identity, 0L);
                long available = identity.getAmount() - alreadyUsed;
                if (available < desired) continue;
                used.put((Object)identity, desired + alreadyUsed);
                continue block0;
            }
            failure = true;
        }
        return !failure;
    }

    public boolean craft(EmiRecipe recipe, EmiCraftContext<KegMenu> context) {
        PouringEmiRecipe pouringRecipe;
        List<ItemStack> stacks;
        if (recipe instanceof FermentingEmiRecipe) {
            FermentingEmiRecipe fermentingRecipe = (FermentingEmiRecipe)recipe;
            Map<InputType, List<ItemStack>> stacks2 = BnCEMIRecipeFiller.getFermentingStacks(this, fermentingRecipe, context, context.getAmount());
            if (stacks2 != null) {
                Minecraft.getInstance().setScreen((Screen)context.getScreen());
                BrewinAndChewin.getHelper().sendServerbound(new EMIFillFermentingRecipeServerboundPacket((KegMenu)context.getScreenHandler(), stacks2));
                return true;
            }
        } else if (recipe instanceof PouringEmiRecipe && (stacks = BnCEMIRecipeFiller.getPouringStacks(this, pouringRecipe = (PouringEmiRecipe)recipe, context, context.getAmount())) != null) {
            int destination = switch (context.getDestination()) {
                case EmiCraftContext.Destination.NONE -> 0;
                case EmiCraftContext.Destination.CURSOR -> 1;
                case EmiCraftContext.Destination.INVENTORY -> 2;
                default -> throw new MatchException(null, null);
            };
            Minecraft.getInstance().setScreen((Screen)context.getScreen());
            BrewinAndChewin.getHelper().sendServerbound(new EMIFillPouringRecipeServerboundPacket((KegMenu)context.getScreenHandler(), destination, stacks));
            return true;
        }
        return false;
    }

    public List<ClientTooltipComponent> getTooltip(EmiRecipe recipe, EmiCraftContext<KegMenu> context) {
        ArrayList components = Lists.newArrayList();
        if (recipe instanceof FermentingEmiRecipe) {
            FermentingEmiRecipe fermentingRecipe = (FermentingEmiRecipe)recipe;
            if (!KegEmiRecipeHandler.hasItems(fermentingRecipe.getItemInputs(), context)) {
                components.addAll(super.getTooltip(recipe, context));
            }
            if (!KegEmiRecipeHandler.validFluidOrCanEmpty(fermentingRecipe, fermentingRecipe.getFluidInput(), fermentingRecipe.getFluidItemInput(), context)) {
                if (KegEmiRecipeHandler.hasFluidOrAssociatedItem(fermentingRecipe.getFluidInput(), fermentingRecipe.getFluidItemInput(), context)) {
                    components.add(ClientTooltipComponent.create((FormattedCharSequence)CANT_EMPTY.getVisualOrderText()));
                } else {
                    components.add(ClientTooltipComponent.create((FormattedCharSequence)INCORRECT_FLUID.getVisualOrderText()));
                }
            }
            if (!KegBlockEntity.isValidTemp(((KegMenu)context.getScreenHandler()).getKegTemperature(), fermentingRecipe.getTemperature())) {
                if (((KegMenu)context.getScreenHandler()).getKegTemperature() < fermentingRecipe.getTemperature()) {
                    components.add(ClientTooltipComponent.create((FormattedCharSequence)WARMER_TEMPERATURE.getVisualOrderText()));
                } else {
                    components.add(ClientTooltipComponent.create((FormattedCharSequence)COOLER_TEMPERATURE.getVisualOrderText()));
                }
            }
        } else if (recipe instanceof PouringEmiRecipe) {
            PouringEmiRecipe pouringRecipe = (PouringEmiRecipe)recipe;
            if (!KegEmiRecipeHandler.hasItems(pouringRecipe.getItemInputs(), context)) {
                components.addAll(super.getTooltip(recipe, context));
            }
            if (!KegEmiRecipeHandler.hasFluid(pouringRecipe.getFluidInput(), context)) {
                components.addAll(super.getTooltip(recipe, context));
            }
        }
        return components;
    }

    public void render(EmiRecipe recipe, EmiCraftContext<KegMenu> context, List<Widget> widgets, GuiGraphics draw) {
        KegEmiRecipeHandler.renderMissing(recipe, context, widgets, draw);
    }

    private static void renderMissing(EmiRecipe recipe, EmiCraftContext<KegMenu> context, List<Widget> widgets, GuiGraphics draw) {
        RenderSystem.enableDepthTest();
        Map<EmiIngredient, Boolean> availableForCrafting = KegEmiRecipeHandler.getAvailable(recipe, context);
        for (Widget w : widgets) {
            if (!(w instanceof SlotWidget)) continue;
            SlotWidget sw = (SlotWidget)w;
            EmiIngredient stack = sw.getStack();
            Bounds bounds = sw.getBounds();
            if (sw instanceof BnCFluidWidget && recipe instanceof KegEmiRecipe) {
                KegEmiRecipe kegRecipe = (KegEmiRecipe)recipe;
                if (sw.getRecipe() != null || KegEmiRecipeHandler.validFluidOrCanEmpty(kegRecipe, kegRecipe.getFluidInput(), kegRecipe.getFluidItemInput(), context)) continue;
                draw.fill(bounds.x(), bounds.y(), bounds.x() + bounds.width(), bounds.y() + bounds.height(), 0x44FF0000);
                continue;
            }
            if (sw.getRecipe() != null || !availableForCrafting.containsKey(stack) || stack.isEmpty() || availableForCrafting.get(stack).booleanValue()) continue;
            draw.fill(bounds.x(), bounds.y(), bounds.x() + bounds.width(), bounds.y() + bounds.height(), 0x44FF0000);
        }
        if (recipe instanceof FermentingEmiRecipe) {
            FermentingEmiRecipe fermentingRecipe = (FermentingEmiRecipe)recipe;
            if (!KegBlockEntity.isValidTemp(((KegMenu)context.getScreenHandler()).getKegTemperature(), fermentingRecipe.getTemperature())) {
                draw.fill(26, 41, 70, 45, 0x44FF0000);
            }
        }
    }

    private static Map<EmiIngredient, Boolean> getAvailable(EmiRecipe recipe, EmiCraftContext<KegMenu> context) {
        IdentityHashMap<EmiIngredient, Boolean> availableForCrafting = new IdentityHashMap<EmiIngredient, Boolean>();
        if (recipe instanceof KegEmiRecipe) {
            KegEmiRecipe kegRecipe = (KegEmiRecipe)recipe;
            List<Boolean> list = KegEmiRecipeHandler.getCraftAvailability(kegRecipe, context);
            List inputs = recipe.getInputs();
            if (list.size() != inputs.size()) {
                return Map.of();
            }
            for (int i = 0; i < list.size(); ++i) {
                availableForCrafting.put((EmiIngredient)inputs.get(i), list.get(i));
            }
            return availableForCrafting;
        }
        return Collections.emptyMap();
    }

    private static boolean validFluidOrCanEmpty(KegEmiRecipe recipe, @Nullable EmiIngredient fluidIngredient, @Nullable EmiIngredient fluidItemIngredient, EmiCraftContext<KegMenu> context) {
        boolean success = false;
        Object2LongOpenHashMap used = new Object2LongOpenHashMap();
        EmiIngredient emptyingIngredient = KegEmiRecipeHandler.getEmptyingIngredient(recipe, context);
        if (emptyingIngredient == null) {
            return KegEmiRecipeHandler.hasFluidOrAssociatedItem(fluidIngredient, fluidItemIngredient, context);
        }
        for (EmiStack stack : emptyingIngredient.getEmiStacks()) {
            long desired = stack.getAmount();
            if (!context.getInventory().inventory.containsKey(stack)) continue;
            EmiStack identity = (EmiStack)context.getInventory().inventory.get(stack);
            long alreadyUsed = used.getOrDefault((Object)identity, 0L);
            long available = identity.getAmount() - alreadyUsed;
            if (available < desired) continue;
            used.put((Object)identity, desired + alreadyUsed);
            success = true;
            break;
        }
        return success && KegEmiRecipeHandler.hasFluidOrAssociatedItem(fluidIngredient, fluidItemIngredient, context);
    }

    private static boolean hasFluid(@Nullable EmiIngredient fluidIngredient, EmiCraftContext<KegMenu> context) {
        AbstractedFluidStack stack = ((KegMenu)context.getScreenHandler()).kegTank.getAbstractedFluid();
        return fluidIngredient == null && stack.isEmpty() || fluidIngredient != null && fluidIngredient.getEmiStacks().stream().anyMatch(emiStack -> emiStack.isEqual(EmiStack.of((Fluid)stack.fluid(), (DataComponentPatch)stack.componentPatch(), (long)stack.amount())));
    }

    private static boolean hasFluidOrAssociatedItem(@Nullable EmiIngredient fluidIngredient, @Nullable EmiIngredient fluidItemIngredient, EmiCraftContext<KegMenu> context) {
        return KegEmiRecipeHandler.hasFluid(fluidIngredient, context) || fluidItemIngredient == null || KegEmiRecipeHandler.hasItems(List.of(fluidItemIngredient), context);
    }

    @Nullable
    public static EmiIngredient getEmptyingIngredient(KegEmiRecipe kegRecipe, EmiCraftContext<KegMenu> context) {
        if (((KegMenu)context.getScreenHandler()).kegTank.isEmpty() || kegRecipe.getFluidInput() != null && kegRecipe.getFluidInput().getEmiStacks().stream().anyMatch(emiStack -> {
            AbstractedFluidStack stack = ((KegMenu)context.getScreenHandler()).kegTank.getAbstractedFluid();
            EmiStack tankEmiStack = EmiStack.of((Fluid)stack.fluid(), (DataComponentPatch)stack.componentPatch(), (long)(stack.amount() / kegRecipe.getFluidInput().getAmount()));
            return emiStack.isEqual(tankEmiStack);
        })) {
            return null;
        }
        AbstractedFluidStack stack = ((KegMenu)context.getScreenHandler()).kegTank.getAbstractedFluid();
        ArrayList<EmiIngredient> ingredients = new ArrayList<EmiIngredient>(EmiApi.getRecipeManager().getRecipes(BnCRecipeCategories.POURING).stream().filter(recipe -> {
            if (!(recipe instanceof PouringEmiRecipe)) {
                return false;
            }
            PouringEmiRecipe pouringRecipe = (PouringEmiRecipe)recipe;
            EmiStack tankEmiStack = EmiStack.of((Fluid)stack.fluid(), (DataComponentPatch)stack.componentPatch(), (long)(stack.amount() / pouringRecipe.getFluidInput().getAmount()));
            return ((EmiStack)pouringRecipe.getFluidInput().getEmiStacks().getFirst()).isEqual(tankEmiStack);
        }).map(recipe -> {
            PouringEmiRecipe pouringRecipe = (PouringEmiRecipe)recipe;
            return ((PouringEmiRecipe)recipe).getItemInputs().getFirst().copy().setAmount(stack.amount() / pouringRecipe.getFluidInput().getAmount());
        }).toList());
        if (ingredients.isEmpty()) {
            return null;
        }
        return EmiIngredient.of(ingredients);
    }

    private static List<Boolean> getCraftAvailability(KegEmiRecipe recipe, EmiCraftContext<KegMenu> context) {
        Object2LongOpenHashMap used = new Object2LongOpenHashMap();
        ArrayList states = Lists.newArrayList();
        block0: for (EmiIngredient ingredient : recipe.getItemInputs()) {
            for (EmiStack stack : ingredient.getEmiStacks()) {
                long desired = stack.getAmount();
                if (!context.getInventory().inventory.containsKey(stack)) continue;
                EmiStack identity = (EmiStack)context.getInventory().inventory.get(stack);
                long alreadyUsed = used.getOrDefault((Object)identity, 0L);
                long available = identity.getAmount() - alreadyUsed;
                if (available < desired) continue;
                used.put((Object)identity, desired + alreadyUsed);
                states.add(true);
                continue block0;
            }
            states.add(false);
        }
        if (recipe.getFluidItemInput() != null && ((KegMenu)context.getScreenHandler()).kegTank.isEmpty()) {
            boolean success = false;
            for (EmiStack stack : recipe.getFluidItemInput().getEmiStacks()) {
                long desired = stack.getAmount();
                if (!context.getInventory().inventory.containsKey(stack)) continue;
                EmiStack identity = (EmiStack)context.getInventory().inventory.get(stack);
                long alreadyUsed = used.getOrDefault((Object)identity, 0L);
                long available = identity.getAmount() - alreadyUsed;
                if (available < desired) continue;
                used.put((Object)identity, desired + alreadyUsed);
                success = true;
                break;
            }
            states.add(success);
        } else if (recipe.getFluidInput() != null) {
            boolean success = false;
            for (EmiStack stack : recipe.getFluidInput().getEmiStacks()) {
                long desired = stack.getAmount();
                AbstractedFluidStack tankStack = ((KegMenu)context.getScreenHandler()).kegTank.getAbstractedFluid();
                EmiStack tankEmiStack = EmiStack.of((Fluid)tankStack.fluid(), (DataComponentPatch)tankStack.componentPatch(), (long)tankStack.amount());
                if (tankStack.amount() < desired || !stack.isEqual(tankEmiStack)) continue;
                success = true;
                break;
            }
            states.add(success);
        }
        return states;
    }

    public boolean supportsRecipe(EmiRecipe recipe) {
        return (recipe.getCategory() == BnCRecipeCategories.FERMENTING || recipe.getCategory() == BnCRecipeCategories.POURING) && recipe.supportsRecipeTree();
    }

    public static enum InputType {
        ITEM,
        FILL,
        EMPTY;

        public static final IntFunction<InputType> BY_ID;
        public static final StreamCodec<ByteBuf, InputType> STREAM_CODEC;

        static {
            BY_ID = ByIdMap.continuous(Enum::ordinal, (Object[])InputType.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
            STREAM_CODEC = ByteBufCodecs.idMapper(BY_ID, Enum::ordinal);
        }
    }
}

